/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit.extra;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.webswing.common.WindowActionType;
import org.webswing.dispatch.WebPaintDispatcher;
import org.webswing.model.s2c.AccessibilityMsg;
import org.webswing.toolkit.FocusEventCause;
import org.webswing.toolkit.extra.WindowEventHandler;
import org.webswing.toolkit.extra.WindowHierarchyTree;
import org.webswing.toolkit.util.Services;
import org.webswing.toolkit.util.Util;
import sun.awt.ModalExclude;

public class WindowManager {
    private static WindowManager singleton = null;
    protected WindowHierarchyTree zorder = new WindowHierarchyTree();
    protected Window activeWindow = null;
    private WindowEventHandler eventhandler = new WindowEventHandler();
    private String currentCursor = "default";

    protected WindowManager() {
    }

    public static WindowManager getInstance() {
        if (singleton == null) {
            singleton = new WindowManager();
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bringToFront(Window w) {
        Object object = Util.getWebToolkit().getTreeLock();
        synchronized (object) {
            Object object2 = WebPaintDispatcher.webPaintLock;
            synchronized (object2) {
                if (w != null && !w.isEnabled()) {
                    return;
                }
                if (Util.discoverFileChooser(this.activeWindow) != null && w == null) {
                    return;
                }
                if ((w == null || w.isFocusableWindow()) && this.activeWindow != w) {
                    Window oldActiveWindow = this.activeWindow;
                    this.activeWindow = w;
                    if (this.activeWindow != null) {
                        WindowEvent gainedFocusWindowEvent = new WindowEvent(this.activeWindow, 207, this.activeWindow, 0, 0);
                        Util.getWebToolkit().getEventDispatcher().dispatchEventInSwing(this.activeWindow, gainedFocusWindowEvent);
                        Util.getWebToolkit().getPaintDispatcher().notifyWindowActivated(this.activeWindow);
                    }
                    if (oldActiveWindow != null) {
                        Util.getWebToolkit().getPaintDispatcher().notifyWindowDeactivated(oldActiveWindow);
                    }
                    if (Util.discoverFileChooser(oldActiveWindow) != null) {
                        Util.getWebToolkit().getPaintDispatcher().notifyFileDialogHidden();
                    }
                    if (Util.discoverFileChooser(this.activeWindow) != null) {
                        Util.getWebToolkit().getPaintDispatcher().notifyFileDialogActive(this.activeWindow);
                    }
                }
                if (w != null) {
                    this.zorder.bringToFront(w);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindow(Window target) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.zorder.removeWindow(target);
            if (target == this.activeWindow) {
                this.activeWindow = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bringToBack(Window w) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
        }
    }

    public Window getActiveWindow() {
        return this.activeWindow;
    }

    public boolean isWindowActive(Window w) {
        return this.activeWindow == w;
    }

    public void activateWindow(Window w) {
        this.activateWindow(w, 0, 0);
    }

    public boolean activateWindow(Window w, Component newFocusOwner, int x, int y, boolean tmp, boolean focusedWindowChangeAllowed, FocusEventCause cause) {
        boolean success = false;
        boolean newWindow = false;
        if (!this.zorder.contains(w)) {
            if (w.getClass().getName().contains("JLightweightFrame")) {
                return false;
            }
            this.zorder.addWindow(w);
            newWindow = true;
        }
        if (this.isBlockedByModality(w, newWindow)) {
            return false;
        }
        if (!w.isEnabled()) {
            return false;
        }
        if (focusedWindowChangeAllowed || this.activeWindow == w) {
            if (w.isFocusableWindow()) {
                success = this.deliverFocus(w, newFocusOwner, tmp, cause);
            }
            if (SwingUtilities.isRectangleContainingRectangle(new Rectangle(0, 0, w.getWidth(), w.getHeight()), new Rectangle(x, y, 0, 0))) {
                this.bringToFront(w);
            } else {
                this.bringToFront(null);
            }
        }
        return success;
    }

    public boolean isBlockedByModality(Window w, boolean newWindow) {
        return this.zorder.isInModalBranch(this.activeWindow) && !(w instanceof ModalExclude) && w.getModalExclusionType() == Dialog.ModalExclusionType.NO_EXCLUDE && (this.zorder.isInFullModalBranch(this.activeWindow) ? (!this.isModal(w) || !newWindow) && !this.zorder.isInSameModalBranch(this.activeWindow, w) : this.zorder.isParent(w, this.activeWindow));
    }

    public boolean deliverFocus(Component hwComponent, Component newFocusOwner, boolean tmp, FocusEventCause cause) {
        boolean success = false;
        if (newFocusOwner != null && newFocusOwner.isFocusable()) {
            int result = Util.getWebToolkit().shouldNativelyFocusHeavyweight(hwComponent, newFocusOwner, tmp, true, new Date().getTime(), cause);
            switch (result) {
                case 1: {
                    success = true;
                    break;
                }
                case 2: {
                    Util.getWebToolkit().deliverFocus(hwComponent, newFocusOwner, tmp, true, new Date().getTime(), cause);
                    success = true;
                    break;
                }
            }
        }
        return success;
    }

    protected boolean isModal(Window w) {
        return w instanceof Dialog && ((Dialog)w).isModal();
    }

    public void activateWindow(Window w, int x, int y) {
        this.activateWindow(w, null, x, y, false, true, FocusEventCause.NATIVE_SYSTEM);
    }

    public Window getVisibleWindowOnPosition(int x, int y) {
        Window positionWin = this.zorder.getVisibleWindowOnPosition(x, y);
        if (positionWin == null) {
            positionWin = this.activeWindow;
        }
        return positionWin;
    }

    public Component getVisibleComponentOnPosition(int x, int y, String winId) {
        Component result = null;
        Window positionWin = winId != null && winId.length() > 0 ? Util.findWindowById(winId) : this.zorder.getVisibleWindowOnPosition(x, y);
        if (positionWin != null) {
            result = Util.getPeer(positionWin).getHwComponentAt(x, y);
        }
        return result;
    }

    public Map<String, List<Rectangle>> extractNonVisibleAreas() {
        return this.zorder.extractNonVisibleAreas();
    }

    public List<String> getZOrder() {
        return this.zorder.getZOrder();
    }

    public void requestRepaintAfterMove(Window w, Rectangle originalPosition) {
        this.zorder.requestRepaintAfterMove(w, originalPosition);
    }

    public void handleWindowDecorationEvent(Window w, MouseEvent e) {
        AccessibilityMsg accessibilityMsg;
        Point mousePointer = new Point(e.getX(), e.getY());
        WindowActionType wat = Services.getImageService().getWindowDecorationTheme().getAction(w, mousePointer);
        this.eventhandler.handle(wat, e);
        if (wat.isButtonActionType() && (accessibilityMsg = Services.getImageService().getWindowDecorationTheme().getAccessible(w, wat, mousePointer)) != null) {
            Util.getWebToolkit().getPaintDispatcher().notifyAccessibilityInfoUpdate(accessibilityMsg);
        }
    }

    public boolean isLockedToWindowDecorationHandler() {
        return this.eventhandler.isEventHandlingLocked();
    }

    public Window getLockedToWindow() {
        return this.eventhandler.getLockedToWindow();
    }

    public String getCurrentCursor() {
        return this.currentCursor;
    }

    public void setCurrentCursor(String currentCursor) {
        this.currentCursor = currentCursor;
    }
}

