/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit;

import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.webswing.component.HtmlPanelImpl;
import org.webswing.dispatch.PaintDispatcher;
import org.webswing.model.Msg;
import org.webswing.model.c2s.ActionEventMsgIn;
import org.webswing.model.c2s.ConnectionHandshakeMsgIn;
import org.webswing.model.internal.ApiCallMsgInternal;
import org.webswing.model.internal.ApiEventMsgInternal;
import org.webswing.toolkit.WebClipboard;
import org.webswing.toolkit.WebToolkit;
import org.webswing.toolkit.WebWindowPeer;
import org.webswing.toolkit.api.WebswingApi;
import org.webswing.toolkit.api.WebswingApiException;
import org.webswing.toolkit.api.action.WebActionEvent;
import org.webswing.toolkit.api.action.WebActionListener;
import org.webswing.toolkit.api.action.WebWindow;
import org.webswing.toolkit.api.clipboard.BrowserTransferable;
import org.webswing.toolkit.api.clipboard.PasteRequestContext;
import org.webswing.toolkit.api.clipboard.WebswingClipboardData;
import org.webswing.toolkit.api.component.Dockable;
import org.webswing.toolkit.api.component.HtmlPanel;
import org.webswing.toolkit.api.lifecycle.OnBeforeShutdownEvent;
import org.webswing.toolkit.api.lifecycle.ShutdownReason;
import org.webswing.toolkit.api.lifecycle.WebswingShutdownListener;
import org.webswing.toolkit.api.security.UserEvent;
import org.webswing.toolkit.api.security.WebswingUser;
import org.webswing.toolkit.api.security.WebswingUserListener;
import org.webswing.toolkit.api.url.WebswingUrlState;
import org.webswing.toolkit.api.url.WebswingUrlStateChangeEvent;
import org.webswing.toolkit.api.url.WebswingUrlStateChangeListener;
import org.webswing.toolkit.util.DeamonThreadFactory;
import org.webswing.toolkit.util.GitRepositoryState;
import org.webswing.toolkit.util.Logger;
import org.webswing.toolkit.util.Services;
import org.webswing.toolkit.util.Util;

public class WebswingApiImpl
implements WebswingApi {
    private final List<WebswingShutdownListener> shutdownListeners = Collections.synchronizedList(new ArrayList());
    private final List<WebswingUserListener> userConnectionListeners = Collections.synchronizedList(new ArrayList());
    private final List<WebswingUrlStateChangeListener> urlStateChangeListeners = Collections.synchronizedList(new ArrayList());
    private final List<WebActionListener> browserActionListeners = Collections.synchronizedList(new ArrayList());
    private ExecutorService apiProcessor = Executors.newSingleThreadExecutor(DeamonThreadFactory.getInstance("Webswing API Processor"));
    private WebswingUser primaryUser;
    private WebswingUser mirrorUser;
    private WebswingUrlState state = WebswingApiImpl.parseState(System.getProperty("webswing.initialUrl"));

    public WebswingUser getPrimaryUser() {
        return this.primaryUser;
    }

    public WebswingUser getMirrorViewUser() {
        return this.mirrorUser;
    }

    public Boolean primaryUserHasRole(String role) throws WebswingApiException {
        try {
            return (Boolean)this.apiCall(ApiCallMsgInternal.ApiMethod.HasRole, new Serializable[]{role});
        }
        catch (WebswingApiException e) {
            Logger.error("Failed to resolve role assignemnt.", new Object[]{e});
            throw e;
        }
    }

    public Boolean primaryUserIsPermitted(String permission) throws WebswingApiException {
        try {
            return (Boolean)this.apiCall(ApiCallMsgInternal.ApiMethod.IsPermitted, new Serializable[]{permission});
        }
        catch (WebswingApiException e) {
            Logger.error("Failed to resolve role assignemnt.", new Object[]{e});
            throw e;
        }
    }

    public void addUserConnectionListener(WebswingUserListener listener) {
        if (listener != null) {
            this.userConnectionListeners.add(listener);
        }
    }

    public void removeUserConnectionListener(WebswingUserListener listener) {
        if (listener != null) {
            this.userConnectionListeners.remove(listener);
        }
    }

    public void notifyShutdown(int forceKillTimeout) {
        Util.getWebToolkit().getPaintDispatcher().notifyApplicationExiting(forceKillTimeout);
    }

    public void addShutdownListener(WebswingShutdownListener listener) {
        if (listener != null) {
            this.shutdownListeners.add(listener);
        }
    }

    public void removeShutdownListener(WebswingShutdownListener listener) {
        if (listener != null) {
            this.shutdownListeners.remove(listener);
        }
    }

    private <T> T apiCall(ApiCallMsgInternal.ApiMethod m, Serializable ... args) throws WebswingApiException {
        ApiCallMsgInternal msg = new ApiCallMsgInternal();
        msg.setMethod(m);
        msg.setArgs(args);
        try {
            ApiCallMsgInternal result = (ApiCallMsgInternal)Services.getConnectionService().sendObjectSync(msg, msg.getCorrelationId());
            return (T)result.getResult();
        }
        catch (Exception e) {
            throw new WebswingApiException("API call failed.", (Throwable)e);
        }
    }

    void processEvent(Msg msg) {
        ActionEventMsgIn action;
        if (msg instanceof ConnectionHandshakeMsgIn) {
            ConnectionHandshakeMsgIn event = (ConnectionHandshakeMsgIn)msg;
            WebswingUrlState state = WebswingApiImpl.parseState(event.getUrl());
            if (this.state == null || !this.state.equals((Object)state)) {
                WebswingUrlState oldState = this.state;
                this.state = state;
                final WebswingUrlStateChangeEvent stateChangeEvent = this.createEvent(event.getUrl(), state, oldState);
                this.apiProcessor.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List list = WebswingApiImpl.this.urlStateChangeListeners;
                        synchronized (list) {
                            try {
                                WebswingApiImpl.this.fireUrlChangeListener(stateChangeEvent);
                            }
                            catch (Exception e) {
                                Logger.error("Processing URL change api event failed.", e);
                            }
                        }
                    }
                });
            }
        } else if (msg instanceof ApiEventMsgInternal) {
            final ApiEventMsgInternal event = (ApiEventMsgInternal)msg;
            this.apiProcessor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = WebswingApiImpl.this.userConnectionListeners;
                    synchronized (list) {
                        try {
                            UserEvent e = new UserEvent((WebswingUser)new WebswingUserInfo(event.getArgs()));
                            switch (event.getEvent()) {
                                case UserConnected: {
                                    WebswingApiImpl.this.primaryUser = e.getUser();
                                    break;
                                }
                                case UserDisconnected: {
                                    WebswingApiImpl.this.primaryUser = null;
                                    break;
                                }
                                case MirrorViewConnected: {
                                    WebswingApiImpl.this.mirrorUser = e.getUser();
                                    break;
                                }
                                case MirrorViewDisconnected: {
                                    WebswingApiImpl.this.mirrorUser = null;
                                    break;
                                }
                            }
                            WebswingApiImpl.this.fireUserListener(event.getEvent(), e);
                        }
                        catch (Exception e) {
                            Logger.error("Processing User api event failed.", e);
                        }
                    }
                }
            });
        } else if (msg instanceof ActionEventMsgIn && (action = (ActionEventMsgIn)msg) != null) {
            this.apiProcessor.submit(() -> {
                if (action.getWindowId() != null) {
                    Window w = Util.findWindowById(action.getWindowId());
                    HtmlPanel hp = Util.findHtmlPanelById(action.getWindowId());
                    if (w != null && w instanceof WebWindow) {
                        if (action.getEventType() == ActionEventMsgIn.ActionEventType.init) {
                            ((WebWindow)w).handleWindowInitialized();
                        } else {
                            ((WebWindow)w).handleWebActionEvent(new WebActionEvent(action.getActionName(), action.getData(), action.getBinaryData()));
                        }
                    } else if (hp != null) {
                        if (action.getEventType() == ActionEventMsgIn.ActionEventType.init) {
                            hp.handleWindowInitialized();
                        } else {
                            hp.handleWebActionEvent(new WebActionEvent(action.getActionName(), action.getData(), action.getBinaryData()));
                        }
                    } else if (action.getEventType() != ActionEventMsgIn.ActionEventType.init) {
                        this.fireBrowserActionListener(new WebActionEvent(action.getActionName(), action.getData(), action.getBinaryData()));
                    }
                } else {
                    this.fireBrowserActionListener(new WebActionEvent(action.getActionName(), action.getData(), action.getBinaryData()));
                }
            });
        }
    }

    private static WebswingUrlState parseState(String url) {
        if (url.contains("#")) {
            String hash = url.substring(url.indexOf("#") + 1);
            try {
                if (hash.contains("&")) {
                    List<String> params = Arrays.asList(hash.split("&"));
                    Iterator<String> i = params.iterator();
                    String path = URLDecoder.decode(i.next(), "UTF-8");
                    LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
                    while (i.hasNext()) {
                        String param = i.next();
                        String key = URLDecoder.decode(param, "UTF-8");
                        String value = null;
                        if (param.contains("=")) {
                            int eq = param.indexOf("=");
                            key = URLDecoder.decode(param.substring(0, eq), "UTF-8");
                            value = URLDecoder.decode(param.substring(eq + 1), "UTF-8");
                        }
                        parameters.put(key, value);
                    }
                    return new WebswingUrlState(path, parameters);
                }
                String path = URLDecoder.decode(hash, "UTF-8");
                return new WebswingUrlState(path);
            }
            catch (UnsupportedEncodingException e) {
                Logger.error("Failed to decode url", e);
            }
        }
        return new WebswingUrlState();
    }

    private WebswingUrlStateChangeEvent createEvent(String url, WebswingUrlState state, WebswingUrlState oldState) {
        return new WebswingUrlStateChangeEventImpl(url, new WebswingUrlState(state), oldState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireShutdownListeners() {
        List<WebswingShutdownListener> list = this.shutdownListeners;
        synchronized (list) {
            if (this.shutdownListeners.size() == 0) {
                Logger.info("No shutdown listener found. Using default shutdown procedure.", new Object[0]);
                Util.getWebToolkit().defaultShutdownProcedure();
            } else {
                for (WebswingShutdownListener l : this.shutdownListeners) {
                    try {
                        l.onShutdown();
                    }
                    catch (Exception e) {
                        Logger.error("Shutdown Listener failed.", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int fireBeforeShutdownListeners(ShutdownReason reason) {
        List<WebswingShutdownListener> list = this.shutdownListeners;
        synchronized (list) {
            int maxDelay = 0;
            for (WebswingShutdownListener l : this.shutdownListeners) {
                try {
                    maxDelay = Math.max(l.onBeforeShutdown(new OnBeforeShutdownEvent(reason)), maxDelay);
                }
                catch (Exception e) {
                    Logger.error("Before Shutdown Listener failed.", e);
                }
            }
            return maxDelay;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUserListener(ApiEventMsgInternal.ApiEventType type, UserEvent event) {
        List<WebswingUserListener> list = this.userConnectionListeners;
        synchronized (list) {
            for (WebswingUserListener l : this.userConnectionListeners) {
                try {
                    switch (type) {
                        case UserConnected: {
                            l.onPrimaryUserConnected(event);
                            break;
                        }
                        case UserDisconnected: {
                            l.onPrimaryUserDisconnected(event);
                            break;
                        }
                        case MirrorViewConnected: {
                            l.onMirrorViewConnected(event);
                            break;
                        }
                        case MirrorViewDisconnected: {
                            l.onMirrorViewDisconnected(event);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    Logger.error("User Listener failed.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUrlChangeListener(WebswingUrlStateChangeEvent event) {
        List<WebswingUrlStateChangeListener> list = this.urlStateChangeListeners;
        synchronized (list) {
            for (WebswingUrlStateChangeListener l : this.urlStateChangeListeners) {
                try {
                    l.onUrlStateChange(event);
                }
                catch (Exception e) {
                    Logger.error("Url change Listener failed.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBrowserActionListener(WebActionEvent actionEvent) {
        List<WebActionListener> list = this.browserActionListeners;
        synchronized (list) {
            for (WebActionListener l : this.browserActionListeners) {
                try {
                    l.actionPerformed(actionEvent);
                }
                catch (Exception e) {
                    Logger.error("Browser action listener failed.", e);
                }
            }
        }
    }

    public String getWebswingVersion() {
        return GitRepositoryState.getInstance().getDescribe();
    }

    public void setUrlState(WebswingUrlState state) {
        this.setUrlState(state, false);
    }

    public void setUrlState(WebswingUrlState state, boolean fireChangeEvent) {
        if (state == null) {
            state = new WebswingUrlState();
        }
        String url = "#";
        try {
            if (state.getPath() != null) {
                url = url + URLEncoder.encode(state.getPath(), "UTF-8");
            }
            if (state.getParameters() != null && state.getParameters().size() > 0) {
                for (String key : state.getParameters().keySet()) {
                    url = url + "&" + URLEncoder.encode(key, "UTF-8");
                    String value = (String)state.getParameters().get(key);
                    if (value == null) continue;
                    url = url + "=" + URLEncoder.encode(value, "UTF-8");
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            Logger.error("Failed to encode URL state.", e);
        }
        if (!fireChangeEvent) {
            this.state = state;
        }
        Util.getWebToolkit().getPaintDispatcher().notifyUrlRedirect(url);
    }

    public WebswingUrlState getUrlState() {
        return this.state == null ? null : new WebswingUrlState(this.state);
    }

    public void addUrlStateChangeListener(WebswingUrlStateChangeListener listener) {
        if (listener != null) {
            this.urlStateChangeListeners.add(listener);
        }
    }

    public void resetInactivityTimeout() {
        Services.getConnectionService().resetInactivityTimers();
    }

    public void removeUrlStateChangeListener(WebswingUrlStateChangeListener listener) {
        if (listener != null) {
            this.urlStateChangeListeners.remove(listener);
        }
    }

    public BrowserTransferable getBrowserClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard instanceof WebClipboard) {
            return ((WebClipboard)clipboard).getBrowserClipboard();
        }
        return null;
    }

    public BrowserTransferable getBrowserClipboard(PasteRequestContext ctx) {
        WebClipboard webclipboard = Util.getWebToolkit().getWebswingClipboard();
        return webclipboard.requestClipboard(ctx);
    }

    public void sendClipboard(WebswingClipboardData content) {
        PaintDispatcher paintDispatcher;
        if (content != null && (paintDispatcher = Util.getWebToolkit().getPaintDispatcher()) != null) {
            paintDispatcher.notifyCopyEvent(content);
        }
    }

    public void sendClipboard() {
        PaintDispatcher paintDispatcher;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        WebswingClipboardData content = WebClipboard.toWebswingClipboardData(transferable);
        if (content != null && (paintDispatcher = Util.getWebToolkit().getPaintDispatcher()) != null) {
            paintDispatcher.notifyCopyEvent(content);
        }
    }

    public void addBrowserActionListener(WebActionListener listener) {
        if (listener != null) {
            this.browserActionListeners.add(listener);
        }
    }

    public void removeBrowserActionListener(WebActionListener listener) {
        if (listener != null) {
            this.browserActionListeners.remove(listener);
        }
    }

    public void sendActionEvent(String actionName, String data, byte[] binaryData) {
        this.sendActionEvent((String)null, actionName, data, binaryData);
    }

    public void sendActionEvent(WebWindow webWindow, String actionName, String data, byte[] binaryData) {
        if (webWindow == null || !(webWindow instanceof Window) && !(webWindow instanceof HtmlPanel)) {
            this.sendActionEvent(actionName, data, binaryData);
            return;
        }
        String windowId = null;
        if (webWindow instanceof HtmlPanel) {
            windowId = System.identityHashCode(webWindow) + "";
        }
        if (webWindow instanceof Window) {
            windowId = ((WebWindowPeer)WebToolkit.targetToPeer(webWindow)).getGuid();
        }
        if (windowId == null) {
            this.sendActionEvent(actionName, data, binaryData);
            return;
        }
        this.sendActionEvent(windowId, actionName, data, binaryData);
    }

    private void sendActionEvent(String windowId, String actionName, String data, byte[] binaryData) {
        PaintDispatcher paintDispatcher = Util.getWebToolkit().getPaintDispatcher();
        if (paintDispatcher != null) {
            paintDispatcher.notifyActionEvent(windowId, actionName, data, binaryData);
        }
    }

    public HtmlPanel createHtmlPanel() {
        if (!this.isCompositingWindowManager()) {
            throw new IllegalArgumentException("Not allowed to create HtmlPanel! Enable compositing window manager.");
        }
        HtmlPanelImpl htmlPanel = new HtmlPanelImpl();
        htmlPanel.setFocusable(true);
        Util.getWebToolkit().getPaintDispatcher().registerHtmlPanel(htmlPanel);
        return htmlPanel;
    }

    public HtmlPanel createHtmlPanelForWebContainerComponent(Container webContainer, JComponent componentParentOfHtmlPanel) {
        if (!this.isCompositingWindowManager()) {
            throw new IllegalArgumentException("Not allowed to create HtmlPanel! Enable compositing window manager.");
        }
        HtmlPanelImpl htmlPanel = new HtmlPanelImpl(webContainer, componentParentOfHtmlPanel);
        Util.getWebToolkit().getPaintDispatcher().registerHtmlPanel(htmlPanel);
        return htmlPanel;
    }

    public void registerWebContainer(Container container) {
        if (!this.isCompositingWindowManager()) {
            throw new IllegalArgumentException("Not allowed to create web container! Enable compositing window manager.");
        }
        Util.getWebToolkit().getPaintDispatcher().registerWebContainer(container);
    }

    public boolean isCompositingWindowManager() {
        return Util.isCompositingWM();
    }

    public boolean isDockingEnabled(Window window) {
        if (!this.isCompositingWindowManager()) {
            return false;
        }
        switch (Util.getDockMode()) {
            case "NONE": {
                return false;
            }
            case "ALL": {
                return true;
            }
            case "MARKED": {
                return window instanceof Dockable;
            }
        }
        return false;
    }

    public void toggleWindowDock(Window window, boolean undock) {
        if (!this.isDockingEnabled(window)) {
            throw new IllegalArgumentException("Not allowed to change dock state! Enable compositing window manager and docking mode in config.");
        }
        Util.toggleWindowDock(window, undock);
    }

    public void toggleWindowDock(Window window) {
        if (!this.isDockingEnabled(window)) {
            throw new IllegalArgumentException("Not allowed to change dock state! Enable compositing window manager and docking mode in config.");
        }
        Util.toggleWindowDock(window, !Util.isWindowUndocked(window));
    }

    public boolean isUndocked(Window window) {
        if (!this.isCompositingWindowManager()) {
            throw new IllegalArgumentException("Not allowed to check dock state of a window! Enable compositing window manager.");
        }
        return Util.isWindowUndocked(window);
    }

    public boolean isTouchMode() {
        return Util.isTouchMode();
    }

    public void registerCustomFileChooser(JFileChooser fileChooser, Window parent) {
        Util.getWebToolkit().getPaintDispatcher().registerFileChooserWindows(fileChooser, parent);
    }

    public class WebswingUserInfo
    implements WebswingUser {
        private String userId;
        private HashMap<String, Serializable> userAttributes;

        WebswingUserInfo(Serializable ... attribs) {
            this.userId = (String)((Object)attribs[0]);
            this.userAttributes = (HashMap)attribs[1];
        }

        public String getUserId() {
            return this.userId;
        }

        public Map<String, Serializable> getUserAttributes() {
            return this.userAttributes;
        }

        public String toString() {
            return this.getUserId();
        }
    }

    public class WebswingUrlStateChangeEventImpl
    implements WebswingUrlStateChangeEvent {
        private String url;
        private WebswingUrlState state;
        private WebswingUrlState oldState;

        WebswingUrlStateChangeEventImpl(String url, WebswingUrlState state, WebswingUrlState oldState) {
            this.url = url;
            this.state = state;
            this.oldState = oldState;
        }

        public String getFullUrl() {
            return this.url;
        }

        public WebswingUrlState getState() {
            return this.state;
        }

        public WebswingUrlState getOldState() {
            return this.oldState;
        }
    }
}

