/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.peer.WindowPeer;
import org.webswing.toolkit.WebContainerPeer;
import org.webswing.toolkit.WebToolkit;
import org.webswing.toolkit.api.component.Dockable;
import org.webswing.toolkit.extra.WindowManager;
import org.webswing.toolkit.util.Logger;
import org.webswing.toolkit.util.Util;
import sun.java2d.InvalidPipeException;

public abstract class WebWindowPeer
extends WebContainerPeer
implements WindowPeer {
    private static final int VALIDATE_BOUNDS_THRESHOLD = 40;
    private Boolean undecoratedOverride;
    private boolean undocked;

    public WebWindowPeer(Window t) {
        super(t);
        Font font = t.getFont();
        if (font == null) {
            t.setFont(WebToolkit.defaultFont);
        }
        if (t instanceof Dockable && ((Dockable)t).isAutoUndock()) {
            this.setUndocked(true);
        }
    }

    @Override
    public void toFront() {
        WindowManager.getInstance().bringToFront((Window)this.target);
    }

    @Override
    public void toBack() {
        WindowManager.getInstance().bringToBack((Window)this.target);
    }

    public void setAlwaysOnTop(boolean paramBoolean) {
        WindowManager.getInstance().bringToFront((Window)this.target);
    }

    @Override
    public void updateFocusableWindowState() {
    }

    public boolean requestWindowFocus() {
        Util.getWebToolkit().getWindowManager().activateWindow((Window)this.target);
        return true;
    }

    @Override
    public void setModalBlocked(Dialog paramDialog, boolean paramBoolean) {
    }

    @Override
    public void updateMinimumSize() {
    }

    @Override
    public void updateIconImages() {
    }

    @Override
    public void setOpacity(float o) {
        this.opacity = o;
    }

    @Override
    public void setOpaque(boolean paramBoolean) {
    }

    @Override
    public void repositionSecurityWarning() {
    }

    @Override
    public void updateWindow() {
    }

    @Override
    public void show() {
        Util.getWebToolkit().getWindowManager().activateWindow((Window)this.target);
    }

    @Override
    public void hide() {
        Util.getWebToolkit().getWindowManager().removeWindow((Window)this.target);
        this.notifyWindowClosed();
    }

    public void setTitle(String title) {
        this.updateWindowDecorationImage();
    }

    public void setResizable(boolean resizeable) {
    }

    @Override
    protected Point validate(int x, int y, int w, int h) {
        if (Boolean.getBoolean("webswing.disableWindowPositionValidation") || Util.isCompositingWM()) {
            return new Point(x, y);
        }
        Point result = new Point(x, y);
        if (w == 0 && h == 0) {
            return result;
        }
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Insets insets = this.getInsets();
        if (screen.height < insets.top || screen.width < 40) {
            return result;
        }
        if (y < 0) {
            result.y = 0;
        }
        if (y > screen.height - insets.top) {
            result.y = screen.height - insets.top;
        }
        if (x < (w - 40) * -1) {
            result.x = (w - 40) * -1;
        }
        if (x > screen.width - 40) {
            result.x = screen.width - 40;
        }
        if (this.target instanceof Frame && ((Frame)this.target).getExtendedState() == 6) {
            result.x = 0;
            result.y = 0;
        }
        if (result.x != x || result.y != y) {
            ((Component)this.target).setLocation(result);
        }
        return result;
    }

    @Override
    public void updateAlwaysOnTopState() {
    }

    public void setUndecoratedOverride(boolean undecorated) {
        this.undecoratedOverride = undecorated;
        if (this.target instanceof Window) {
            Window win = (Window)this.target;
            try {
                this.replaceSurfaceData(win.getX(), win.getY(), win.getWidth(), win.getHeight());
            }
            catch (InvalidPipeException e) {
                Logger.error("WebWindowPeer:setUndecoratedOverride", e);
            }
        }
    }

    public Boolean getUndecoratedOverride() {
        return this.undecoratedOverride;
    }

    public boolean isUndocked() {
        return this.undocked;
    }

    public void setUndocked(boolean undocked) {
        this.undocked = undocked;
        this.updateWindowDecorationImage();
        Util.getWebToolkit().getPaintDispatcher().notifyWindowDockStateChanged();
    }
}

