/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.common;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import org.webswing.dispatch.WebPaintDispatcher;
import org.webswing.toolkit.WebComponentPeer;
import org.webswing.toolkit.util.Util;

public class GraphicsWrapper
extends Graphics2D {
    private WebComponentPeer rootPaintComponent;
    private Point offset = new Point(0, 0);
    private Graphics2D original;

    public GraphicsWrapper(Graphics2D g, WebComponentPeer wcp) {
        this.original = g;
        this.rootPaintComponent = wcp;
    }

    public void setOffset(Point offset) {
        this.offset = offset;
    }

    private void addDirtyClipArea() {
        this.addDirtyRectangleArea(this.getClipBounds());
    }

    private void addDirtyRectangleArea(Rectangle r) {
        if (r == null) {
            this.notifyWindowAreaRepainted(null);
        } else {
            Rectangle clip = this.getClipBounds();
            if (clip != null) {
                r = clip.intersection(r);
            }
            if (r.width > 0 && r.height > 0) {
                Rectangle dirtyArea = this.getTransform().createTransformedShape(r).getBounds();
                dirtyArea.translate(this.offset.x, this.offset.y);
                this.notifyWindowAreaRepainted(dirtyArea);
            }
        }
    }

    private void notifyWindowAreaRepainted(Rectangle r) {
        if (r == null) {
            r = this.rootPaintComponent.getBounds();
        }
        Util.getWebToolkit().getPaintDispatcher().notifyWindowAreaRepainted(this.rootPaintComponent.getGuid(), r);
    }

    public WebComponentPeer getRootPaintComponent() {
        return this.rootPaintComponent;
    }

    public void setRootPaintComponent(WebComponentPeer rootPaintComponent) {
        this.rootPaintComponent = rootPaintComponent;
    }

    public Graphics getOriginal() {
        return this.original;
    }

    @Override
    public Graphics create() {
        GraphicsWrapper copy = new GraphicsWrapper((Graphics2D)this.original.create(), this.rootPaintComponent);
        return copy;
    }

    @Override
    public void translate(int x, int y) {
        this.original.translate(x, y);
    }

    @Override
    public Color getColor() {
        return this.original.getColor();
    }

    @Override
    public void setColor(Color c) {
        this.original.setColor(c);
    }

    @Override
    public void setPaintMode() {
        this.original.setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        this.original.setXORMode(c1);
    }

    @Override
    public Font getFont() {
        return this.original.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.original.setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.original.getFontMetrics(f);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.original.getClipBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.original.clipRect(x, y, width, height);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.original.setClip(x, y, width, height);
    }

    @Override
    public Shape getClip() {
        return this.original.getClip();
    }

    @Override
    public void setClip(Shape clip) {
        this.original.setClip(clip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.copyArea(x, y, width, height, dx, dy);
            Rectangle r = new Rectangle(x + dx, y + dy, width, height);
            this.addDirtyRectangleArea(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.drawLine(x1, y1, x2, y2);
            Rectangle r = new Rectangle(x1, y1, x2, y2);
            this.addDirtyRectangleArea(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillRect(int x, int y, int width, int height) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.fillRect(x, y, width, height);
            this.addDirtyRectangleArea(new Rectangle(x, y, width, height));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearRect(int x, int y, int width, int height) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.clearRect(x, y, width, height);
            this.addDirtyRectangleArea(new Rectangle(x, y, width, height));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
            this.addDirtyRectangleArea(new Rectangle(x, y, width, height));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
            this.addDirtyRectangleArea(new Rectangle(x, y, width, height));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawOval(int x, int y, int width, int height) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.drawOval(x, y, width, height);
            this.addDirtyRectangleArea(new Rectangle(x, y, width, height));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillOval(int x, int y, int width, int height) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.fillOval(x, y, width, height);
            this.addDirtyRectangleArea(new Rectangle(x, y, width, height));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.drawArc(x, y, width, height, startAngle, arcAngle);
            this.addDirtyRectangleArea(new Rectangle(x, y, width, height));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.fillArc(x, y, width, height, startAngle, arcAngle);
            this.addDirtyRectangleArea(new Rectangle(x, y, width, height));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.drawPolyline(xPoints, yPoints, nPoints);
            this.addDirtyClipArea();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.drawPolygon(xPoints, yPoints, nPoints);
            this.addDirtyClipArea();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.fillPolygon(xPoints, yPoints, nPoints);
            this.addDirtyClipArea();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawString(String str, int x, int y) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.drawString(str, x, y);
            this.addDirtyClipArea();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.drawString(iterator, x, y);
            this.addDirtyClipArea();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        boolean result;
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            result = this.original.drawImage(img, x, y, observer);
            this.addDirtyClipArea();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        boolean result;
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            result = this.original.drawImage(img, x, y, width, height, observer);
            this.addDirtyClipArea();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        boolean result;
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            result = this.original.drawImage(img, x, y, bgcolor, observer);
            this.addDirtyClipArea();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        boolean result;
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            result = this.original.drawImage(img, x, y, width, height, bgcolor, observer);
            this.addDirtyClipArea();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        boolean result;
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            result = this.original.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
            this.addDirtyClipArea();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        boolean result;
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            result = this.original.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
            this.addDirtyClipArea();
        }
        return result;
    }

    @Override
    public void dispose() {
        this.original.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Shape s) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.draw(s);
            this.addDirtyClipArea();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        boolean result;
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            result = this.original.drawImage(img, xform, obs);
            this.addDirtyClipArea();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.drawImage(img, op, x, y);
            this.addDirtyClipArea();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.drawRenderedImage(img, xform);
            this.addDirtyClipArea();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.drawRenderableImage(img, xform);
            this.addDirtyClipArea();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawString(String str, float x, float y) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.drawString(str, x, y);
            this.addDirtyClipArea();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.drawString(iterator, x, y);
            this.addDirtyClipArea();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.drawGlyphVector(g, x, y);
            this.addDirtyClipArea();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fill(Shape s) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.fill(s);
            this.addDirtyClipArea();
        }
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.original.hit(rect, s, onStroke);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.original.getDeviceConfiguration();
    }

    @Override
    public void setComposite(Composite comp) {
        this.original.setComposite(comp);
    }

    @Override
    public void setPaint(Paint paint) {
        this.original.setPaint(paint);
    }

    @Override
    public void setStroke(Stroke s) {
        this.original.setStroke(s);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.original.setRenderingHint(hintKey, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.original.getRenderingHint(hintKey);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.original.setRenderingHints(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.original.addRenderingHints(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.original.getRenderingHints();
    }

    @Override
    public void translate(double tx, double ty) {
        this.original.translate(tx, ty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rotate(double theta) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.original.rotate(theta);
            this.addDirtyClipArea();
        }
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.original.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.original.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.original.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.original.transform(Tx);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.original.setTransform(Tx);
    }

    @Override
    public AffineTransform getTransform() {
        return this.original.getTransform();
    }

    @Override
    public Paint getPaint() {
        return this.original.getPaint();
    }

    @Override
    public Composite getComposite() {
        return this.original.getComposite();
    }

    @Override
    public void setBackground(Color color) {
        this.original.setBackground(color);
    }

    @Override
    public Color getBackground() {
        return this.original.getBackground();
    }

    @Override
    public Stroke getStroke() {
        return this.original.getStroke();
    }

    @Override
    public void clip(Shape s) {
        this.original.clip(s);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.original.getFontRenderContext();
    }
}

