/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetValueType;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetReverseOrderCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import org.tmatesoft.sqljet.core.table.SqlJetDb;

public abstract class SqlJetCursor
implements ISqlJetCursor {
    protected final ISqlJetBtreeTable btreeTable;
    protected final SqlJetDb db;

    SqlJetCursor(ISqlJetBtreeTable table, SqlJetDb db) throws SqlJetException {
        if (!db.isInTransaction()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Cursor requires active transaction");
        }
        this.btreeTable = table;
        this.db = db;
    }

    @Override
    public void close() throws SqlJetException {
        this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                SqlJetCursor.this.btreeTable.close();
                return null;
            }
        });
    }

    @Override
    public boolean eof() throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.eof();
            }
        });
    }

    @Override
    public boolean first() throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.first();
            }
        });
    }

    @Override
    public boolean last() throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.last();
            }
        });
    }

    @Override
    public boolean next() throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.next();
            }
        });
    }

    @Override
    public boolean previous() throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.previous();
            }
        });
    }

    @Override
    public int getFieldsCount() throws SqlJetException {
        return (Integer)this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.getFieldsCount();
            }
        });
    }

    @Override
    public SqlJetValueType getFieldType(final int field) throws SqlJetException {
        return (SqlJetValueType)((Object)this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.getFieldType(field);
            }
        }));
    }

    @Override
    public boolean isNull(final int field) throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.isNull(field);
            }
        });
    }

    @Override
    public String getString(final int field) throws SqlJetException {
        return (String)this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.getString(field);
            }
        });
    }

    @Override
    public long getInteger(final int field) throws SqlJetException {
        return (Long)this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.getInteger(field);
            }
        });
    }

    @Override
    public double getFloat(final int field) throws SqlJetException {
        return (Double)this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.getFloat(field);
            }
        });
    }

    @Override
    public byte[] getBlobAsArray(final int field) throws SqlJetException {
        return (byte[])this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                ISqlJetMemoryPointer buffer = SqlJetCursor.this.btreeTable.getBlob(field);
                return buffer != null ? SqlJetUtility.readByteBuffer(buffer) : null;
            }
        });
    }

    @Override
    public InputStream getBlobAsStream(final int field) throws SqlJetException {
        return (InputStream)this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                ISqlJetMemoryPointer buffer = SqlJetCursor.this.btreeTable.getBlob(field);
                return buffer != null ? new ByteArrayInputStream(SqlJetUtility.readByteBuffer(buffer)) : null;
            }
        });
    }

    @Override
    public Object getValue(final int field) throws SqlJetException {
        return this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                Object value = SqlJetCursor.this.btreeTable.getValue(field);
                if (value instanceof ISqlJetMemoryPointer) {
                    return new ByteArrayInputStream(SqlJetUtility.readByteBuffer((ISqlJetMemoryPointer)value));
                }
                return value;
            }
        });
    }

    @Override
    public boolean getBoolean(final int field) throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetCursor.this.btreeTable.getInteger(field) != 0L;
            }
        });
    }

    @Override
    public ISqlJetCursor reverse() throws SqlJetException {
        return new SqlJetReverseOrderCursor(this);
    }
}

