/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.memory;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryBuffer;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetBytesUtility;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetDirectByteBuffer;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetMemoryPointer;

public class SqlJetByteBuffer
implements ISqlJetMemoryBuffer {
    protected ByteBuffer buffer;

    public SqlJetByteBuffer() {
    }

    public SqlJetByteBuffer(ByteBuffer b) {
        this.buffer = b;
    }

    @Override
    public void allocate(int size) {
        assert (size >= 0);
        this.buffer = ByteBuffer.allocate(size);
    }

    @Override
    public void free() {
        assert (this.buffer != null);
        this.buffer = null;
    }

    @Override
    public boolean isAllocated() {
        return this.buffer != null;
    }

    @Override
    public int getSize() {
        assert (this.buffer != null);
        return this.buffer.capacity();
    }

    @Override
    public ISqlJetMemoryPointer getPointer(int pointer) {
        assert (this.buffer != null);
        assert (pointer >= 0);
        assert (pointer <= this.buffer.capacity());
        return new SqlJetMemoryPointer(this, pointer);
    }

    @Override
    public byte getByte(int pointer) {
        assert (this.buffer != null);
        assert (pointer >= 0);
        assert (pointer < this.buffer.capacity());
        return this.buffer.get(pointer);
    }

    @Override
    public int getByteUnsigned(int pointer) {
        assert (this.buffer != null);
        assert (pointer >= 0);
        assert (pointer < this.buffer.capacity());
        return SqlJetBytesUtility.toUnsignedByte(this.getByte(pointer));
    }

    @Override
    public int getInt(int pointer) {
        assert (this.buffer != null);
        assert (pointer >= 0);
        assert (pointer <= this.buffer.capacity() - 4);
        return this.buffer.getInt(pointer);
    }

    @Override
    public long getIntUnsigned(int pointer) {
        assert (this.buffer != null);
        assert (pointer >= 0);
        assert (pointer <= this.buffer.capacity() - 4);
        return SqlJetBytesUtility.toUnsignedInt(this.getInt(pointer));
    }

    @Override
    public long getLong(int pointer) {
        assert (this.buffer != null);
        assert (pointer >= 0);
        assert (pointer <= this.buffer.capacity() - 8);
        return this.buffer.getLong(pointer);
    }

    @Override
    public short getShort(int pointer) {
        assert (this.buffer != null);
        assert (pointer >= 0);
        assert (pointer <= this.buffer.capacity() - 2);
        return this.buffer.getShort(pointer);
    }

    @Override
    public int getShortUnsigned(int pointer) {
        assert (this.buffer != null);
        assert (pointer >= 0);
        assert (pointer <= this.buffer.capacity() - 2);
        return SqlJetBytesUtility.toUnsignedShort(this.getShort(pointer));
    }

    @Override
    public void putByte(int pointer, byte value) {
        assert (this.buffer != null);
        assert (pointer >= 0);
        assert (pointer < this.buffer.capacity());
        this.buffer.put(pointer, value);
    }

    @Override
    public void putByteUnsigned(int pointer, int value) {
        assert (this.buffer != null);
        assert (pointer >= 0);
        assert (pointer < this.buffer.capacity());
        this.putByte(pointer, (byte)SqlJetBytesUtility.toUnsignedByte(value));
    }

    @Override
    public void putInt(int pointer, int value) {
        assert (this.buffer != null);
        assert (pointer >= 0);
        assert (pointer <= this.buffer.capacity() - 4);
        this.buffer.putInt(pointer, value);
    }

    @Override
    public void putIntUnsigned(int pointer, long value) {
        assert (this.buffer != null);
        assert (pointer >= 0);
        assert (pointer <= this.buffer.capacity() - 4);
        this.putInt(pointer, (int)SqlJetBytesUtility.toUnsignedInt(value));
    }

    @Override
    public void putLong(int pointer, long value) {
        assert (this.buffer != null);
        assert (pointer >= 0);
        assert (pointer <= this.buffer.capacity() - 8);
        this.buffer.putLong(pointer, value);
    }

    @Override
    public void putShort(int pointer, short value) {
        assert (this.buffer != null);
        assert (pointer >= 0);
        assert (pointer <= this.buffer.capacity() - 2);
        this.buffer.putShort(pointer, value);
    }

    @Override
    public void putShortUnsigned(int pointer, int value) {
        assert (this.buffer != null);
        assert (pointer >= 0);
        assert (pointer <= this.buffer.capacity() - 2);
        this.putShort(pointer, (short)SqlJetBytesUtility.toUnsignedShort(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readFromFile(int pointer, RandomAccessFile file, long position, int count) throws IOException {
        assert (this.buffer != null);
        assert (pointer >= 0);
        assert (pointer < this.buffer.capacity());
        assert (file != null);
        assert (position >= 0L);
        assert (count > 0);
        this.buffer.limit(pointer + count).position(pointer);
        try {
            int n = file.getChannel().read(this.buffer, position);
            return n;
        }
        finally {
            this.buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeToFile(int pointer, RandomAccessFile file, long position, int count) throws IOException {
        assert (this.buffer != null);
        assert (pointer >= 0);
        assert (pointer < this.buffer.capacity());
        assert (file != null);
        assert (position >= 0L);
        assert (count > 0);
        this.buffer.limit(pointer + count).position(pointer);
        try {
            int n = file.getChannel().write(this.buffer, position);
            return n;
        }
        finally {
            this.buffer.clear();
        }
    }

    @Override
    public byte[] asArray() {
        return this.buffer.array();
    }

    @Override
    public void copyFrom(int dstPos, ISqlJetMemoryBuffer src, int srcPos, int count) {
        if (src instanceof SqlJetByteBuffer && !(src instanceof SqlJetDirectByteBuffer)) {
            SqlJetByteBuffer srcBuf = (SqlJetByteBuffer)src;
            System.arraycopy(srcBuf.buffer.array(), srcPos, this.buffer.array(), dstPos, count);
        } else {
            byte[] b = new byte[count];
            src.getBytes(srcPos, b, 0, count);
            this.putBytes(dstPos, b, 0, count);
        }
    }

    @Override
    public void fill(int from, int count, byte value) {
        Arrays.fill(this.buffer.array(), from, from + count, value);
    }

    @Override
    public void getBytes(int pointer, byte[] bytes, int to, int count) {
        System.arraycopy(this.buffer.array(), pointer, bytes, to, count);
    }

    @Override
    public void putBytes(int pointer, byte[] bytes, int from, int count) {
        System.arraycopy(bytes, from, this.buffer.array(), pointer, count);
    }

    @Override
    public int compareTo(int pointer, ISqlJetMemoryBuffer buffer, int bufferPointer) {
        int bufferCount;
        int thisCount = this.getSize() - pointer;
        if (thisCount != (bufferCount = buffer.getSize() - bufferPointer)) {
            if (thisCount > bufferCount) {
                return 1;
            }
            return -1;
        }
        if (buffer instanceof SqlJetByteBuffer && !(buffer instanceof SqlJetDirectByteBuffer)) {
            SqlJetByteBuffer b = (SqlJetByteBuffer)buffer;
            return SqlJetUtility.memcmp(this.buffer.array(), pointer, b.buffer.array(), bufferPointer, thisCount);
        }
        byte[] b = new byte[thisCount];
        buffer.getBytes(bufferPointer, b, 0, thisCount);
        return SqlJetUtility.memcmp(this.buffer.array(), pointer, b, bufferPointer, thisCount);
    }
}

