/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.map;

import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapDef;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapTableCursor;
import org.tmatesoft.sqljet.core.map.ISqlJetMapTable;
import org.tmatesoft.sqljet.core.map.ISqlJetMapTableCursor;
import org.tmatesoft.sqljet.core.map.ISqlJetMapTransaction;
import org.tmatesoft.sqljet.core.map.SqlJetMapDb;
import org.tmatesoft.sqljet.core.table.engine.ISqlJetEngineSynchronized;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine;

public class SqlJetMapTable
implements ISqlJetMapTable {
    private final SqlJetMapDb mapDb;
    private final ISqlJetBtree btree;
    private final SqlJetMapDef mapDef;
    private boolean writable;

    public SqlJetMapTable(SqlJetMapDb mapDb, ISqlJetBtree btree, SqlJetMapDef mapDef, boolean writable) {
        this.mapDb = mapDb;
        this.btree = btree;
        this.mapDef = mapDef;
        this.writable = writable;
    }

    @Override
    public ISqlJetMapTableCursor getCursor() throws SqlJetException {
        return (ISqlJetMapTableCursor)this.mapDb.runSynchronized(new ISqlJetEngineSynchronized(){

            @Override
            public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                return new SqlJetMapTableCursor(SqlJetMapTable.this.mapDb, SqlJetMapTable.this.btree, SqlJetMapTable.this.mapDef, SqlJetMapTable.this.writable);
            }
        });
    }

    @Override
    public long put(final long key, final Object ... values) throws SqlJetException {
        return (Long)this.mapDb.runWriteTransaction(new ISqlJetMapTransaction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run(SqlJetMapDb mapDb) throws SqlJetException {
                try (ISqlJetMapTableCursor cursor = SqlJetMapTable.this.getCursor();){
                    Long l = cursor.put(key, values);
                    return l;
                }
            }
        });
    }

    @Override
    public Object[] get(final long key) throws SqlJetException {
        return (Object[])this.mapDb.runReadTransaction(new ISqlJetMapTransaction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run(SqlJetMapDb mapDb) throws SqlJetException {
                try (ISqlJetMapTableCursor cursor = SqlJetMapTable.this.getCursor();){
                    if (cursor.goToKey(key)) {
                        Object[] objectArray = cursor.getValue();
                        return objectArray;
                    }
                    Object var3_4 = null;
                    return var3_4;
                }
            }
        });
    }
}

