/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.browser;

import java.awt.Window;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class DBBrowserConfig {
    public static File getLastDirectory() {
        block5: {
            try {
                Preferences preferences = Preferences.userNodeForPackage(DBBrowserConfig.class);
                if (preferences == null) break block5;
                try {
                    preferences.sync();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
                String path = preferences.get("directory", null);
                if (path != null) {
                    return new File(path);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setLastDirectory(File directory) {
        try {
            Preferences preferences = Preferences.userNodeForPackage(DBBrowserConfig.class);
            if (preferences != null && directory != null) {
                preferences.put("directory", directory.getAbsolutePath());
                try {
                    preferences.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static void saveWindowSize(String windowName, Window w) {
        try {
            Preferences preferences = Preferences.userNodeForPackage(DBBrowserConfig.class);
            if (preferences != null && w != null) {
                preferences.put("window." + windowName + ".x", w.getLocation().x + "");
                preferences.put("window." + windowName + ".y", w.getLocation().y + "");
                preferences.put("window." + windowName + ".width", w.getSize().width + "");
                preferences.put("window." + windowName + ".height", w.getSize().height + "");
                try {
                    preferences.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static void loadWindowSize(String windowName, Window window) {
        block6: {
            try {
                Preferences preferences = Preferences.userNodeForPackage(DBBrowserConfig.class);
                if (preferences == null || window == null) break block6;
                try {
                    preferences.sync();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
                int x = preferences.getInt("window." + windowName + ".x", -1);
                int y = preferences.getInt("window." + windowName + ".y", -1);
                int w = preferences.getInt("window." + windowName + ".width", -1);
                int h = preferences.getInt("window." + windowName + ".height", -1);
                if (x >= 0 && w > 0) {
                    window.setSize(w, h);
                    window.setLocation(x, y);
                } else {
                    window.pack();
                }
            }
            catch (SecurityException e) {
                window.pack();
            }
        }
    }

    public static void setRecentDBs(List<File> paths) {
        try {
            Preferences preferences = Preferences.userNodeForPackage(DBBrowserConfig.class);
            if (preferences != null && paths != null) {
                int i = 0;
                for (File path : paths) {
                    preferences.put("recent." + i, path.getAbsolutePath());
                    ++i;
                }
                try {
                    preferences.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static List<File> getRecentDBs() {
        LinkedList<File> list;
        block5: {
            list = new LinkedList<File>();
            try {
                String path;
                Preferences preferences = Preferences.userNodeForPackage(DBBrowserConfig.class);
                if (preferences == null) break block5;
                try {
                    preferences.sync();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
                for (int i = 0; i < 5 && (path = preferences.get("recent." + i, null)) != null; ++i) {
                    list.add(new File(path));
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return list;
    }
}

