/*
 * Decompiled with CFR 0.152.
 */
package tablelayout;

import tablelayout.TableLayout;
import tablelayout.TableLoc;
import tablelayout.TableLocRec;
import tablelayout.TableVec;
import tablelayout.TableVecRec;

public class TableCol
extends TableVec {
    private static final String version_id = "@(#)$Id: TableCol.java,v 1.2 2002/03/26 18:21:02 tonyj Exp $ Copyright West Consulting bv";

    public TableCol(TableLayout tw) {
        this.parent = tw;
        TableLoc loc = this.parent.layout;
        if ((TableLoc)null == loc) {
            return;
        }
        this.size = loc.numCols();
        if (0 == this.size) {
            return;
        }
        this.vec = new TableVecRec[this.size];
        for (int index = 0; index < this.size; ++index) {
            this.vec[index] = new TableVecRec();
        }
        this.minimize();
    }

    @Override
    public void minimize() {
        int i;
        int slot;
        int first_slot;
        TableLocRec rec;
        int index;
        TableLoc loc = this.parent.layout;
        int loc_sz = loc.size();
        for (index = 0; index < loc_sz; ++index) {
            rec = loc.recElementAt(index);
            boolean minimize = rec.options.W;
            boolean dontStretch = rec.options.w;
            first_slot = rec.col;
            int last_slot = rec.col + rec.col_span;
            if (minimize) {
                for (slot = first_slot; slot < last_slot; ++slot) {
                    this.vec[slot].options |= 1;
                }
            }
            if (!dontStretch) continue;
            for (slot = first_slot; slot < last_slot; ++slot) {
                this.vec[slot].options |= 2;
            }
        }
        loc.qsort(0, loc_sz - 1, true);
        for (i = 0; i < this.size; ++i) {
            this.vec[i].value = 0;
        }
        for (index = 0; index < loc_sz; ++index) {
            int to_stretch;
            int pref;
            rec = loc.recElementAt(index);
            if (rec.col_span == 1) {
                pref = rec.preferredWidth();
                if (pref <= this.vec[rec.col].value) continue;
                this.vec[rec.col].value = pref;
                continue;
            }
            int can_stretch = 0;
            int span_size = this.parent.col_spacing * (rec.col_span - 1);
            first_slot = rec.col;
            int stop_before = rec.col + rec.col_span;
            for (slot = first_slot; slot < stop_before; ++slot) {
                if (0 == (this.vec[slot].options & 2)) {
                    ++can_stretch;
                }
                span_size += this.vec[slot].value;
            }
            if (0 == can_stretch) {
                to_stretch = rec.col_span;
                pref = rec.orig_width;
            } else {
                to_stretch = can_stretch;
                pref = rec.preferredWidth();
            }
            if (span_size >= pref) continue;
            int excess = pref - span_size;
            int amt = excess / to_stretch;
            int truncated = excess - amt * to_stretch;
            for (slot = first_slot; slot < stop_before; ++slot) {
                if (0 != can_stretch && 0 != (this.vec[slot].options & 2)) continue;
                if (truncated != 0) {
                    this.vec[slot].value += amt + 1;
                    --truncated;
                    continue;
                }
                this.vec[slot].value += amt;
            }
        }
        for (i = 0; i < this.size; ++i) {
            this.vec[i].pref_value = this.vec[i].value;
        }
    }

    @Override
    public int totalSize() {
        return this.layoutSize(true);
    }

    @Override
    public int getPreferredSize() {
        return this.layoutSize(false);
    }

    @Override
    public int layoutSize(boolean do_actual) {
        int laysize = 0;
        int space = this.parent.col_spacing;
        laysize += 2 * this.parent.margin_width;
        if (do_actual) {
            laysize -= space;
            for (int slot = 0; slot < this.size; ++slot) {
                laysize += this.vec[slot].value + space;
            }
        } else {
            laysize -= space;
            for (int slot = 0; slot < this.size; ++slot) {
                laysize += this.vec[slot].pref_value + space;
            }
        }
        if (laysize > 0) {
            return laysize;
        }
        return 1;
    }

    @Override
    public String toString() {
        String st = new String("TableCol [" + super.toString() + " ] ");
        return st;
    }
}

