/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.gjt.sp.jedit.syntax.SyntaxDocument;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class SyntaxView
extends PlainView {
    private Segment line = new Segment();
    private Rectangle newRect = new Rectangle();

    public SyntaxView(Element elem) {
        super(elem);
    }

    @Override
    public void drawLine(int lineIndex, Graphics g, int x, int y) {
        TokenMarker tokenMarker;
        SyntaxDocument syntaxDocument;
        Document document = this.getDocument();
        if (document instanceof SyntaxDocument) {
            syntaxDocument = (SyntaxDocument)document;
            tokenMarker = syntaxDocument.getTokenMarker();
        } else {
            syntaxDocument = null;
            tokenMarker = null;
        }
        FontMetrics metrics = g.getFontMetrics();
        Color def = this.getDefaultColor();
        try {
            Element lineElement = this.getElement().getElement(lineIndex);
            int start = lineElement.getStartOffset();
            int end = lineElement.getEndOffset();
            document.getText(start, end - (start + 1), this.line);
            if (tokenMarker == null) {
                g.setColor(def);
                Utilities.drawTabbedText(this.line, x, y, g, (TabExpander)this, 0);
            } else {
                this.paintSyntaxLine(this.line, lineIndex, x, y, g, syntaxDocument, tokenMarker, def);
                if (tokenMarker.isNextLineRequested()) {
                    this.forceRepaint(g, x, y);
                }
            }
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
    }

    protected Color getDefaultColor() {
        return this.getContainer().getForeground();
    }

    private void paintSyntaxLine(Segment line, int lineIndex, int x, int y, Graphics g, SyntaxDocument syntaxDocument, TokenMarker tokenMarker, Color def) {
        byte id;
        Color[] colors = syntaxDocument.getColors();
        Token tokens = tokenMarker.markTokens(line, lineIndex);
        int offset = 0;
        while ((id = tokens.id) != 127) {
            int length = tokens.length;
            Color color = id == 0 ? def : colors[id];
            g.setColor(color == null ? def : color);
            line.count = length;
            x = Utilities.drawTabbedText(line, x, y, g, (TabExpander)this, offset);
            line.offset += length;
            offset += length;
            tokens = tokens.next;
        }
    }

    private void forceRepaint(Graphics g, int x, int y) {
        Container host = this.getContainer();
        Dimension size = host.getSize();
        host.repaint(x, y, size.width - x, size.height - y);
    }
}

