/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import javax.swing.text.Segment;
import org.gjt.sp.jedit.syntax.JavaScriptTokenMarker;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.SyntaxUtilities;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class HTMLTokenMarker
extends TokenMarker {
    public static final byte JAVASCRIPT = 100;
    private KeywordMap keywords = JavaScriptTokenMarker.getKeywords();

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int len;
        byte id;
        int offset;
        boolean backslash = false;
        int lastOffset = offset = line.offset;
        int lastKeyword = offset;
        int length = line.count + offset;
        block17: for (int i = offset; i < length; ++i) {
            switch (line.array[i]) {
                case '\\': {
                    backslash = !backslash;
                    continue block17;
                }
                case ';': {
                    if (token == 7) {
                        token = 0;
                        this.addToken(i + 1 - lastOffset, (byte)7);
                        lastOffset = i + 1;
                        continue block17;
                    }
                }
                case '*': {
                    if (token == 2 && length - i > 1 && length - i > 1 && line.array[i + 1] == '/') {
                        backslash = false;
                        token = (byte)100;
                        this.addToken(++i + 1 - lastOffset, (byte)2);
                        lastOffset = i + 1;
                        continue block17;
                    }
                }
                case '\t': 
                case ' ': 
                case '(': 
                case ')': 
                case ',': 
                case '.': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    backslash = false;
                    if (token != 100) continue block17;
                    int len2 = i - lastKeyword;
                    byte id2 = this.keywords.lookup(line, lastKeyword, len2);
                    if (id2 != 0) {
                        if (lastKeyword != lastOffset) {
                            this.addToken(lastKeyword - lastOffset, (byte)0);
                        }
                        this.addToken(len2, id2);
                        lastOffset = i;
                    }
                    lastKeyword = i + 1;
                    continue block17;
                }
                case '<': {
                    backslash = false;
                    if (token == 0) {
                        token = SyntaxUtilities.regionMatches(false, line, i, "<!--") ? (byte)1 : (byte)6;
                        this.addToken(i - lastOffset, (byte)0);
                        lastOffset = i;
                        continue block17;
                    }
                    if (token != 100 || !SyntaxUtilities.regionMatches(true, line, i, "</SCRIPT>")) continue block17;
                    token = (byte)6;
                    this.addToken(i - lastOffset, (byte)0);
                    lastOffset = i;
                    continue block17;
                }
                case '>': {
                    backslash = false;
                    if (token == 6) {
                        token = SyntaxUtilities.regionMatches(true, line, lastOffset, "<SCRIPT") ? (byte)100 : (byte)0;
                        this.addToken(i + 1 - lastOffset, (byte)6);
                        lastOffset = i + 1;
                        continue block17;
                    }
                    if (token != 1 || !SyntaxUtilities.regionMatches(false, line, i - 2, "-->")) continue block17;
                    token = 0;
                    this.addToken(i + 1 - lastOffset, (byte)1);
                    lastOffset = i + 1;
                    continue block17;
                }
                case '&': {
                    backslash = false;
                    if (token != 0) continue block17;
                    token = (byte)7;
                    this.addToken(i - lastOffset, (byte)0);
                    lastOffset = i;
                    continue block17;
                }
                case ':': {
                    backslash = false;
                    if (token != 100 || lastKeyword != offset) continue block17;
                    this.addToken(i + 1 - lastOffset, (byte)5);
                    lastOffset = i + 1;
                    continue block17;
                }
                case '/': {
                    backslash = false;
                    if (token != 100 || length - i <= 1) continue block17;
                    switch (line.array[i + 1]) {
                        case '*': {
                            token = (byte)2;
                            this.addToken(i - lastOffset, (byte)100);
                            lastOffset = i++;
                            break;
                        }
                        case '/': {
                            this.addToken(i - lastOffset, token);
                            this.addToken(length - i, (byte)2);
                            lastOffset = length;
                            break block17;
                        }
                    }
                    continue block17;
                }
                case '\"': {
                    if (backslash) {
                        backslash = false;
                        continue block17;
                    }
                    if (token == 100) {
                        token = (byte)3;
                        this.addToken(i - lastOffset, (byte)100);
                        lastOffset = i;
                        continue block17;
                    }
                    if (token != 3) continue block17;
                    token = (byte)100;
                    this.addToken(i + 1 - lastOffset, (byte)3);
                    lastOffset = i + 1;
                    continue block17;
                }
                case '\'': {
                    if (backslash) {
                        backslash = false;
                        continue block17;
                    }
                    if (token == 100) {
                        token = (byte)4;
                        this.addToken(i - lastOffset, (byte)100);
                        lastOffset = i;
                        continue block17;
                    }
                    if (token != 4) continue block17;
                    token = (byte)100;
                    this.addToken(i + 1 - lastOffset, (byte)3);
                    lastOffset = i + 1;
                    continue block17;
                }
                default: {
                    backslash = false;
                }
            }
        }
        if (token == 100 && (id = this.keywords.lookup(line, lastKeyword, len = length - lastKeyword)) != 0) {
            if (lastKeyword != lastOffset) {
                this.addToken(lastKeyword - lastOffset, (byte)0);
            }
            this.addToken(len, id);
            lastOffset = length;
        }
        if (lastOffset != length) {
            if (token == 3 || token == 4 || token == 7) {
                this.addToken(length - lastOffset, (byte)10);
                token = token == 7 ? (byte)0 : (byte)100;
            } else {
                this.addToken(length - lastOffset, token);
            }
        }
        return token;
    }
}

