/*
 * Decompiled with CFR 0.152.
 */
package jasext.test;

import hepjas.analysis.AbstractNTupleEventData;
import hepjas.analysis.EndOfDataException;
import hepjas.analysis.EventData;
import hepjas.analysis.EventDataException;
import hepjas.analysis.NTupleEventData;
import jas2.jds.module.AnnotatedEventSource;
import jas2.util.tree.TreeItem;
import jasext.test.DataColumn;
import jasext.test.DateDist;
import jasext.test.Flat;
import jasext.test.FlatInteger;
import jasext.test.Gaussian;
import jasext.test.Rebinnable1DHistogramDataWithType;
import jasext.test.StringDataColumn;
import jasext.test.StringDist;
import java.util.Date;
import java.util.Hashtable;

class TestEventSource
implements AnnotatedEventSource {
    private EventData m_event = new TestEventData();
    private Hashtable m_hash = new Hashtable();
    private int m_pos;
    private int m_events;
    private Rebinnable1DHistogramDataWithType[] m_data;
    private String m_name;

    TestEventSource(String filename) {
        this.m_name = filename;
        this.m_events = 1000;
        this.m_data = new Rebinnable1DHistogramDataWithType[8];
        this.m_data[0] = new Flat(this.m_events);
        this.m_data[1] = new FlatInteger(this.m_events);
        this.m_data[2] = new Gaussian(this.m_events, 1.0);
        this.m_data[3] = new Gaussian(this.m_events, 10.0);
        this.m_data[4] = new StringDist(this.m_events);
        this.m_data[5] = new DateDist(this.m_events, "Days", 86400.0);
        this.m_data[6] = new DateDist(this.m_events, "Months", 2592000.0);
        this.m_data[7] = new DateDist(this.m_events, "Years", 3.1536E7);
    }

    @Override
    public Class getEventDataClass() {
        return NTupleEventData.class;
    }

    @Override
    public TreeItem[] getItems() {
        int cols = this.m_data.length;
        TreeItem[] result = new TreeItem[cols];
        for (int i = 0; i < this.m_data.length; ++i) {
            result[i] = new TreeItem();
            result[i].path = new String[1];
            result[i].path[0] = this.m_data[i].getTitle();
            result[i].type = this.m_data[i].getType();
            this.m_hash.put(result[i].path[0], new Integer(i));
        }
        return result;
    }

    @Override
    public Object getItem(TreeItem i) {
        int column = (Integer)this.m_hash.get(i.path[i.path.length - 1]);
        return this.m_data[column];
    }

    @Override
    public void close() {
    }

    @Override
    public int getTotalNumberOfEvents() {
        return this.m_events;
    }

    @Override
    public void beforeFirstEvent() {
        this.m_pos = -1;
    }

    @Override
    public void afterLastEvent() {
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public EventData getNextEvent() throws EndOfDataException {
        if (++this.m_pos >= this.m_events) {
            throw new EndOfDataException();
        }
        return this.m_event;
    }

    final class TestEventData
    extends AbstractNTupleEventData {
        TestEventData() {
        }

        @Override
        public double getDouble(String name) {
            Integer column = (Integer)TestEventSource.this.m_hash.get(name);
            if (column == null) {
                throw new EventDataException("Cannot find column " + name);
            }
            try {
                return ((DataColumn)TestEventSource.this.m_data[column]).getDouble(TestEventSource.this.m_pos);
            }
            catch (ClassCastException e) {
                throw new EventDataException("Cannot find column " + name);
            }
        }

        @Override
        public int getInt(String name) {
            Integer column = (Integer)TestEventSource.this.m_hash.get(name);
            if (column == null) {
                throw new EventDataException("Cannot find column " + name);
            }
            try {
                return ((DataColumn)TestEventSource.this.m_data[column]).getInt(TestEventSource.this.m_pos);
            }
            catch (ClassCastException e) {
                throw new EventDataException("Cannot find column " + name);
            }
        }

        @Override
        public Date getDate(String name) {
            Integer column = (Integer)TestEventSource.this.m_hash.get(name);
            if (column == null) {
                throw new EventDataException("Cannot find column " + name);
            }
            try {
                return ((DataColumn)TestEventSource.this.m_data[column]).getDate(TestEventSource.this.m_pos);
            }
            catch (ClassCastException e) {
                throw new EventDataException("Cannot find column " + name);
            }
        }

        @Override
        public String getString(String name) {
            Integer column = (Integer)TestEventSource.this.m_hash.get(name);
            if (column == null) {
                throw new EventDataException("Cannot find column " + name);
            }
            try {
                return ((StringDataColumn)TestEventSource.this.m_data[column]).getString(TestEventSource.this.m_pos);
            }
            catch (ClassCastException e) {
                throw new EventDataException("Cannot find column " + name);
            }
        }

        @Override
        public double getDouble(int column) {
            try {
                return ((DataColumn)TestEventSource.this.m_data[column]).getDouble(TestEventSource.this.m_pos);
            }
            catch (ClassCastException e) {
                throw new EventDataException("Cannot find column " + column);
            }
        }

        @Override
        public int getInt(int column) {
            try {
                return ((DataColumn)TestEventSource.this.m_data[column]).getInt(TestEventSource.this.m_pos);
            }
            catch (ClassCastException e) {
                throw new EventDataException("Cannot find column " + column);
            }
        }

        @Override
        public Date getDate(int column) {
            try {
                return ((DataColumn)TestEventSource.this.m_data[column]).getDate(TestEventSource.this.m_pos);
            }
            catch (ClassCastException e) {
                throw new EventDataException("Cannot find column " + column);
            }
        }

        @Override
        public String getString(int column) {
            try {
                return ((StringDataColumn)TestEventSource.this.m_data[column]).getString(TestEventSource.this.m_pos);
            }
            catch (ClassCastException e) {
                throw new EventDataException("Cannot find column " + column);
            }
        }

        @Override
        public int findColumn(String name) {
            Integer column = (Integer)TestEventSource.this.m_hash.get(name);
            if (column == null) {
                throw new EventDataException("Cannot find column " + name);
            }
            return column;
        }
    }
}

