/*
 * Decompiled with CFR 0.152.
 */
package jasext.jhplotserver;

import hep.aida.IFunction;
import hep.aida.ref.histogram.Histogram1D;
import hep.aida.ref.histogram.Histogram2D;
import hepjas.analysis.AbstractNTupleEventData;
import hepjas.analysis.EndOfDataException;
import hepjas.analysis.EventData;
import hepjas.analysis.EventDataException;
import hepjas.analysis.NTupleEventData;
import jas2.hist.DataSource;
import jas2.jds.module.AnnotatedEventSource;
import jas2.util.tree.TreeItem;
import jasext.jhplotserver.DataColumn;
import jasext.jhplotserver.DoubleDataColumn;
import jasext.jhplotserver.FunctionData1DWithType;
import jasext.jhplotserver.IntegerDataColumn;
import jasext.jhplotserver.Rebinnable1DHistogramDataWithType;
import jasext.jhplotserver.Rebinnable2DHistogramDataWithType;
import jasext.jhplotserver.RefF1D;
import jasext.jhplotserver.RefH1D;
import jasext.jhplotserver.RefH2D;
import jasext.jhplotserver.RefP0D;
import jasext.jhplotserver.RefP0I;
import jasext.jhplotserver.RefP1D;
import jasext.jhplotserver.ScatterDataWithType;
import jasext.jhplotserver.StringDataColumn;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import jhplot.H1D;
import jhplot.H2D;
import jhplot.P0D;
import jhplot.P0I;
import jhplot.P1D;

class JHEventSource
implements AnnotatedEventSource {
    private ArrayList<Object> obj;
    private EventData m_event = new TestEventData();
    private Hashtable m_hash = new Hashtable();
    private int m_pos;
    private int m_events;
    private ArrayList<DataSource> m_data;
    private String m_name;

    JHEventSource(String m_name) {
        this.m_name = m_name;
    }

    public void setSource(ArrayList<Object> obj) {
        this.obj = obj;
        this.m_data = new ArrayList();
        for (int i = 0; i < obj.size(); ++i) {
            Object o = obj.get(i);
            if (o instanceof P0D) {
                this.m_data.add(new RefP0D((P0D)o));
                continue;
            }
            if (o instanceof P0I) {
                this.m_data.add(new RefP0I((P0I)o));
                continue;
            }
            if (o instanceof Histogram1D) {
                this.m_data.add(new RefH1D((Histogram1D)o));
                continue;
            }
            if (o instanceof Histogram2D) {
                this.m_data.add(new RefH2D((Histogram2D)o));
                continue;
            }
            if (o instanceof H1D) {
                this.m_data.add(new RefH1D(((H1D)o).get()));
                continue;
            }
            if (o instanceof H2D) {
                this.m_data.add(new RefH2D(((H2D)o).get()));
                continue;
            }
            if (o instanceof P1D) {
                this.m_data.add(new RefP1D((P1D)o));
                continue;
            }
            if (!(o instanceof IFunction)) continue;
            this.m_data.add(new RefF1D((IFunction)o));
        }
    }

    @Override
    public Class getEventDataClass() {
        return NTupleEventData.class;
    }

    @Override
    public TreeItem[] getItems() {
        int cols = this.m_data.size();
        TreeItem[] result = new TreeItem[cols];
        for (int i = 0; i < this.m_data.size(); ++i) {
            result[i] = new TreeItem();
            result[i].path = new String[1];
            result[i].path[0] = this.m_data.get(i).getTitle();
            result[i].type = "histogram";
            if (this.m_data.get(i) instanceof DoubleDataColumn) {
                result[i].type = ((DoubleDataColumn)this.m_data.get(i)).getType();
            }
            if (this.m_data.get(i) instanceof IntegerDataColumn) {
                result[i].type = ((IntegerDataColumn)this.m_data.get(i)).getType();
            }
            if (this.m_data.get(i) instanceof Rebinnable1DHistogramDataWithType) {
                result[i].type = ((Rebinnable1DHistogramDataWithType)this.m_data.get(i)).getType();
            }
            if (this.m_data.get(i) instanceof Rebinnable2DHistogramDataWithType) {
                result[i].type = ((Rebinnable2DHistogramDataWithType)this.m_data.get(i)).getType();
            }
            if (this.m_data.get(i) instanceof ScatterDataWithType) {
                result[i].type = ((ScatterDataWithType)this.m_data.get(i)).getType();
            }
            if (this.m_data.get(i) instanceof FunctionData1DWithType) {
                result[i].type = ((FunctionData1DWithType)this.m_data.get(i)).getType();
            }
            this.m_hash.put(result[i].path[0], new Integer(i));
        }
        return result;
    }

    @Override
    public Object getItem(TreeItem i) {
        int column = (Integer)this.m_hash.get(i.path[i.path.length - 1]);
        return this.m_data.get(column);
    }

    @Override
    public void close() {
    }

    @Override
    public int getTotalNumberOfEvents() {
        return this.m_events;
    }

    @Override
    public void beforeFirstEvent() {
        this.m_pos = -1;
    }

    @Override
    public void afterLastEvent() {
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public EventData getNextEvent() throws EndOfDataException {
        if (++this.m_pos >= this.m_events) {
            throw new EndOfDataException();
        }
        return this.m_event;
    }

    final class TestEventData
    extends AbstractNTupleEventData {
        TestEventData() {
        }

        @Override
        public double getDouble(String name) {
            Integer column = (Integer)JHEventSource.this.m_hash.get(name);
            if (column == null) {
                throw new EventDataException("Cannot find column " + name);
            }
            try {
                return ((DataColumn)JHEventSource.this.m_data.get(column)).getDouble(JHEventSource.this.m_pos);
            }
            catch (ClassCastException e) {
                throw new EventDataException("Cannot find column " + name);
            }
        }

        @Override
        public int getInt(String name) {
            Integer column = (Integer)JHEventSource.this.m_hash.get(name);
            if (column == null) {
                throw new EventDataException("Cannot find column " + name);
            }
            try {
                return ((DataColumn)JHEventSource.this.m_data.get(column)).getInt(JHEventSource.this.m_pos);
            }
            catch (ClassCastException e) {
                throw new EventDataException("Cannot find column " + name);
            }
        }

        @Override
        public Date getDate(String name) {
            Integer column = (Integer)JHEventSource.this.m_hash.get(name);
            if (column == null) {
                throw new EventDataException("Cannot find column " + name);
            }
            try {
                return ((DataColumn)JHEventSource.this.m_data.get(column)).getDate(JHEventSource.this.m_pos);
            }
            catch (ClassCastException e) {
                throw new EventDataException("Cannot find column " + name);
            }
        }

        @Override
        public String getString(String name) {
            Integer column = (Integer)JHEventSource.this.m_hash.get(name);
            if (column == null) {
                throw new EventDataException("Cannot find column " + name);
            }
            try {
                return ((StringDataColumn)JHEventSource.this.m_data.get(column)).getString(JHEventSource.this.m_pos);
            }
            catch (ClassCastException e) {
                throw new EventDataException("Cannot find column " + name);
            }
        }

        @Override
        public double getDouble(int column) {
            try {
                return ((DataColumn)JHEventSource.this.m_data.get(column)).getDouble(JHEventSource.this.m_pos);
            }
            catch (ClassCastException e) {
                throw new EventDataException("Cannot find column " + column);
            }
        }

        @Override
        public int getInt(int column) {
            try {
                return ((DataColumn)JHEventSource.this.m_data.get(column)).getInt(JHEventSource.this.m_pos);
            }
            catch (ClassCastException e) {
                throw new EventDataException("Cannot find column " + column);
            }
        }

        @Override
        public Date getDate(int column) {
            try {
                return ((DataColumn)JHEventSource.this.m_data.get(column)).getDate(JHEventSource.this.m_pos);
            }
            catch (ClassCastException e) {
                throw new EventDataException("Cannot find column " + column);
            }
        }

        @Override
        public String getString(int column) {
            try {
                return ((StringDataColumn)JHEventSource.this.m_data.get(column)).getString(JHEventSource.this.m_pos);
            }
            catch (ClassCastException e) {
                throw new EventDataException("Cannot find column " + column);
            }
        }

        @Override
        public int findColumn(String name) {
            Integer column = (Integer)JHEventSource.this.m_hash.get(name);
            if (column == null) {
                throw new EventDataException("Cannot find column " + name);
            }
            return column;
        }
    }
}

