/*
 * Decompiled with CFR 0.152.
 */
package jasext.jhplotserver;

import jas2.hist.Statistics;
import jasext.jhplotserver.Rebinnable1DHistogramDataWithType;
import java.util.Date;

abstract class DataColumn
extends Rebinnable1DHistogramDataWithType {
    protected double[] data;
    protected String title;

    DataColumn(String title, int size) {
        this.title = title;
        this.data = new double[size];
    }

    public int getSize() {
        return this.data.length;
    }

    @Override
    public double[][] rebin(int bins, double min, double max, boolean wantErrors, boolean hurry) {
        double[] hist = new double[bins];
        double binWidth = (max - min) / (double)bins;
        for (int j = 0; j < bins; ++j) {
            hist[j] = 0.0;
        }
        for (int k = 0; k < this.data.length; ++k) {
            double x = this.data[k];
            if (!(x >= min) || !(x < max)) continue;
            int n = (int)((x - min) / binWidth);
            hist[n] = hist[n] + 1.0;
        }
        double[][] result = new double[][]{hist};
        return result;
    }

    @Override
    public String[] getAxisLabels() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean isRebinnable() {
        return true;
    }

    @Override
    public int getAxisType() {
        return 1;
    }

    public Statistics getStatistics() {
        return null;
    }

    abstract double getDouble(int var1);

    abstract int getInt(int var1);

    abstract Date getDate(int var1);
}

