/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.function;

import jas2.hist.Fittable1DFunction;
import jas2.hist.Fitter;
import jas2.hist.Handle;
import jas2.hist.HasHandles;
import jas2.hist.Statistics;

public class LandauFunction
extends Fittable1DFunction
implements HasHandles {
    private static final long serialVersionUID = 1L;
    private static final double fwhm = 1.177;
    private double max;
    private double mean;
    private double sigma;

    public LandauFunction(double amplitude, double mean, double sigma) {
        this.max = amplitude;
        this.mean = mean;
        this.sigma = sigma;
    }

    public LandauFunction(double xmin, double xmax, double ymin, double ymax) {
        this.max = ymin + (ymax - ymin) * 0.8;
        this.mean = (xmin + xmax) / 2.0;
        this.sigma = (xmax - xmin) / 6.0;
    }

    @Override
    public double valueAt(double x) {
        double yy = (x - this.mean) / this.sigma;
        double tt = Math.exp(-0.5 * (yy + Math.exp(-1.0 * yy))) / Math.sqrt(Math.PI * 2);
        return this.max * tt;
    }

    @Override
    public double valueAt(double x, double[] a) {
        double yy = (x - a[1]) / a[2];
        double tt = Math.exp(-0.5 * (yy + Math.exp(-1.0 * yy))) / Math.sqrt(Math.PI * 2);
        return a[0] * tt;
    }

    @Override
    public String[] getParameterNames() {
        String[] result = new String[]{"amplitude", "mean", "sigma"};
        return result;
    }

    @Override
    public double[] getParameterValues() {
        double[] result = new double[]{this.max, this.mean, this.sigma};
        return result;
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0) {
            this.max = value;
        } else if (index == 1) {
            this.mean = value;
        } else if (index == 2) {
            this.sigma = value;
        } else {
            throw new IllegalArgumentException("Invalid index to setParameter");
        }
        this.clearFit();
        this.setChanged();
    }

    @Override
    public void setFit(Fitter fit, double[] value) {
        if (value.length != 3) {
            throw new IllegalArgumentException("Argument to setParameters is of wrong length");
        }
        this.max = value[0];
        this.mean = value[1];
        this.sigma = value[2];
        this.setFit(fit);
        this.setChanged();
    }

    @Override
    public String getTitle() {
        return "Landau";
    }

    @Override
    public Statistics getStatistics() {
        return this;
    }

    @Override
    public Handle[] getHandles(double xLow, double xHigh, double yLow, double yHigh) {
        Handle[] result = new Handle[]{new Handle(){

            @Override
            public void moveTo(double x, double y) {
                LandauFunction.this.mean = x;
                LandauFunction.this.max = y;
                LandauFunction.this.clearFit();
                LandauFunction.this.setChanged();
            }

            @Override
            public double getX() {
                return LandauFunction.this.mean;
            }

            @Override
            public double getY() {
                return LandauFunction.this.max;
            }
        }, new Handle(){

            @Override
            public void moveTo(double x, double y) {
                LandauFunction.this.sigma = (LandauFunction.this.mean - x) / 1.177;
                LandauFunction.this.clearFit();
                LandauFunction.this.setChanged();
            }

            @Override
            public double getY() {
                return LandauFunction.this.max / 2.0;
            }

            @Override
            public double getX() {
                return LandauFunction.this.mean - LandauFunction.this.sigma * 1.177;
            }
        }, new Handle(){

            @Override
            public void moveTo(double x, double y) {
                LandauFunction.this.sigma = (x - LandauFunction.this.mean) / 1.177;
                LandauFunction.this.clearFit();
                LandauFunction.this.setChanged();
            }

            @Override
            public double getY() {
                return LandauFunction.this.max / 2.0;
            }

            @Override
            public double getX() {
                return LandauFunction.this.mean + LandauFunction.this.sigma * 1.177;
            }
        }};
        return result;
    }
}

