/*
 * Decompiled with CFR 0.152.
 */
package jasext.flatfileserver;

import hepjas.analysis.EventSource;
import jas2.jds.module.LocalDIM;
import jas2.jds.module.LocalJobBuilder;
import jas2.jds.module.ModuleException;
import jas2.util.Finishable;
import jas2.util.HasHelpPage;
import jas2.util.JASDialog;
import jas2.util.JASTextField;
import jas2.util.JASWizardPage;
import jas2.util.OpenLocalFilePanel;
import jas2.util.UserProperties;
import jasext.flatfileserver.FlatFileEventSource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tablelayout.TableLayout;

public class LocalFlatFileDIM
implements LocalDIM {
    private int m_delim;
    private int m_stringDelimChar;
    private boolean m_firstLineHasTitle;
    private boolean m_hasHeaders;
    private boolean m_gzip;
    private String m_dateTimeFormat;
    private String m_dateFormat;
    private String m_timeFormat;
    private transient LocalJobBuilder m_ljb;
    private transient UserProperties m_prop = UserProperties.getUserProperties();
    private transient FlatFileWizardPage m_wizardPage;
    final int CUSTOM_DELIM = -1;
    private String fileName;

    @Override
    public JASWizardPage getSetupPage() {
        this.m_wizardPage = new FlatFileWizardPage();
        return this.m_wizardPage;
    }

    @Override
    public void setLocalJobBuilder(LocalJobBuilder ljb) {
        this.m_ljb = ljb;
    }

    public String toString() {
        return "Flat file";
    }

    @Override
    public EventSource openDataSet(String fileName) {
        this.fileName = fileName;
        final FlatFileEventSource ffes = new FlatFileEventSource();
        ffes.setFileName(fileName);
        ffes.setDelim(this.m_delim);
        ffes.setQuoteChar(this.m_stringDelimChar);
        ffes.setHasHeaders(this.m_hasHeaders);
        ffes.setFirstLineHasTitle(this.m_firstLineHasTitle);
        ffes.setLocalJobBuilder(this.m_ljb);
        ffes.setGZIP(this.m_gzip);
        ffes.setDateTimeFormat(this.m_dateTimeFormat);
        ffes.setTimeFormat(this.m_timeFormat);
        ffes.setDateFormat(this.m_dateFormat);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ffes.init();
                    if (LocalFlatFileDIM.this.m_wizardPage != null && LocalFlatFileDIM.this.m_wizardPage.isVisible()) {
                        LocalFlatFileDIM.this.m_wizardPage.dispose();
                    }
                    LocalFlatFileDIM.this.m_ljb.setEventSource(ffes);
                }
                catch (ModuleException x) {
                    LocalFlatFileDIM.this.m_wizardPage.handleError("Error opening file", x);
                }
            }
        });
        t.start();
        return null;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.m_prop = UserProperties.getUserProperties();
    }

    public String getFileName() {
        return this.fileName;
    }

    private class FlatFileWizardPage
    extends JASWizardPage
    implements Finishable,
    ChangeListener,
    HasHelpPage {
        private JComboBox m_delimiterOption;
        private JASTextField m_custDelimiter;
        private final JLabel m_customDelimiterLabel;
        private JComboBox m_stringDelim;
        private OpenLocalFilePanel m_filePanel;
        private final String[] stringDelimiterStrings;
        private final int[] stringDelimiterChars;
        private final String[] delimiterStrings;
        private final int[] delimiterChars;
        private final String m_hasHeaders_Key = "HasHeaders";
        private final String m_firstLineHasTitle_Key = "FirstLineHasTitle";
        private final String m_lastDelim_Key = "LastDelim";
        private final String m_lastCustDelimChar_Key = "LastCustDelimChar";
        private final String m_lastStringDelim_Key = "LastStringDelim";
        private final String m_dateTimeFormat_Key = "DateTimeFormat";
        private final String m_timeFormat_Key = "TimeFormat";
        private final String m_dateFormat_Key = "DateFormat";

        FlatFileWizardPage() {
            super(new BorderLayout());
            this.m_customDelimiterLabel = new JLabel("Enter custom delimiter: ");
            this.stringDelimiterStrings = new String[]{"Double Quotation (\")", "Single Quotation (')", "None"};
            this.stringDelimiterChars = new int[]{34, 39, -4};
            this.delimiterStrings = new String[]{"Tab ('\\t')", "Space (' ')", "Comma (',')", "Semi-colon (';')", "Whitespace", "Custom"};
            this.delimiterChars = new int[]{9, 32, 44, 59, -4, -1};
            this.m_hasHeaders_Key = "HasHeaders";
            this.m_firstLineHasTitle_Key = "FirstLineHasTitle";
            this.m_lastDelim_Key = "LastDelim";
            this.m_lastCustDelimChar_Key = "LastCustDelimChar";
            this.m_lastStringDelim_Key = "LastStringDelim";
            this.m_dateTimeFormat_Key = "DateTimeFormat";
            this.m_timeFormat_Key = "TimeFormat";
            this.m_dateFormat_Key = "DateFormat";
            JPanel delim = new JPanel();
            this.m_delimiterOption = new JComboBox();
            for (int i = 0; i < this.delimiterStrings.length; ++i) {
                this.m_delimiterOption.addItem(this.delimiterStrings[i]);
            }
            this.m_delimiterOption.setSelectedIndex(LocalFlatFileDIM.this.m_prop.getInteger("LastDelim", 4));
            this.m_delimiterOption.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    FlatFileWizardPage.this.enableCustomDelimiter();
                    FlatFileWizardPage.this.doEnable();
                }
            });
            int lastDelimChar = LocalFlatFileDIM.this.m_prop.getInteger("LastCustDelimChar", 0);
            this.m_custDelimiter = lastDelimChar > 0 ? new JASTextField(String.valueOf((char)lastDelimChar), 3) : new JASTextField(3);
            this.m_custDelimiter.addKeyListener(this);
            delim.add(this.m_delimiterOption);
            delim.add(this.m_customDelimiterLabel);
            delim.add(this.m_custDelimiter);
            delim.setBorder(BorderFactory.createTitledBorder("Set column delimiter"));
            this.enableCustomDelimiter();
            JPanel stringDelimiterPanel = new JPanel();
            stringDelimiterPanel.setBorder(BorderFactory.createTitledBorder("Select string delimiter:"));
            this.m_stringDelim = new JComboBox();
            for (int i = 0; i < this.stringDelimiterStrings.length; ++i) {
                this.m_stringDelim.addItem(this.stringDelimiterStrings[i]);
            }
            this.m_stringDelim.setSelectedIndex(LocalFlatFileDIM.this.m_prop.getInteger("LastStringDelim", 2));
            stringDelimiterPanel.add(this.m_stringDelim);
            this.m_filePanel = new OpenLocalFilePanel(true, true, "FlatFile");
            this.m_filePanel.addChangeListener(this);
            JPanel headerLinesPanel = new JPanel(new FlowLayout(0));
            JCheckBox title = new JCheckBox("Title in first line", LocalFlatFileDIM.this.m_firstLineHasTitle = LocalFlatFileDIM.this.m_prop.getBoolean("FirstLineHasTitle", false));
            title.setMnemonic('T');
            final JCheckBox headers = new JCheckBox(this.headerCheckBoxString() + "    ", LocalFlatFileDIM.this.m_hasHeaders = LocalFlatFileDIM.this.m_prop.getBoolean("HasHeaders", true));
            headers.setMnemonic('h');
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBox cb = (JCheckBox)e.getSource();
                    if (cb == headers) {
                        LocalFlatFileDIM.this.m_prop.setBoolean("HasHeaders", LocalFlatFileDIM.this.m_hasHeaders = cb.isSelected());
                    } else {
                        LocalFlatFileDIM.this.m_prop.setBoolean("FirstLineHasTitle", LocalFlatFileDIM.this.m_firstLineHasTitle = cb.isSelected());
                        headers.setText(FlatFileWizardPage.this.headerCheckBoxString());
                    }
                }
            };
            title.addActionListener(al);
            headers.addActionListener(al);
            headerLinesPanel.add(title);
            headerLinesPanel.add(headers);
            LocalFlatFileDIM.this.m_dateTimeFormat = LocalFlatFileDIM.this.m_prop.getString("DateTimeFormat", "dd-MMM-yyyy HH:mm:ss");
            LocalFlatFileDIM.this.m_timeFormat = LocalFlatFileDIM.this.m_prop.getString("TimeFormat", "HH:mm:ss");
            LocalFlatFileDIM.this.m_dateFormat = LocalFlatFileDIM.this.m_prop.getString("DateFormat", "dd-MMM-yyyy");
            JButton format = new JButton("Date/Time Formats...");
            format.setMnemonic('D');
            ActionListener al2 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Container f = FlatFileWizardPage.this;
                    while (!(f instanceof Frame)) {
                        f = f.getParent();
                    }
                    DateTimeFormatDialog dlg = new DateTimeFormatDialog((Frame)f);
                    dlg.doModal();
                }
            };
            format.addActionListener(al2);
            headerLinesPanel.add(format);
            this.add("South", headerLinesPanel);
            this.add("Center", delim);
            this.add("East", stringDelimiterPanel);
            this.add("North", this.m_filePanel);
        }

        @Override
        public String getHelpTopic() {
            return "builtInModules.flatFile";
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.doEnable();
        }

        @Override
        public void doEnable() {
            super.doEnable();
        }

        @Override
        protected boolean getFinishEnabled() {
            return this.m_filePanel.getText().length() > 0 && (this.delimiterChars[this.m_delimiterOption.getSelectedIndex()] != -1 || this.m_custDelimiter.getText().length() > 0);
        }

        private void enableCustomDelimiter() {
            boolean customSelected = this.delimiterChars[this.m_delimiterOption.getSelectedIndex()] == -1;
            this.m_customDelimiterLabel.setEnabled(customSelected);
            this.m_customDelimiterLabel.repaint();
            this.m_custDelimiter.setEnabled(customSelected);
            this.m_custDelimiter.repaint();
        }

        private String headerCheckBoxString() {
            return (LocalFlatFileDIM.this.m_firstLineHasTitle ? "Second" : "First") + " line contains column headers";
        }

        @Override
        public void onFinish() {
            int stringDelimiterIndex = this.m_stringDelim.getSelectedIndex();
            LocalFlatFileDIM.this.m_prop.setInteger("LastStringDelim", stringDelimiterIndex);
            LocalFlatFileDIM.this.m_stringDelimChar = this.stringDelimiterChars[stringDelimiterIndex];
            int delimiterOptionIndex = this.m_delimiterOption.getSelectedIndex();
            LocalFlatFileDIM.this.m_prop.setInteger("LastDelim", delimiterOptionIndex);
            LocalFlatFileDIM.this.m_delim = this.delimiterChars[delimiterOptionIndex];
            if (LocalFlatFileDIM.this.m_delim == -1) {
                String s = this.m_custDelimiter.getText();
                if (s.length() == 0) {
                    JOptionPane.showMessageDialog(this, "You must enter a custom delimiter character.", "Error", 0);
                    return;
                }
                if (s.length() == 1) {
                    LocalFlatFileDIM.this.m_delim = s.charAt(0);
                    LocalFlatFileDIM.this.m_prop.setInteger("LastCustDelimChar", LocalFlatFileDIM.this.m_delim);
                } else {
                    JOptionPane.showMessageDialog(this, "Cannot enter more than one delimiting character", "Error", 0);
                    return;
                }
            }
            String fileName = this.m_filePanel.getText();
            LocalFlatFileDIM.this.m_gzip = this.m_filePanel.getGZIPed();
            LocalFlatFileDIM.this.m_ljb.createJob(fileName);
            this.m_filePanel.saveState();
        }

        @Override
        protected void dispose() {
            super.dispose();
        }

        @Override
        protected void handleError(String message, Throwable t) {
            super.handleError(message, t);
        }

        private class DateTimeFormatDialog
        extends JASDialog {
            private JASTextField m_dateTimeField;
            private JASTextField m_timeField;
            private JASTextField m_dateField;

            DateTimeFormatDialog(Frame f) {
                super(f, "Date/Time Format");
                this.m_dateTimeField = new JASTextField(LocalFlatFileDIM.this.m_dateTimeFormat);
                this.m_timeField = new JASTextField(LocalFlatFileDIM.this.m_timeFormat);
                this.m_dateField = new JASTextField(LocalFlatFileDIM.this.m_dateFormat);
                Container root = this.getContentPane();
                root.setLayout(new TableLayout());
                root.add("1 1", new JLabel("Date-Time Format"));
                root.add("2 1", this.m_dateTimeField);
                root.add("1 2", new JLabel("Time Format"));
                root.add("2 2", this.m_timeField);
                root.add("1 3", new JLabel("Date Format"));
                root.add("2 3", this.m_dateField);
                this.setHelpTopic("builtInModules.flatFile.dateTimeFormat");
                this.pack();
            }

            @Override
            public void onOK() {
                super.onOK();
                LocalFlatFileDIM.this.m_dateTimeFormat = this.m_dateTimeField.getText();
                LocalFlatFileDIM.this.m_timeFormat = this.m_timeField.getText();
                LocalFlatFileDIM.this.m_dateFormat = this.m_dateField.getText();
                LocalFlatFileDIM.this.m_prop.setString("DateTimeFormat", LocalFlatFileDIM.this.m_dateTimeFormat);
                LocalFlatFileDIM.this.m_prop.setString("TimeFormat", LocalFlatFileDIM.this.m_timeFormat);
                LocalFlatFileDIM.this.m_prop.setString("DateFormat", LocalFlatFileDIM.this.m_dateFormat);
            }
        }
    }
}

