/*
 * Decompiled with CFR 0.152.
 */
package jasext.flatfileserver;

import jas2.hist.Statistics;
import jasext.flatfileserver.DataColumn;
import jasext.flatfileserver.StringDataColumn;

class IntegerDataColumn
extends DataColumn {
    private int min = 0;
    private int max = 1;
    private int[] data;

    IntegerDataColumn(StringDataColumn source) {
        super(source);
        this.data = new int[source.getSize()];
        String s = null;
        if (this.data.length > 0) {
            s = source.getString(0);
            this.max = s == null ? 0 : Integer.valueOf(s);
            this.min = this.max;
        }
        for (int i = 0; i < this.data.length; ++i) {
            int d;
            s = source.getString(i);
            int n = d = s == null ? 0 : Integer.parseInt(s);
            if (d > this.max) {
                this.max = d;
            }
            if (d < this.min) {
                this.min = d;
            }
            this.data[i] = d;
        }
    }

    public int getSize() {
        return this.data.length;
    }

    @Override
    public double[][] rebin(int bins, double min, double max, boolean wantErrors, boolean hurry) {
        double[] hist = new double[bins];
        double binWidth = (max - min) / (double)bins;
        for (int j = 0; j < bins; ++j) {
            hist[j] = 0.0;
        }
        for (int i = 0; i < this.data.length; ++i) {
            int bin = (int)(((double)this.data[i] - min) / binWidth);
            if (bin < 0 || bin >= bins) continue;
            int n = bin;
            hist[n] = hist[n] + 1.0;
        }
        double[][] result = new double[][]{hist};
        return result;
    }

    @Override
    public String[] getAxisLabels() {
        return null;
    }

    @Override
    public boolean isRebinnable() {
        return true;
    }

    @Override
    public int getAxisType() {
        return 4;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public int getBins() {
        return 40;
    }

    @Override
    double getDouble(int n) {
        return this.data[n];
    }

    @Override
    int getInt(int n) {
        return this.data[n];
    }

    @Override
    String getType() {
        return "integer";
    }

    public Statistics getStatistics() {
        return null;
    }
}

