/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.pluginmanager;

import jas2.swingstudio.JavaAnalysisStudio;
import jas2.util.JASDialog;
import jas2.util.JASState;
import jas2.util.pluginmanager.PluginDownloadProgress;
import jas2.util.pluginmanager.PluginManager;
import jas2.util.pluginmanager.PluginManagerUI;
import jas2.util.pluginmanager.PluginProperties;
import jas2.util.pluginmanager.VersionNumberCompare;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UpdatePluginsUI
extends JASDialog {
    private static JFrame frame;
    private PluginManager pluginmanager;
    private PluginManagerUI pluginmanagerui;
    private PluginProperties[] plugins;
    private JList pluginslist;
    private JLabel name;
    private JLabel author;
    private JLabel currVersion;
    private JLabel latestVersion;
    private JLabel requires;
    private JLabel path;
    private JTextArea description;
    private JButton update;
    private Thread updateguithread;
    private Container c;

    public UpdatePluginsUI(PluginManager pm, PluginManagerUI pmui) {
        super((Frame)frame, "Update Plugins", true, 13);
        this.pluginmanager = pm;
        this.pluginmanagerui = pmui;
        this.showUpdatePluginsUI();
    }

    private void showUpdatePluginsUI() {
        super.setHelpTopic("userInterface.pluginmanager");
        this.c = this.getContentPane();
        this.c.add("North", new JLabel("New Versions of the following plugins are available:"));
        JPanel panel = new JPanel(new BorderLayout());
        this.pluginslist = new JList();
        this.pluginslist.setCellRenderer(new Renderer());
        this.pluginslist.setVisibleRowCount(8);
        this.pluginslist.addListSelectionListener(new ListHandler());
        panel.add("Center", new JScrollPane(this.pluginslist));
        JPanel panel2 = new JPanel(new BorderLayout());
        JPanel labelBox = new JPanel(new GridLayout(7, 1));
        labelBox.add(new JLabel("Name: ", 4));
        labelBox.add(new JLabel("Author: ", 4));
        labelBox.add(new JLabel("Current Version: ", 4));
        labelBox.add(new JLabel("Latest Version: ", 4));
        labelBox.add(new JLabel("Requires: ", 4));
        labelBox.add(new JLabel("Install Path:", 4));
        labelBox.add(new JLabel("Description", 4));
        panel2.add("West", labelBox);
        JPanel valueBox = new JPanel(new GridLayout(7, 1));
        this.name = new JLabel();
        valueBox.add(this.name);
        this.author = new JLabel();
        valueBox.add(this.author);
        this.currVersion = new JLabel();
        valueBox.add(this.currVersion);
        this.latestVersion = new JLabel();
        valueBox.add(this.latestVersion);
        this.requires = new JLabel();
        valueBox.add(this.requires);
        this.path = new JLabel();
        valueBox.add(this.path);
        valueBox.add(Box.createGlue());
        panel2.add("Center", valueBox);
        this.description = new JTextArea(6, 30);
        this.description.setEditable(false);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        panel2.add("South", new JScrollPane(this.description));
        panel.add("South", panel2);
        this.c.add("Center", panel);
        JPanel buttons = new JPanel();
        this.update = new JButton("Update selected plugins");
        this.update.setEnabled(false);
        this.getRootPane().setDefaultButton(this.update);
        this.update.addActionListener(new ActionHandler());
        buttons.add(this.update);
        this.c.add("South", buttons);
        this.updateList();
        this.show();
    }

    private void updateList() {
        Vector vectplugins = this.pluginmanager.getOutDatedPluginList();
        this.plugins = new PluginProperties[vectplugins.size()];
        vectplugins.copyInto(this.plugins);
        if (this.plugins != null) {
            this.pluginslist.setListData(this.plugins);
        }
        this.pack();
    }

    private Object[] checkSelectedPlugins() {
        Object[] selected = this.pluginslist.getSelectedValues();
        Vector<PluginProperties> okselected = new Vector<PluginProperties>();
        VersionNumberCompare vnc = new VersionNumberCompare();
        for (int i = 0; i < selected.length; ++i) {
            PluginProperties dummyplug = (PluginProperties)selected[i];
            File checkwrite = new File(dummyplug.path);
            if (!checkwrite.canWrite()) {
                Object[] options = new String[]{"OK"};
                int n = JOptionPane.showOptionDialog(this.c, "No write access to " + checkwrite.getAbsolutePath() + ". " + dummyplug.name + " cannot be updated.", "Updating Plugins", -1, 0, null, options, options[0]);
                continue;
            }
            try {
                int versionresults = vnc.compareVersions(JavaAnalysisStudio.getVersionNumber(), dummyplug.minJASversion, false);
                if (versionresults == 1) {
                    Object[] options = new String[]{"OK"};
                    String updatemessage = dummyplug.name + " requires JAS version " + dummyplug.minJASversion + " or greater. Latest JAS version available at www-sldnt.slac.stanford.edu/jas.";
                    int n = JOptionPane.showOptionDialog(this.c, updatemessage, "Updating Plugins", -1, 0, null, options, options[0]);
                    continue;
                }
                if (!(versionresults != 1 & versionresults != 0)) continue;
                okselected.addElement(dummyplug);
                continue;
            }
            catch (VersionNumberCompare.VersionCompareException versionCompareException) {
                // empty catch block
            }
        }
        if (okselected.size() > 0) {
            Object[] returnok = new Object[okselected.size()];
            okselected.copyInto(returnok);
            return returnok;
        }
        return null;
    }

    @Override
    public void onOK() {
        if (this.updateguithread != null) {
            this.updateguithread.stop();
            this.updateguithread = null;
        }
        this.dispose();
    }

    @Override
    protected void enableHelp(JASState state) {
        state.setEnabled(true);
    }

    @Override
    public void onCancel() {
        if (this.updateguithread != null) {
            this.updateguithread.stop();
            this.updateguithread = null;
        }
        this.dispose();
    }

    class Renderer
    extends JLabel
    implements ListCellRenderer {
        Renderer() {
            this.setOpaque(true);
            this.setFont(UIManager.getFont("Tree.font"));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof PluginProperties) {
                this.setText(((PluginProperties)value).name);
            } else {
                this.setText(value.toString());
            }
            if (isSelected) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            int index = UpdatePluginsUI.this.pluginslist.getSelectedIndex();
            Object selected = UpdatePluginsUI.this.pluginslist.getSelectedValue();
            if (selected instanceof PluginProperties) {
                UpdatePluginsUI.this.update.setEnabled(true);
                PluginProperties plugin = (PluginProperties)selected;
                UpdatePluginsUI.this.name.setText(plugin.name);
                UpdatePluginsUI.this.author.setText(plugin.author);
                UpdatePluginsUI.this.currVersion.setText(plugin.currversion);
                UpdatePluginsUI.this.latestVersion.setText(plugin.latestversion);
                UpdatePluginsUI.this.requires.setText(plugin.requires);
                UpdatePluginsUI.this.path.setText(plugin.path);
                UpdatePluginsUI.this.description.setText(plugin.description);
            } else {
                UpdatePluginsUI.this.update.setEnabled(false);
                UpdatePluginsUI.this.name.setText(null);
                UpdatePluginsUI.this.author.setText(null);
                UpdatePluginsUI.this.currVersion.setText(null);
                UpdatePluginsUI.this.latestVersion.setText(null);
                UpdatePluginsUI.this.requires.setText(null);
                UpdatePluginsUI.this.path.setText(null);
                UpdatePluginsUI.this.description.setText(null);
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object[] okselected;
            if (evt.getSource() == UpdatePluginsUI.this.update && (okselected = UpdatePluginsUI.this.checkSelectedPlugins()) != null) {
                UpdatePluginsUI.this.updateguithread = new UpdateGUIThread(okselected);
                UpdatePluginsUI.this.updateguithread.start();
            }
        }
    }

    class UpdateGUIThread
    extends Thread {
        private Object[] selected;

        UpdateGUIThread(Object[] plugins) {
            this.selected = plugins;
        }

        @Override
        public void run() {
            PluginDownloadProgress pdlp = new PluginDownloadProgress(this.selected, "update");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdatePluginsUI.this.pluginmanagerui.updateTree();
                    UpdatePluginsUI.this.updateList();
                    UpdatePluginsUI.this.show();
                }
            });
        }
    }
}

