/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.pluginmanager;

import jas2.util.Application;
import jas2.util.pluginmanager.PluginManagerUI;
import jas2.util.pluginmanager.PluginProperties;
import jas2.util.pluginmanager.PluginXMLReader;
import jas2.util.pluginmanager.VersionNumberCompare;
import jas2.util.xml.JASDOMParser;
import java.awt.Frame;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginManager {
    private Vector availablelist;
    private Vector pluginsloadedatstartup = new Vector();
    private PluginXMLReader xmlreader;
    private static final String jaspluginfile = "jasplugin.xml";
    private static final String jasdtdfile = "jasplugin.dtd";
    private String userdir;
    private String systemdir;
    private boolean readpluginXMLOK;

    public PluginManager(String system, String user) {
        this.userdir = user;
        this.systemdir = system;
    }

    public String getSystemDirectory() {
        return this.systemdir;
    }

    public String getUserDirectory() {
        return this.userdir;
    }

    private void addAvailablePluginList(String path, String name, String author, String currversion, String description, String latestversion, String requires, URL[] urldownloads, int state, String[] files, String minJASversion, boolean removeable, boolean installable) {
        PluginProperties plugin = new PluginProperties(path, name, author, currversion, description, latestversion, requires, urldownloads, state, files, minJASversion, removeable, installable);
        this.availablelist.addElement(plugin);
    }

    private void addAvailablePluginList(PluginProperties plugin) {
        this.availablelist.addElement(plugin);
    }

    public void setPluginLoadedAtStart(String pluginname, String version, String path, String file) {
        String[] plugininfo = new String[]{pluginname, version, path, file};
        this.pluginsloadedatstartup.addElement(plugininfo);
    }

    protected void removeAvailablePluginList(PluginProperties removeplugin) {
        this.availablelist.removeElement(removeplugin);
    }

    protected Vector getLoadedPluginList() {
        Vector loadedplugins = new Vector();
        if (!this.availablelist.isEmpty()) {
            for (int i = 0; i < this.availablelist.size(); ++i) {
                if (((PluginProperties)this.availablelist.elementAt((int)i)).state != 1) continue;
                loadedplugins.addElement(this.availablelist.elementAt(i));
            }
        }
        return loadedplugins;
    }

    protected Vector getAvailablePluginList() {
        return this.availablelist;
    }

    protected Vector getNotInstalledPluginList() {
        Vector notinstalledplugins = new Vector();
        if (!this.availablelist.isEmpty()) {
            for (int i = 0; i < this.availablelist.size(); ++i) {
                if (!(((PluginProperties)this.availablelist.elementAt((int)i)).installable & ((PluginProperties)this.availablelist.elementAt((int)i)).state == 0)) continue;
                notinstalledplugins.addElement(this.availablelist.elementAt(i));
            }
        }
        return notinstalledplugins;
    }

    public void initializePluginList() {
        try {
            URL url = new URL("http://jas.freehep.org/plugins/jasplugin.xml");
            this.xmlreader = new PluginXMLReader(new InputStreamReader(url.openStream()), jaspluginfile, jasdtdfile);
        }
        catch (IOException ie) {
            Object[] options = new String[]{"OK"};
            int iomessage = JOptionPane.showOptionDialog(Application.getApplication().getParent(), "Error initializing plugin manager: " + ie, "Plugin Manager", -1, 0, null, options, options[0]);
            this.readpluginXMLOK = false;
            return;
        }
        catch (JASDOMParser.JASXMLException pe) {
            Object[] options = new String[]{"OK"};
            int iomessage = JOptionPane.showOptionDialog(Application.getApplication().getParent(), "Error initializing plugin manager: " + pe, "Plugin Manager", -1, 0, null, options, options[0]);
            this.readpluginXMLOK = false;
            return;
        }
        this.availablelist = new Vector();
        NodeList nodelist = this.xmlreader.getPluginNodeList();
        String description = null;
        int state = 0;
        Vector<URL> downloadsvect = new Vector<URL>();
        URL urldownload = null;
        Vector<String> filesvect = new Vector<String>();
        for (int i = 1; i < nodelist.getLength(); ++i) {
            Node pluginnode = nodelist.item(i);
            if (pluginnode.getNodeName().compareTo("Plugin") != 0) continue;
            NamedNodeMap nodemap = pluginnode.getAttributes();
            String name = nodemap.getNamedItem("Name").getNodeValue();
            String author = nodemap.getNamedItem("Author").getNodeValue();
            String latestversion = nodemap.getNamedItem("LatestVersion").getNodeValue();
            String requirements = nodemap.getNamedItem("Requirements").getNodeValue();
            String minJASversion = nodemap.getNamedItem("MinJASVersion").getNodeValue();
            boolean removeable = nodemap.getNamedItem("Removeable").getNodeValue().compareTo("False") != 0;
            NodeList elementslist = pluginnode.getChildNodes();
            for (int j = 1; j < elementslist.getLength(); ++j) {
                Node elementnode = elementslist.item(j);
                if (elementnode.getNodeName().equals("Downloads")) {
                    NamedNodeMap elementmap = elementnode.getAttributes();
                    String file = elementmap.getNamedItem("File").getNodeValue();
                    try {
                        urldownload = new URL(elementmap.getNamedItem("URLDownload").getNodeValue());
                    }
                    catch (MalformedURLException me) {
                        System.out.println("Malformed url: urldownload " + me);
                    }
                    downloadsvect.addElement(urldownload);
                    filesvect.addElement(file);
                    continue;
                }
                if (!elementnode.getNodeName().equals("Description")) continue;
                description = elementnode.getFirstChild().getNodeValue();
                StringBuffer descriptionbuffer = new StringBuffer();
                int len = description.length();
                for (int k = 0; k < len; ++k) {
                    if (description.charAt(k) == '\t' || k + 1 < len && description.charAt(k) == ' ' && description.charAt(k + 1) == ' ') continue;
                    if (k == len - 1 && description.charAt(k) == ' ') break;
                    if (description.charAt(k) == '\r' || description.charAt(k) == '\n') {
                        descriptionbuffer.append(' ');
                        continue;
                    }
                    descriptionbuffer.append(description.charAt(k));
                }
                description = descriptionbuffer.toString();
            }
            Object[] urldownloads = new URL[downloadsvect.size()];
            downloadsvect.copyInto(urldownloads);
            downloadsvect.removeAllElements();
            Object[] files = new String[filesvect.size()];
            filesvect.copyInto(files);
            filesvect.removeAllElements();
            this.addAvailablePluginList(null, name, author, null, description, latestversion, requirements, (URL[])urldownloads, state, (String[])files, minJASversion, removeable, true);
        }
        this.checkLoadedAtStart();
        this.readpluginXMLOK = true;
    }

    public boolean getReadPluginXMLOK() {
        return this.readpluginXMLOK;
    }

    private void checkLoadedAtStart() {
        boolean inxmlfile = false;
        for (int i = 0; i < this.pluginsloadedatstartup.size(); ++i) {
            String[] pluginfo = (String[])this.pluginsloadedatstartup.elementAt(i);
            String[] filename = new String[]{pluginfo[3]};
            inxmlfile = false;
            for (int j = 0; j < this.availablelist.size(); ++j) {
                PluginProperties dummyplug = (PluginProperties)this.availablelist.elementAt(j);
                if (dummyplug.name.compareTo(pluginfo[0]) != 0) continue;
                dummyplug.currversion = pluginfo[1];
                dummyplug.setState(1);
                dummyplug.path = pluginfo[2];
                inxmlfile = true;
            }
            if (inxmlfile) continue;
            this.addAvailablePluginList(pluginfo[2], pluginfo[0], null, null, null, null, null, null, 1, filename, null, true, false);
        }
    }

    protected Vector getOutDatedPluginList() {
        Vector outdatedlist = new Vector();
        VersionNumberCompare versioncompare = new VersionNumberCompare();
        if (this.availablelist != null) {
            for (int i = 0; i < this.availablelist.size(); ++i) {
                PluginProperties dummyplug = (PluginProperties)this.availablelist.elementAt(i);
                if (!(dummyplug.state == 1 & dummyplug.installable & dummyplug.currversion.compareTo("unknown") != 0 & dummyplug.latestversion.compareTo("unknown") != 0)) continue;
                try {
                    int compareresult = versioncompare.compareVersions(dummyplug.currversion, dummyplug.latestversion, true);
                    if (compareresult != 1) continue;
                    outdatedlist.addElement(this.availablelist.elementAt(i));
                    continue;
                }
                catch (VersionNumberCompare.VersionCompareException vce) {
                    System.out.println(vce + " For plugin " + dummyplug.name + ": an element of the latest version number was < coressponding current version element. ");
                }
            }
        }
        return outdatedlist;
    }

    public void showPluginManager(Frame frame) {
        PluginManagerUI plugmanagerui = new PluginManagerUI(this, frame);
        plugmanagerui.showManagerGUI();
    }
}

