/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.pluginmanager;

import jas2.swingstudio.JavaAnalysisStudio;
import jas2.util.JASDialog;
import jas2.util.JASState;
import jas2.util.pluginmanager.PluginDownloadProgress;
import jas2.util.pluginmanager.PluginManager;
import jas2.util.pluginmanager.PluginManagerUI;
import jas2.util.pluginmanager.PluginProperties;
import jas2.util.pluginmanager.VersionNumberCompare;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class InstallPluginsUI
extends JASDialog {
    private static JFrame frame;
    private PluginProperties[] plugins;
    private PluginManager pluginmanager;
    private PluginManagerUI pluginmanagerui;
    private JList pluginslist;
    private JLabel name;
    private JLabel author;
    private JLabel version;
    private JLabel requires;
    private JTextArea description;
    private JRadioButton installUser;
    private JRadioButton installSystem;
    private JButton install;
    private Thread installguithread;
    private Container c;
    private boolean accessdirs;

    public InstallPluginsUI(PluginManager pm, PluginManagerUI pmui) {
        super((Frame)frame, "Install Plugins", true, 13);
        this.pluginmanager = pm;
        this.pluginmanagerui = pmui;
        this.showInstallUI();
    }

    private void showInstallUI() {
        super.setHelpTopic("userInterface.pluginmanager");
        this.c = this.getContentPane();
        this.c.removeAll();
        this.c.setLayout(new BorderLayout());
        this.c.add("North", new JLabel("The following plugins are available for installation"));
        JPanel panel = new JPanel(new BorderLayout());
        this.pluginslist = new JList();
        this.pluginslist.setCellRenderer(new Renderer());
        this.pluginslist.setVisibleRowCount(8);
        this.pluginslist.addListSelectionListener(new ListHandler());
        panel.add("Center", new JScrollPane(this.pluginslist));
        JPanel panel2 = new JPanel(new BorderLayout());
        JPanel labelBox = new JPanel(new GridLayout(5, 1));
        labelBox.add(new JLabel("Name: ", 4));
        labelBox.add(new JLabel("Author: ", 4));
        labelBox.add(new JLabel("Version: ", 4));
        labelBox.add(new JLabel("Requires: ", 4));
        labelBox.add(new JLabel("Description ", 4));
        panel2.add("West", labelBox);
        JPanel valueBox = new JPanel(new GridLayout(5, 1));
        this.name = new JLabel();
        valueBox.add(this.name);
        this.author = new JLabel();
        valueBox.add(this.author);
        this.version = new JLabel();
        valueBox.add(this.version);
        this.requires = new JLabel();
        valueBox.add(this.requires);
        valueBox.add(Box.createGlue());
        panel2.add("Center", valueBox);
        this.description = new JTextArea(6, 30);
        this.description.setEditable(false);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        JPanel panel3 = new JPanel(new BorderLayout());
        panel3.add("North", new JScrollPane(this.description));
        ButtonGroup grp = new ButtonGroup();
        this.installUser = new JRadioButton();
        this.installUser.setText("Install in user directory: " + this.pluginmanager.getUserDirectory());
        grp.add(this.installUser);
        panel3.add("Center", this.installUser);
        this.installSystem = new JRadioButton("Install in system directory: " + this.pluginmanager.getSystemDirectory());
        grp.add(this.installSystem);
        panel3.add("South", this.installSystem);
        this.accessdirs = this.checkFileAccess();
        this.install = new JButton("Install selected plugins");
        this.install.setEnabled(false);
        this.getRootPane().setDefaultButton(this.install);
        this.install.addActionListener(new ActionHandler());
        Box box = new Box(0);
        box.add(Box.createGlue());
        box.add(this.install);
        box.add(Box.createGlue());
        panel2.add("South", panel3);
        panel.add("South", panel2);
        this.c.add("Center", panel);
        this.c.add("South", box);
        this.updateList();
        this.show();
    }

    private boolean checkFileAccess() {
        boolean syscheck = false;
        boolean usercheck = false;
        File system = new File(this.pluginmanager.getSystemDirectory());
        File user = new File(this.pluginmanager.getUserDirectory());
        if (!system.exists()) {
            system = new File(system.getParent());
        }
        if (!user.exists()) {
            user = new File(user.getParent());
        }
        if (user.canWrite()) {
            usercheck = true;
        }
        if (system.canWrite()) {
            syscheck = true;
        }
        if (syscheck & usercheck) {
            this.installSystem.setSelected(true);
            return true;
        }
        if (usercheck) {
            this.installSystem.setEnabled(false);
            this.installUser.setSelected(true);
            return true;
        }
        if (syscheck) {
            this.installUser.setEnabled(false);
            this.installSystem.setSelected(true);
            return true;
        }
        this.installUser.setEnabled(false);
        this.installSystem.setEnabled(false);
        return false;
    }

    private void updateList() {
        Vector vectplugins = this.pluginmanager.getNotInstalledPluginList();
        this.plugins = new PluginProperties[vectplugins.size()];
        vectplugins.copyInto(this.plugins);
        if (this.plugins != null) {
            this.pluginslist.setListData(this.plugins);
        }
        this.pack();
    }

    private Object[] checkSelectedPlugins() {
        Object[] selected = this.pluginslist.getSelectedValues();
        Vector<PluginProperties> okselected = new Vector<PluginProperties>();
        VersionNumberCompare vnc = new VersionNumberCompare();
        for (int i = 0; i < selected.length; ++i) {
            PluginProperties dummyplug = (PluginProperties)selected[i];
            try {
                int versionresults = vnc.compareVersions(JavaAnalysisStudio.getVersionNumber(), dummyplug.minJASversion, false);
                if (versionresults == 1) {
                    Object[] options = new String[]{"OK"};
                    String updatemessage = dummyplug.name + " requires JAS version " + dummyplug.minJASversion + " or greater. Latest JAS version available at www-sldnt.slac.stanford.edu/jas.";
                    int n = JOptionPane.showOptionDialog(this.c, updatemessage, "Installing Plugins", -1, 0, null, options, options[0]);
                    continue;
                }
                if (!(versionresults != 1 & versionresults != 0)) continue;
                okselected.addElement(dummyplug);
                continue;
            }
            catch (VersionNumberCompare.VersionCompareException versionCompareException) {
                // empty catch block
            }
        }
        if (okselected.size() > 0) {
            Object[] returnok = new Object[okselected.size()];
            okselected.copyInto(returnok);
            return returnok;
        }
        return null;
    }

    private String makeInstallDirectories() {
        if (this.installUser.isSelected()) {
            String path = this.pluginmanager.getUserDirectory();
            File installdir = new File(path);
            if (!installdir.isDirectory()) {
                installdir.mkdir();
            }
            return path;
        }
        String path = this.pluginmanager.getSystemDirectory();
        File installdir = new File(path);
        if (!installdir.isDirectory()) {
            installdir.mkdir();
        }
        return path;
    }

    @Override
    public void onOK() {
        if (this.installguithread != null) {
            this.installguithread.stop();
            this.installguithread = null;
        }
        this.dispose();
    }

    @Override
    protected void enableHelp(JASState state) {
        state.setEnabled(true);
    }

    @Override
    public void onCancel() {
        if (this.installguithread != null) {
            this.installguithread.stop();
            this.installguithread = null;
        }
        this.dispose();
    }

    class Renderer
    extends JLabel
    implements ListCellRenderer {
        Renderer() {
            this.setOpaque(true);
            this.setFont(UIManager.getFont("Tree.font"));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof PluginProperties) {
                this.setText(((PluginProperties)value).name);
            }
            if (isSelected) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            Object selected = InstallPluginsUI.this.pluginslist.getSelectedValue();
            if (selected instanceof PluginProperties) {
                InstallPluginsUI.this.install.setEnabled(true);
                PluginProperties plugin = (PluginProperties)selected;
                InstallPluginsUI.this.name.setText(plugin.name);
                InstallPluginsUI.this.author.setText(plugin.author);
                InstallPluginsUI.this.version.setText(plugin.latestversion);
                InstallPluginsUI.this.requires.setText(plugin.requires);
                InstallPluginsUI.this.description.setText(plugin.description);
            } else {
                InstallPluginsUI.this.install.setEnabled(false);
                InstallPluginsUI.this.name.setText(null);
                InstallPluginsUI.this.author.setText(null);
                InstallPluginsUI.this.version.setText(null);
                InstallPluginsUI.this.requires.setText(null);
                InstallPluginsUI.this.description.setText(null);
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == InstallPluginsUI.this.install) {
                if (!InstallPluginsUI.this.accessdirs) {
                    Object[] options = new String[]{"OK"};
                    int n = JOptionPane.showOptionDialog(InstallPluginsUI.this.c, "You do not have write access to an install directory.", "Installing Plugins", -1, 0, null, options, options[0]);
                } else {
                    Object[] okselected = InstallPluginsUI.this.checkSelectedPlugins();
                    if (okselected != null) {
                        InstallPluginsUI.this.installguithread = new InstallGUIThread(okselected);
                        InstallPluginsUI.this.installguithread.start();
                    }
                }
            }
        }
    }

    class InstallGUIThread
    extends Thread {
        PluginDownloadProgress pdlp;
        Object[] selected;
        String path;

        InstallGUIThread(Object[] plugins) {
            this.selected = plugins;
        }

        @Override
        public void run() {
            this.path = InstallPluginsUI.this.makeInstallDirectories();
            this.pdlp = new PluginDownloadProgress(this.selected, this.path);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InstallPluginsUI.this.pluginmanagerui.updateTree();
                    InstallPluginsUI.this.updateList();
                    InstallPluginsUI.this.show();
                }
            });
        }
    }
}

