/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.moverlayeredpane;

import jas2.util.moverlayeredpane.DefaultMOB;
import jas2.util.moverlayeredpane.MLPArrowFactory;
import jas2.util.moverlayeredpane.MLPLabelFactory;
import jas2.util.moverlayeredpane.MovableObjectBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class MoverLayeredPane
extends JLayeredPane {
    private static final Integer BOTTOM_LAYER = new Integer(0);
    private static final Integer BORDER_LAYER = new Integer(50);
    private MoverPanel contentPanel;
    private BorderPanel borderPanel;
    private int cursorState;
    private Component pocusComponent;
    private Point offsetFromTopLeftCorner;
    private Rectangle initialSize = null;
    private Point dragOffset;
    private Point dragStart;
    private JPopupMenu pm;
    private int numRepaints = 0;
    private static final int REPAINT_FUDGE_FACTOR = 10;
    private static final int FULL_REPAINT = 5;
    private static int numEvents = 0;

    public MoverLayeredPane() {
        this.setLayout(new MLPLayout());
        this.contentPanel = new MoverPanel();
        this.borderPanel = new BorderPanel();
        this.add((Component)this.contentPanel, BOTTOM_LAYER);
        this.add((Component)this.borderPanel, BORDER_LAYER);
        this.contentPanel.setVisible(true);
        this.setCursorState(0);
    }

    public JComponent getContentPanel() {
        return this.contentPanel;
    }

    public JComponent getBorderPanel() {
        return this.borderPanel;
    }

    public void setCursorState(int newState) {
        this.cursorState = newState;
        switch (this.cursorState) {
            case 1: {
                this.setCursor(Cursor.getPredefinedCursor(1));
                this.contentPanel.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            case 0: {
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.contentPanel.setCursor(Cursor.getPredefinedCursor(0));
                break;
            }
        }
    }

    public static MoverLayeredPane getSampleLayeredPane() {
        MoverLayeredPane mlp = new MoverLayeredPane();
        JButton b1 = new JButton("Button 1");
        JButton b2 = new JButton("Button 2");
        JButton b3 = new JButton("Button 3");
        JPanel p1 = new JPanel();
        JButton pb1 = new JButton("hi iam a button");
        p1.add(pb1);
        JLabel lab1 = new JLabel("this is a JLabel");
        lab1.setBorder(BorderFactory.createLineBorder(Color.red));
        lab1.setSize(lab1.getPreferredSize());
        lab1.setVisible(true);
        p1.add(lab1);
        p1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        JTextField ijtf = new JTextField("inner text field!");
        ijtf.setLocation(50, 50);
        ijtf.setSize(ijtf.getPreferredSize());
        p1.add(ijtf);
        p1.setSize(p1.getPreferredSize().width + 40, p1.getPreferredSize().height + 40);
        p1.setLocation(250, 250);
        p1.setBorder(BorderFactory.createLineBorder(Color.black));
        JLabel lab2 = new JLabel("a JLabel on its own");
        lab2.setBorder(BorderFactory.createLineBorder(Color.cyan));
        lab2.setSize(lab2.getPreferredSize());
        lab2.setVisible(true);
        lab2.setLocation(300, 100);
        JTextField jtf = new JTextField("Hello world!");
        jtf.setLocation(50, 50);
        jtf.setSize(jtf.getPreferredSize());
        b1.setSize(b1.getPreferredSize());
        b2.setSize(b2.getPreferredSize());
        b3.setSize(b3.getPreferredSize());
        b1.setLocation(100, 100);
        b2.setLocation(200, 200);
        b3.setLocation(300, 300);
        b1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        b3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        mlp.getContentPanel().add(lab2);
        mlp.getContentPanel().add(p1);
        mlp.getContentPanel().add(b1);
        mlp.getContentPanel().add(b2);
        mlp.getContentPanel().add(b3);
        mlp.getContentPanel().add(jtf);
        return mlp;
    }

    public static void main(String[] args) {
        MoverLayeredPane mlp = MoverLayeredPane.getSampleLayeredPane();
        mlp.setSize(800, 600);
        mlp.setLocation(50, 50);
        JFrame f = new JFrame();
        f.getContentPane().setLayout(null);
        f.getContentPane().add(mlp);
        f.setSize(900, 700);
        f.setVisible(true);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Window w = e.getWindow();
                w.setVisible(false);
                w.dispose();
                System.exit(0);
            }
        });
        mlp.revalidate();
        mlp.repaint();
    }

    public void setMLPObjectFactory(MLPLabelFactory mlpLabelFactory) {
    }

    public void setMLPObjectFactory(MLPArrowFactory theArrowFactory) {
    }

    class MoverPanel
    extends JPanel {
        private SmartFocusListener smartfl;
        private SmartContainerListener smartcl;

        MoverPanel() {
            super(null);
            this.enableEvents(50L);
            this.smartfl = new SmartFocusListener();
            this.smartcl = new SmartContainerListener();
            this.addContainerListener(this.smartcl);
        }

        Component findChildThatContainsPoint(MouseEvent e) {
            Component[] children = this.getComponents();
            Object temp = null;
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].contains(e.getX() - children[i].getLocation().x, e.getY() - children[i].getLocation().y)) continue;
                return children[i];
            }
            return null;
        }

        private void recursiveListenerAddOrRemove(boolean add, Component comp, int recursionLevel, Component topLevelComponent) {
            if (add) {
                comp.addFocusListener(this.smartfl);
                if (comp instanceof Container) {
                    ((Container)comp).addContainerListener(this.smartcl);
                }
            } else {
                comp.removeFocusListener(this.smartfl);
                if (comp instanceof Container) {
                    ((Container)comp).removeContainerListener(this.smartcl);
                }
            }
            if (comp instanceof Container) {
                Component[] grandkids = ((Container)comp).getComponents();
                for (int i = 0; i < grandkids.length; ++i) {
                    this.recursiveListenerAddOrRemove(add, grandkids[i], recursionLevel + 1, topLevelComponent);
                }
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                Component childThatContainsPoint = this.findChildThatContainsPoint(e);
                block0 : switch (e.getID()) {
                    case 501: {
                        switch (MoverLayeredPane.this.cursorState) {
                            case 1: {
                                break;
                            }
                            case 0: {
                                if (childThatContainsPoint == null) break block0;
                                childThatContainsPoint.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, childThatContainsPoint));
                                break;
                            }
                        }
                        break;
                    }
                    case 500: 
                    case 502: {
                        switch (MoverLayeredPane.this.cursorState) {
                            case 1: {
                                break block0;
                            }
                            case 0: {
                                if (childThatContainsPoint != null) {
                                    childThatContainsPoint.requestFocus();
                                    break block0;
                                }
                                MoverLayeredPane.this.pocusComponent = null;
                                this.requestFocus();
                                this.repaint();
                                break block0;
                            }
                        }
                        break;
                    }
                    default: {
                        super.processMouseEvent(e);
                    }
                }
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            if (e.getID() == 506) {
                switch (MoverLayeredPane.this.cursorState) {
                    case 1: {
                        break;
                    }
                    case 0: {
                        break;
                    }
                }
            }
        }

        class SmartFocusListener
        extends FocusAdapter {
            SmartFocusListener() {
            }

            @Override
            public void focusGained(FocusEvent e) {
                Component comp = e.getComponent();
                while (comp.getParent() != MoverPanel.this) {
                    comp = comp.getParent();
                }
                MoverLayeredPane.this.pocusComponent = comp;
                MoverPanel.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        }

        class SmartContainerListener
        extends ContainerAdapter {
            SmartContainerListener() {
            }

            @Override
            public void componentAdded(ContainerEvent e) {
                MoverPanel.this.recursiveListenerAddOrRemove(true, e.getChild(), 0, e.getChild());
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                MoverPanel.this.recursiveListenerAddOrRemove(false, e.getChild(), 0, e.getChild());
            }
        }
    }

    class BorderPanel
    extends JPanel {
        private BorderComponent borderComponent;

        BorderPanel() {
            this(Color.blue);
        }

        BorderPanel(Color color) {
            super(new BorderLayout());
            this.setOpaque(false);
            this.borderComponent = new BorderComponent();
            this.borderComponent.setVisible(true);
            this.add(this.borderComponent);
        }

        private class BorderComponent
        extends JComponent {
            private MovableObjectBorder theMOB;
            private int currentCursor;
            private int repaintExtra = 20;

            BorderComponent() {
                this(Color.blue);
            }

            BorderComponent(Color color) {
                this.theMOB = new DefaultMOB(color, 7, 7, 5, Color.red, 8, 6);
                this.enableEvents(48L);
            }

            @Override
            public void paint(Graphics g) {
                this.theMOB.paintBorder(MoverLayeredPane.this.pocusComponent, g);
            }

            @Override
            public boolean contains(int x, int y) {
                return this.theMOB.isPointOverTheBorder(MoverLayeredPane.this.pocusComponent, new Point(x, y));
            }

            @Override
            protected void processMouseEvent(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    block0 : switch (e.getID()) {
                        case 500: {
                            break;
                        }
                        case 504: {
                            break;
                        }
                        case 505: {
                            break;
                        }
                        case 501: {
                            if (this.getCursor() == null) break;
                            switch (this.getCursor().getType()) {
                                case 13: {
                                    Point topLeftCorner = MoverLayeredPane.this.pocusComponent.getLocation();
                                    MoverLayeredPane.this.offsetFromTopLeftCorner = new Point(e.getPoint().x - topLeftCorner.x, e.getPoint().y - topLeftCorner.y);
                                    break block0;
                                }
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: {
                                    MoverLayeredPane.this.initialSize = MoverLayeredPane.this.pocusComponent.getBounds();
                                    break block0;
                                }
                                case 1: {
                                    MoverLayeredPane.this.dragStart = e.getPoint();
                                    break block0;
                                }
                            }
                            break;
                        }
                        case 502: {
                            this.repaint();
                            if (this.getCursor() != null) {
                                if (this.getCursor().getType() == 13) {
                                    this.moveSelectedComponent(e.getPoint());
                                    break;
                                }
                                MoverLayeredPane.this.pocusComponent = null;
                                break;
                            }
                            MoverLayeredPane.this.pocusComponent = null;
                            break;
                        }
                    }
                }
            }

            @Override
            protected void processMouseMotionEvent(MouseEvent e) {
                switch (e.getID()) {
                    case 503: {
                        int newCursor = this.theMOB.getCursor(MoverLayeredPane.this.pocusComponent, e.getPoint());
                        if (newCursor == this.currentCursor) break;
                        this.setCursor(Cursor.getPredefinedCursor(newCursor));
                        this.currentCursor = newCursor;
                        break;
                    }
                    case 506: {
                        Rectangle r = this.theMOB.getRepaintRegion(MoverLayeredPane.this.pocusComponent);
                        this.repaint(r.x - this.repaintExtra, r.y - this.repaintExtra, r.width + this.repaintExtra * 2, r.height + this.repaintExtra * 2);
                        if (this.getCursor().getType() == 13) {
                            this.moveSelectedComponent(e.getPoint());
                            break;
                        }
                        switch (this.getCursor().getType()) {
                            case 8: {
                                this.resizeVertical(e.getPoint(), true);
                                break;
                            }
                            case 11: {
                                this.resizeHorizontal(e.getPoint(), false);
                                break;
                            }
                            case 9: {
                                this.resizeVertical(e.getPoint(), false);
                                break;
                            }
                            case 10: {
                                this.resizeHorizontal(e.getPoint(), true);
                                break;
                            }
                            case 7: {
                                this.resizeVertical(e.getPoint(), true);
                                this.resizeHorizontal(e.getPoint(), false);
                                break;
                            }
                            case 6: {
                                this.resizeVertical(e.getPoint(), true);
                                this.resizeHorizontal(e.getPoint(), true);
                                break;
                            }
                            case 5: {
                                this.resizeVertical(e.getPoint(), false);
                                this.resizeHorizontal(e.getPoint(), false);
                                break;
                            }
                            case 4: {
                                this.resizeVertical(e.getPoint(), false);
                                this.resizeHorizontal(e.getPoint(), true);
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        this.validate();
                        break;
                    }
                }
            }

            private boolean isPointInWindow(Point thePoint) {
                return thePoint.x <= this.getSize().width && thePoint.x > 0 && thePoint.y <= this.getSize().height && thePoint.y > 0;
            }

            private void moveSelectedComponent(Point currentPoint) {
                Point topLeftCorner = new Point(currentPoint.x - ((MoverLayeredPane)MoverLayeredPane.this).offsetFromTopLeftCorner.x, currentPoint.y - ((MoverLayeredPane)MoverLayeredPane.this).offsetFromTopLeftCorner.y);
                int buttonLeftEdge = topLeftCorner.x;
                int buttonRightEdge = topLeftCorner.x + ((MoverLayeredPane)MoverLayeredPane.this).pocusComponent.getBounds().width;
                int buttonTopEdge = topLeftCorner.y;
                int buttonBottomEdge = topLeftCorner.y + ((MoverLayeredPane)MoverLayeredPane.this).pocusComponent.getBounds().height;
                if (buttonLeftEdge < 0) {
                    topLeftCorner.x = 0;
                } else if (buttonRightEdge >= this.getSize().width) {
                    topLeftCorner.x = this.getSize().width - ((MoverLayeredPane)MoverLayeredPane.this).pocusComponent.getBounds().width;
                }
                if (buttonTopEdge < 0) {
                    topLeftCorner.y = 0;
                } else if (buttonBottomEdge >= this.getSize().height) {
                    topLeftCorner.y = this.getSize().height - ((MoverLayeredPane)MoverLayeredPane.this).pocusComponent.getBounds().height;
                }
                MoverLayeredPane.this.pocusComponent.setLocation(topLeftCorner);
            }

            private Point mapToPointInWindow(Point currentPoint) {
                Point retval = new Point();
                retval.x = currentPoint.x > this.getSize().width ? this.getSize().width : (currentPoint.x < 0 ? 0 : currentPoint.x);
                retval.y = currentPoint.y > this.getSize().height ? this.getSize().height : (currentPoint.y < 0 ? 0 : currentPoint.y);
                return retval;
            }

            private void resizeVertical(Point currentPoint, boolean isNorthHandle) {
                Point currentWindowPoint = this.mapToPointInWindow(currentPoint);
                Point initialWindowPoint = new Point(((MoverLayeredPane)MoverLayeredPane.this).initialSize.x, ((MoverLayeredPane)MoverLayeredPane.this).initialSize.y);
                Rectangle b = MoverLayeredPane.this.pocusComponent.getBounds();
                int newHeight = isNorthHandle ? ((MoverLayeredPane)MoverLayeredPane.this).initialSize.height + initialWindowPoint.y - currentWindowPoint.y : currentWindowPoint.y - initialWindowPoint.y;
                if (newHeight >= ((MoverLayeredPane)MoverLayeredPane.this).pocusComponent.getMinimumSize().height) {
                    if (isNorthHandle) {
                        b.y = currentWindowPoint.y;
                    }
                    b.height = newHeight;
                } else {
                    if (isNorthHandle) {
                        b.y = new Point((int)initialWindowPoint.x, (int)(initialWindowPoint.y + ((MoverLayeredPane)MoverLayeredPane.this).initialSize.height - ((MoverLayeredPane)MoverLayeredPane.this).pocusComponent.getMinimumSize().height)).y;
                    }
                    b.height = ((MoverLayeredPane)MoverLayeredPane.this).pocusComponent.getMinimumSize().height;
                }
                MoverLayeredPane.this.pocusComponent.setBounds(b);
            }

            private void resizeHorizontal(Point currentPoint, boolean isWestHandle) {
                Point currentWindowPoint = this.mapToPointInWindow(currentPoint);
                Point initialWindowPoint = new Point(((MoverLayeredPane)MoverLayeredPane.this).initialSize.x, ((MoverLayeredPane)MoverLayeredPane.this).initialSize.y);
                Rectangle b = MoverLayeredPane.this.pocusComponent.getBounds();
                int newWidth = isWestHandle ? ((MoverLayeredPane)MoverLayeredPane.this).initialSize.width + initialWindowPoint.x - currentWindowPoint.x : currentWindowPoint.x - initialWindowPoint.x;
                if (newWidth >= ((MoverLayeredPane)MoverLayeredPane.this).pocusComponent.getMinimumSize().width) {
                    if (isWestHandle) {
                        b.x = currentWindowPoint.x;
                    }
                    b.width = newWidth;
                } else {
                    if (isWestHandle) {
                        b.x = new Point((int)(initialWindowPoint.x + ((MoverLayeredPane)MoverLayeredPane.this).initialSize.width - ((MoverLayeredPane)MoverLayeredPane.this).pocusComponent.getMinimumSize().width), (int)initialWindowPoint.y).x;
                    }
                    b.width = ((MoverLayeredPane)MoverLayeredPane.this).pocusComponent.getMinimumSize().width;
                }
                MoverLayeredPane.this.pocusComponent.setBounds(b);
            }
        }
    }

    protected class MLPLayout
    implements LayoutManager {
        protected MLPLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getSize();
        }

        public Dimension maximumLayoutSize(Container target) {
            return target.getSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            MoverLayeredPane.this.contentPanel.setSize(parent.getSize());
            MoverLayeredPane.this.contentPanel.setLocation(0, 0);
            MoverLayeredPane.this.borderPanel.setSize(parent.getSize());
            MoverLayeredPane.this.borderPanel.setLocation(0, 0);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    public static interface CursorStates {
        public static final int OBJECT_SELECTION = 0;
        public static final int OBJECT_CREATION = 1;
    }
}

