/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.moverlayeredpane;

import jas2.plot.EditableLabel;
import jas2.util.moverlayeredpane.MLPObjectFactory;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class MLPLabelFactory
implements MLPObjectFactory {
    private int labelBorderDrawState;
    private EditableLabel tempLabel;
    private Point dragStart;

    @Override
    public void mousePressed(MouseEvent e, JPanel p) {
        this.dragStart = e.getPoint();
        this.tempLabel = new EditableLabel("Click here to enter some text.", "");
        switch (this.labelBorderDrawState) {
            case 0: {
                break;
            }
            case 1: {
                this.tempLabel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
                break;
            }
            case 2: {
                this.tempLabel.setBorder(BorderFactory.createLineBorder(Color.black, 5));
                break;
            }
        }
        this.tempLabel.setLocation(this.dragStart);
        this.tempLabel.setVisible(true);
        this.tempLabel.setRequestFocusEnabled(true);
        p.add(this.tempLabel);
    }

    @Override
    public void mouseDragged(MouseEvent e, JPanel p) {
        Point end = e.getPoint();
        if (end.x > this.dragStart.x && end.y > this.dragStart.y) {
            this.tempLabel.setSize(end.x - this.dragStart.x, end.y - this.dragStart.y);
        }
        p.validate();
    }

    @Override
    public void mouseReleased(MouseEvent e, JPanel p) {
        p.repaint();
    }

    public int getLabelBorderDrawState() {
        return this.labelBorderDrawState;
    }

    public void setLabelBorderDrawState(int newState) {
        this.labelBorderDrawState = newState;
    }

    public static interface LabelBorderDrawStates {
        public static final int NONE = 0;
        public static final int THIN = 1;
        public static final int THICK = 2;
    }
}

