/*
 * Decompiled with CFR 0.152.
 */
package jas2.util;

import jas2.util.JASDialog;
import jas2.util.JASState;
import jas2.util.PropertyPage;
import jas2.util.PropertySite;
import java.awt.Frame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PropertyDialog
extends JASDialog
implements PropertySite,
ChangeListener {
    private Object m_bean;
    private JTabbedPane m_tab_manager = new JTabbedPane();
    private PropertyPage m_currentPage;
    private boolean m_suppressChangeEvents = false;

    protected PropertyDialog(Frame f, String title, Object bean) {
        super(f, title, true, 15);
        this.m_tab_manager.addChangeListener(this);
        this.setContentPane(this.m_tab_manager);
        this.m_currentPage = null;
        this.m_bean = bean;
    }

    protected void addPage(String name, PropertyPage p, boolean select) {
        this.m_tab_manager.addTab(name, p);
        p.setPropertySite(this);
        if (select) {
            this.m_tab_manager.setSelectedComponent(p);
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        if (this.m_suppressChangeEvents) {
            return;
        }
        if (this.m_currentPage == null || this.m_currentPage.hasValidInput()) {
            this.doDataExchange(true);
            if (this.m_currentPage != null) {
                this.m_currentPage.deactivate();
            }
            this.m_currentPage = (PropertyPage)this.m_tab_manager.getSelectedComponent();
            this.m_currentPage.activate();
            this.doDataExchange(false);
            this.setHelpTopic(this.m_currentPage.getHelpTopic());
            super.callEnable();
        } else {
            this.m_suppressChangeEvents = true;
            this.m_tab_manager.setSelectedComponent(this.m_currentPage);
            this.m_suppressChangeEvents = false;
        }
    }

    private void doDataExchange(boolean set) {
        if (this.m_currentPage != null) {
            this.m_currentPage.doDataExchange(set, this.m_bean);
        }
    }

    @Override
    public void enableApply(JASState state) {
        state.setEnabled(this.m_currentPage.hasChanged());
    }

    @Override
    public void callEnable() {
        super.callEnable();
    }

    @Override
    public void onApply() {
        if (this.m_currentPage.hasValidInput()) {
            this.doDataExchange(true);
            this.doDataExchange(false);
            super.onApply();
            super.callEnable();
        }
    }

    @Override
    public void onOK() {
        if (this.m_currentPage.hasValidInput()) {
            this.doDataExchange(true);
            this.m_currentPage.deactivate();
            super.onOK();
        }
    }

    @Override
    public void onCancel() {
        this.m_currentPage.deactivate();
        super.onCancel();
    }
}

