/*
 * Decompiled with CFR 0.152.
 */
package jas2.util;

import jas2.util.HasNestedException;
import jas2.util.NestedException;
import java.io.PrintStream;
import java.io.PrintWriter;

public class NestedRuntimeException
extends RuntimeException
implements HasNestedException {
    private Throwable detail;

    public NestedRuntimeException(Throwable ex) {
        this.detail = ex;
    }

    public NestedRuntimeException(String s, Throwable ex) {
        super(s);
        this.detail = ex;
    }

    @Override
    public Throwable getNestedException() {
        return this.detail;
    }

    @Override
    public String getMessage() {
        return NestedException.formatNestedException(this);
    }

    @Override
    public String getSimpleMessage() {
        return super.getMessage();
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        if (this.detail != null) {
            System.err.println("Nested Exception is:");
            this.detail.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.detail != null) {
            s.println("Nested Exception is:");
            this.detail.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.detail != null) {
            s.println("Nested Exception is:");
            this.detail.printStackTrace(s);
        }
    }
}

