/*
 * Decompiled with CFR 0.152.
 */
package jas2.util;

import jas2.util.Application;
import jas2.util.JASState;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JASDialog
extends JDialog
implements MouseListener,
DocumentListener {
    public static final int OK_BUTTON = 1;
    public static final int APPLY_BUTTON = 2;
    public static final int CANCEL_BUTTON = 4;
    public static final int HELP_BUTTON = 8;
    private Application app = Application.getApplication();
    private String m_helpTopic = null;
    private int m_flags;
    private JPanel m_buttonPanel;
    private JButton m_ok;
    private JButton m_cancel;
    private JButton m_apply;
    private JButton m_help;
    private boolean m_result;
    private Window m_window;
    private Container m_contentPane;

    public static JASDialog create(Frame frame, String title) {
        return JASDialog.create(frame, title, true, 5);
    }

    public static JASDialog create(Frame frame, String title, boolean modal) {
        return JASDialog.create(frame, title, modal, 5);
    }

    public static JASDialog create(Component c, String t, boolean modal, int flags) {
        Window w = (Window)SwingUtilities.getAncestorOfClass(Window.class, c);
        if (w instanceof Frame) {
            return new JASDialog((Frame)w, t, modal, flags);
        }
        if (w instanceof Dialog) {
            return new JASDialog((Dialog)w, t, modal, flags);
        }
        throw new RuntimeException("No dialog parent found");
    }

    public JASDialog(Frame frame, String title) {
        this(frame, title, true, 5);
    }

    public JASDialog(Frame frame, String title, boolean modal) {
        this(frame, title, modal, 5);
    }

    public JASDialog(Frame f, String t, boolean modal, int flags) {
        super(f, t, modal);
        this.init(f, flags);
    }

    public JASDialog(Dialog dlg, String title) {
        this(dlg, title, true, 5);
    }

    public JASDialog(Dialog dlg, String title, boolean modal) {
        this(dlg, title, modal, 5);
    }

    public JASDialog(Dialog dlg, String t, boolean modal, int flags) {
        super(dlg, t, modal);
        this.init(dlg, flags);
    }

    private void init(Window w, int flags) {
        this.m_window = w;
        this.m_flags = flags;
        ActionEventHandler l = new ActionEventHandler();
        this.m_ok = new JButton("OK");
        this.m_ok.addActionListener(l);
        this.m_ok.setMnemonic('O');
        this.m_apply = new JButton("Apply");
        this.m_apply.setMnemonic('A');
        this.m_apply.addActionListener(l);
        this.m_cancel = new JButton("Cancel");
        this.m_cancel.setMnemonic('C');
        this.m_cancel.addActionListener(l);
        this.m_help = new JButton("Help");
        this.m_help.setMnemonic('H');
        this.m_help.addActionListener(l);
        this.m_buttonPanel = new JPanel();
        super.getContentPane().add((Component)this.m_buttonPanel, "South");
        this.enableEvents(64L);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        super.getContentPane().add((Component)p, "Center");
        this.m_contentPane = p;
    }

    @Override
    public void pack() {
        this.defaultPack();
        this.setLocationRelativeTo(this.m_window);
    }

    public void defaultPack() {
        if (this.m_buttonPanel.getComponentCount() == 0) {
            if ((this.m_flags & 1) != 0) {
                this.m_buttonPanel.add(this.m_ok);
            }
            if ((this.m_flags & 2) != 0) {
                this.m_buttonPanel.add(this.m_apply);
            }
            if ((this.m_flags & 4) != 0) {
                this.m_buttonPanel.add(this.m_cancel);
            }
            if ((this.m_flags & 8) != 0) {
                this.m_buttonPanel.add(this.m_help);
            }
        }
        super.pack();
    }

    @Override
    public void processEvent(AWTEvent e) {
        if (e.getID() == 201) {
            this.onCancel();
        }
        super.processEvent(e);
    }

    public boolean doModal() {
        this.m_result = false;
        this.setModal(true);
        this.show();
        return this.m_result;
    }

    @Override
    public void show() {
        this.callEnable();
        if (this.isModal() && this.app != null) {
            this.app.modalDialogOpening(this);
        }
        super.show();
        if (this.isModal() && this.app != null) {
            this.app.modalDialogClosing(this);
        }
    }

    public void setOKLabel(String label) {
        this.m_ok.setText(label);
    }

    public void setOKMnemonic(char mnemonic) {
        this.m_ok.setMnemonic(mnemonic);
    }

    public void setCancelLabel(String label) {
        this.m_cancel.setText(label);
    }

    public void setCancelMnemonic(char mnemonic) {
        this.m_cancel.setMnemonic(mnemonic);
    }

    public void setApplyLabel(String label) {
        this.m_apply.setText(label);
    }

    public void setApplyMnemonic(char mnemonic) {
        this.m_apply.setMnemonic(mnemonic);
    }

    protected void onOK() {
        this.m_result = true;
        this.dispose();
    }

    protected void onCancel() {
        this.dispose();
    }

    protected void onApply() {
    }

    protected void callEnable() {
        if (this.m_ok != null) {
            this.enableOK(new ButtonState(this.m_ok));
            this.getRootPane().setDefaultButton(this.m_ok);
        }
        if (this.m_apply != null) {
            this.enableApply(new ButtonState(this.m_apply));
        }
        if (this.m_help != null) {
            this.enableHelp(new ButtonState(this.m_help));
        }
    }

    protected void enableOK(JASState state) {
    }

    protected void enableHelp(JASState state) {
        state.setEnabled(this.m_helpTopic != null);
    }

    protected void enableApply(JASState state) {
        state.setEnabled(false);
    }

    @Override
    public Container getContentPane() {
        return this.m_contentPane;
    }

    @Override
    public void setContentPane(Container c) {
        this.m_contentPane = c;
        super.getContentPane().add((Component)this.m_contentPane, "Center");
    }

    public final void setHelpTopic(String topic) {
        this.m_flags |= 8;
        this.m_helpTopic = topic;
    }

    private void onHelp() {
        Application.getApplication().showHelpTopic(this.m_helpTopic, this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.callEnable();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.callEnable();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.callEnable();
    }

    private class ButtonState
    implements JASState {
        private JButton m_button;

        ButtonState(JButton b) {
            this.m_button = b;
        }

        @Override
        public void setEnabled(boolean state) {
            this.m_button.setEnabled(state);
        }
    }

    private class ActionEventHandler
    implements ActionListener {
        private ActionEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == JASDialog.this.m_ok) {
                JASDialog.this.onOK();
            } else if (source == JASDialog.this.m_apply) {
                JASDialog.this.onApply();
            } else if (source == JASDialog.this.m_cancel) {
                JASDialog.this.onCancel();
            } else if (source == JASDialog.this.m_help) {
                JASDialog.this.onHelp();
            }
        }
    }
}

