/*
 * Decompiled with CFR 0.152.
 */
package jas2.util;

import jas2.util.PreviewReader;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class FilePreview
extends JDialog {
    FilePreview(Frame frame, File f, boolean gzip) throws IOException, FileNotFoundException {
        super(frame, "File preview");
        int maxWidth;
        JTextArea text = new JTextArea();
        if (!gzip) {
            text.read(new PreviewReader(new FileReader(f)), f);
        } else {
            text.read(new PreviewReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(f)))), f);
        }
        text.setEditable(false);
        JScrollPane pane = new JScrollPane(text);
        this.setContentPane(pane);
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dialogSize = this.getPreferredSize();
        int maxHeight = (int)((double)screenSize.height * 0.6);
        if (dialogSize.height > maxHeight) {
            dialogSize.height = maxHeight;
        }
        dialogSize.width = dialogSize.width > (maxWidth = (int)((double)screenSize.width * 0.9)) ? maxWidth : (dialogSize.width += 50);
        Point position = this.getLocation();
        position.translate((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        this.setLocation(position);
        this.setSize(dialogSize);
        this.show();
    }
}

