/*
 * Decompiled with CFR 0.152.
 */
package jas2.util;

import jas2.util.Application;
import jas2.util.ColorEvent;
import jas2.util.ColorListener;
import jas2.util.UserProperties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JColorChooser;

public class ColorChooser
extends JButton {
    private UserProperties m_prop;
    private String m_key;
    private Color m_color;
    private Vector m_listeners = new Vector();

    public ColorChooser() {
        this(Color.black);
    }

    public ColorChooser(Color c) {
        this.setColor(c);
        this.setOpaque(true);
    }

    public ColorChooser(String key) {
        this.m_prop = Application.getApplication().getUserProperties();
        this.m_key = key;
        this.setOpaque(true);
        this.setColor(this.m_prop.getColor(key, Color.black));
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(20, 20);
    }

    public void setColor(Color c) {
        this.m_color = c;
        this.setBackground(c);
        this.repaint();
        Enumeration e = this.m_listeners.elements();
        while (e.hasMoreElements()) {
            ColorListener l = (ColorListener)e.nextElement();
            l.colorChanged(new ColorEvent((Object)this, c));
        }
    }

    public Color getColor() {
        return this.m_color;
    }

    public void addColorListener(ColorListener l) {
        this.m_listeners.addElement(l);
    }

    public void removeColorListener(ColorListener l) {
        this.m_listeners.removeElement(l);
    }

    @Override
    protected void fireActionPerformed(ActionEvent e) {
        Color c = JColorChooser.showDialog(this, "Choose color...", this.m_color);
        if (c != null) {
            this.setColor(c);
            if (this.m_key != null) {
                this.m_prop.setColor(this.m_key, c);
            }
        }
    }
}

