/*
 * Decompiled with CFR 0.152.
 */
package jas2.tuple;

import jas2.hist.JASHist;
import jas2.hist.Rebinnable1DHistogramData;
import jas2.tuple.Cut;
import jas2.tuple.TuplePanel;
import jas2.util.JASIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

class CutPanel
extends JPanel {
    private Cut cut;
    private MinSliderModel model1 = new MinSliderModel();
    private MaxSliderModel model2 = new MaxSliderModel();
    private boolean locked = false;
    private double delta;
    private double Xmin;
    private double Xmax;
    private TuplePanel control;
    private JTextField label1;
    private JTextField label2;

    CutPanel(final Cut cut, final TuplePanel control) {
        super(new BorderLayout());
        this.cut = cut;
        this.control = control;
        JPanel top = new JPanel();
        top.add(new JLabel("Cut: " + cut.getName()));
        final JComboBox<String> type = new JComboBox<String>(Cut.getTypes());
        type.setSelectedIndex(cut.getType());
        top.add(type);
        this.add((Component)top, "North");
        type.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cut.setType(type.getSelectedIndex());
                control.go();
            }
        });
        JASHist plot = new JASHist();
        Rebinnable1DHistogramData source = cut.getColumn().getDataSource();
        this.Xmin = source.getMin();
        this.Xmax = source.getMax();
        plot.addData(source).show(true);
        plot.setPreferredSize(new Dimension(200, 200));
        plot.setTitle(source.getTitle());
        this.add((Component)plot, "Center");
        JSlider slider1 = new JSlider(this.model1);
        JSlider slider2 = new JSlider(this.model2);
        JPanel sp1 = new JPanel(new BorderLayout());
        JPanel sp2 = new JPanel(new BorderLayout());
        this.label1 = new JTextField(String.valueOf(cut.value1), 6);
        this.label2 = new JTextField(String.valueOf(cut.value2), 6);
        sp1.add((Component)slider1, "Center");
        sp2.add((Component)slider2, "Center");
        sp1.add((Component)this.label1, "East");
        sp2.add((Component)this.label2, "East");
        JPanel sliders = new JPanel(new BorderLayout());
        sliders.add((Component)sp1, "North");
        sliders.add((Component)sp2, "South");
        JPanel bottom = new JPanel();
        final JToggleButton lock = new JToggleButton();
        lock.setSelectedIcon(JASIcon.create(this, "lock.gif"));
        lock.setIcon(JASIcon.create(this, "unlock.gif"));
        lock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CutPanel.this.locked = lock.isSelected();
                CutPanel.this.delta = cut.value2 - cut.value1;
            }
        });
        bottom.add(lock);
        bottom.add(sliders);
        this.add((Component)bottom, "South");
    }

    class MaxSliderModel
    extends DefaultBoundedRangeModel {
        MaxSliderModel() {
            super(0, 0, 0, 1000);
        }

        @Override
        public int getValue() {
            return (int)(1000.0 * (((CutPanel)CutPanel.this).cut.value2 - CutPanel.this.Xmin) / (CutPanel.this.Xmax - CutPanel.this.Xmin));
        }

        @Override
        public void setValue(int newValue) {
            this.setValue(CutPanel.this.Xmin + (double)newValue / 1000.0 * (CutPanel.this.Xmax - CutPanel.this.Xmin));
            CutPanel.this.control.go();
        }

        void setValue(double newValue) {
            if (newValue == ((CutPanel)CutPanel.this).cut.value2) {
                return;
            }
            ((CutPanel)CutPanel.this).cut.value2 = newValue;
            if (CutPanel.this.locked) {
                CutPanel.this.model1.setValue(Math.max(CutPanel.this.Xmin, ((CutPanel)CutPanel.this).cut.value2 - CutPanel.this.delta));
            } else if (((CutPanel)CutPanel.this).cut.value1 > ((CutPanel)CutPanel.this).cut.value2) {
                CutPanel.this.model1.setValue(((CutPanel)CutPanel.this).cut.value2);
            }
            String s = String.valueOf(((CutPanel)CutPanel.this).cut.value2);
            s = s.substring(0, Math.min(6, s.length()));
            CutPanel.this.label2.setText(s);
            this.fireStateChanged();
        }
    }

    class MinSliderModel
    extends DefaultBoundedRangeModel {
        MinSliderModel() {
            super(0, 0, 0, 1000);
        }

        @Override
        public int getValue() {
            return (int)(1000.0 * (((CutPanel)CutPanel.this).cut.value1 - CutPanel.this.Xmin) / (CutPanel.this.Xmax - CutPanel.this.Xmin));
        }

        @Override
        public void setValue(int newValue) {
            this.setValue(CutPanel.this.Xmin + (double)newValue / 1000.0 * (CutPanel.this.Xmax - CutPanel.this.Xmin));
            CutPanel.this.control.go();
        }

        void setValue(double newValue) {
            if (newValue == ((CutPanel)CutPanel.this).cut.value1) {
                return;
            }
            ((CutPanel)CutPanel.this).cut.value1 = newValue;
            if (CutPanel.this.locked) {
                CutPanel.this.model2.setValue(Math.min(CutPanel.this.Xmax, ((CutPanel)CutPanel.this).cut.value1 + CutPanel.this.delta));
            } else if (((CutPanel)CutPanel.this).cut.value1 > ((CutPanel)CutPanel.this).cut.value2) {
                CutPanel.this.model2.setValue(((CutPanel)CutPanel.this).cut.value1);
            }
            String s = String.valueOf(((CutPanel)CutPanel.this).cut.value1);
            s = s.substring(0, Math.min(6, s.length()));
            CutPanel.this.label1.setText(s);
            this.fireStateChanged();
        }
    }
}

