/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio.adaptor;

import hepjas.analysis.NamedObject;
import jas2.hist.DataSource;
import jas2.hist.JASHist;
import jas2.hist.Rebinnable1DHistogramData;
import jas2.hist.Rebinnable2DHistogramData;
import jas2.job.HistogramAccess;
import jas2.swingstudio.JASPage;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.TreeAdaptor;
import jas2.swingstudio.adaptor.OneDTreeData;
import jas2.swingstudio.adaptor.ScatterTreeData;
import jas2.util.JASCheckboxMenuItem;
import jas2.util.JASCheckboxState;
import jas2.util.JASMenuItem;
import jas2.util.JASState;
import jas2.util.OnScreenPopupMenu;
import javax.swing.JPopupMenu;

public class HistogramAccessTreeAdaptor
extends TreeAdaptor {
    private static JPopupMenu menu;
    private HistogramAccess m_hist = null;
    private DataSource m_data;

    @Override
    protected void init() {
        this.m_hist = (HistogramAccess)this.getAssociatedObject();
        this.reset();
    }

    @Override
    protected void updateNode(int flags) {
        if ((flags & 0x80000) != 0) {
            if (JavaAnalysisStudio.getApp().getCurrentPage() != null) {
                this.onShowInNewPlot();
            } else {
                this.onShowOnNewPage();
            }
        }
        if ((flags & 0x100000) != 0) {
            this.reset();
        }
    }

    private void reset() {
        DataSource ds = this.m_hist.getData();
        if (ds instanceof Rebinnable1DHistogramData) {
            this.m_data = new OneDTreeData(this.getTreeItem(), (Rebinnable1DHistogramData)ds);
        } else if (ds instanceof Rebinnable2DHistogramData) {
            this.m_data = new ScatterTreeData(this.getTreeItem(), (Rebinnable2DHistogramData)ds);
        }
    }

    public void onShowInNewPlot() {
        JASPage page = JavaAnalysisStudio.getApp().getCurrentPage();
        page.addPlot();
        JASHist plot = page.getCurrentPlot();
        plot.addData(this.m_data).show(true);
        JASPage.calculateTitlesAndLabels(plot);
        page.currentPlotUpdated();
    }

    public void enableShowInNewPlot(JASState state) {
        state.setEnabled(this.m_data != null && JavaAnalysisStudio.getApp().getCurrentPage() != null);
    }

    public void onShowOnNewPage() {
        JASPage page = JavaAnalysisStudio.getApp().createNewPage();
        JASHist plot = page.getCurrentPlot();
        plot.addData(this.m_data).show(true);
        JASPage.calculateTitlesAndLabels(plot);
        page.currentPlotUpdated();
    }

    public void enableShowOnNewPage(JASState state) {
        state.setEnabled(this.m_data != null);
    }

    public void onShow() {
        JASPage page = JavaAnalysisStudio.getApp().createCurrentPage();
        if (page != null) {
            JASHist plot = page.getCurrentPlot();
            plot.removeAllData();
            plot.addData(this.m_data).show(true);
            JASPage.calculateTitlesAndLabels(plot);
            page.currentPlotUpdated();
        }
    }

    public void enableShow(JASState state) {
        state.setEnabled(this.m_data != null);
    }

    public void onOverlay() {
        JASPage page = JavaAnalysisStudio.getApp().getCurrentPage();
        JASHist plot = page.getCurrentPlot();
        plot.addData(this.m_data).show(true);
        JASPage.calculateTitlesAndLabels(plot);
        page.currentPlotUpdated();
    }

    public void enableOverlay(JASState state) {
        JASPage page = JavaAnalysisStudio.getApp().getCurrentPage();
        if (page != null && this.m_data != null) {
            JASHist plot = page.getCurrentPlot();
            state.setEnabled(plot.getNumberOfDataSources() > 0);
        } else {
            state.setEnabled(false);
        }
    }

    public void onDelete() {
        this.m_hist.delete();
    }

    public void onRename() {
        this.startEditing();
    }

    @Override
    public boolean stopEditing(String newName) {
        try {
            this.m_hist.rename(newName);
            return true;
        }
        catch (NamedObject.RenameException x) {
            JavaAnalysisStudio.getApp().error("Illegal name", x);
            return false;
        }
    }

    public void enableClearOnRewind(JASCheckboxState state) {
        state.setEnabled(this.m_hist.canSetClearOnRewind());
        state.setCheckbox(this.m_hist.isClearOnRewind());
    }

    public void onClearOnRewind(boolean value) {
        this.m_hist.setClearOnRewind(value);
    }

    public void onClear() {
        this.m_hist.clear();
    }

    public void onDoubleClick() {
        if (this.m_data != null) {
            this.onShow();
        }
    }

    public void onSelect() {
        JavaAnalysisStudio.getApp().setMessage(this.m_hist.getDescription());
    }

    @Override
    protected boolean isEditable() {
        return true;
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        if (menu == null) {
            menu = new OnScreenPopupMenu();
            menu.add(new JASMenuItem("Show", 'S'));
            menu.add(new JASMenuItem("Overlay", 'O'));
            menu.add(new JASMenuItem("Show In New Plot", 'P'));
            menu.add(new JASMenuItem("Show On New Page", 'N'));
            menu.add(new JASMenuItem("Clear", 'C'));
            menu.add(new JASCheckboxMenuItem("Clear On Rewind", 'W'));
            menu.add(new JASMenuItem("Rename", 'R'));
            menu.add(new JASMenuItem("Delete", 'D'));
        }
        return menu;
    }
}

