/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio.adaptor;

import jas2.swingstudio.TreeAdaptor;
import jas2.util.OnScreenPopupMenu;
import jas2.util.tree.OrderedNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class FolderTreeAdaptor
extends TreeAdaptor
implements ActionListener {
    private Object folder;
    private JRadioButtonMenuItem b1;
    private JRadioButtonMenuItem b2;
    private JRadioButtonMenuItem b3;
    private JCheckBoxMenuItem b4;

    @Override
    public void init() {
        this.folder = this.getAssociatedObject();
    }

    public void onSelect() {
        if (this.folder != null) {
            this.getPluginContext().sendMessage(this.folder.toString());
        }
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        OrderedNode node = (OrderedNode)((Object)this.getAdaptorSite());
        FolderComparator comp = (FolderComparator)node.getOrder();
        OnScreenPopupMenu popup = new OnScreenPopupMenu();
        JMenu sort = new JMenu("Sort");
        this.b1 = new JRadioButtonMenuItem("As Parent Folder", comp == null);
        this.b2 = new JRadioButtonMenuItem("By Creation Time", comp != null && !comp.alphabetical());
        this.b3 = new JRadioButtonMenuItem("Alphabetically", comp != null && comp.alphabetical());
        this.b4 = new JCheckBoxMenuItem("Folders First", comp != null && comp.foldersFirst());
        ButtonGroup b = new ButtonGroup();
        b.add(this.b1);
        b.add(this.b2);
        b.add(this.b3);
        this.b1.addActionListener(this);
        this.b2.addActionListener(this);
        this.b3.addActionListener(this);
        this.b4.addActionListener(this);
        sort.add(this.b1);
        sort.add(this.b2);
        sort.add(this.b3);
        sort.add(this.b4);
        popup.add(sort);
        return popup;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        OrderedNode node = (OrderedNode)((Object)this.getAdaptorSite());
        Object source = e.getSource();
        boolean foldersFirst = this.b4.isSelected();
        if (source == this.b1) {
            node.clearOrder();
        } else {
            node.setOrder(new FolderComparator(this.b3.isSelected(), foldersFirst));
        }
    }

    private static class FolderComparator
    implements Comparator {
        private boolean foldersFirst;
        private boolean alphabetical;

        FolderComparator(boolean alphabetical, boolean foldersFirst) {
            this.foldersFirst = foldersFirst;
            this.alphabetical = alphabetical;
        }

        public int compare(Object p1, Object p2) {
            OrderedNode n1 = (OrderedNode)p1;
            OrderedNode n2 = (OrderedNode)p2;
            if (this.foldersFirst) {
                boolean f2;
                boolean f1 = (n1.getFlags() & 4) != 0;
                boolean bl = f2 = (n2.getFlags() & 4) != 0;
                if (f1 && !f2) {
                    return -1;
                }
                if (!f1 && f2) {
                    return 1;
                }
            }
            if (this.alphabetical) {
                return n1.getName().compareTo(n2.getName());
            }
            return n1.getNaturalIndex() - n2.getNaturalIndex();
        }

        boolean alphabetical() {
            return this.alphabetical;
        }

        boolean foldersFirst() {
            return this.foldersFirst;
        }
    }
}

