/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.util.tree.TreeItem;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

class TreeItemTreeNode
implements TreeNode {
    private Vector children;
    private TreeItemTreeNode parent;
    private String name;
    private String type;
    private int flags;

    TreeItemTreeNode(TreeItem[] items) {
        this.name = "root";
        this.parent = null;
        this.type = null;
        this.flags = 0;
        for (int i = 0; i < items.length; ++i) {
            this.addNode(items[i]);
        }
    }

    private TreeItemTreeNode(TreeItemTreeNode parent, String name, String type, int flags) {
        this.parent = parent;
        this.name = name;
        this.type = type;
        this.flags = flags;
        parent.addChild(this);
    }

    void addNodes(TreeItem[] items) {
        for (int i = 0; i < items.length; ++i) {
            this.addNode(items[i]);
        }
    }

    private void addNode(TreeItem item) {
        TreeItemTreeNode parent = this;
        int l = item.path.length;
        for (int i = 0; i < l; ++i) {
            String element = item.path[i];
            TreeItemTreeNode child = parent.findChild(element);
            parent = child == null ? new TreeItemTreeNode(parent, element, i == l - 1 ? item.type : "folder", item.flags) : child;
        }
    }

    private void addChild(TreeNode child) {
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.addElement(child);
    }

    private TreeItemTreeNode findChild(String name) {
        if (this.children == null) {
            return null;
        }
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            TreeItemTreeNode child = (TreeItemTreeNode)e.nextElement();
            if (!child.name.equals(name)) continue;
            return child;
        }
        return null;
    }

    TreeItem getTreeItem() {
        TreeItemTreeNode node = this;
        int depth = -1;
        while (node != null) {
            ++depth;
            node = node.parent;
        }
        TreeItem item = new TreeItem();
        item.type = this.type;
        item.path = new String[depth];
        node = this;
        int i = depth;
        while (i > 0) {
            item.path[--i] = node.name;
            node = node.parent;
        }
        return item;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.children.elementAt(childIndex);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public boolean isLeaf() {
        return this.children == null && (this.flags & 1) == 0;
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    public Enumeration children() {
        return this.children.elements();
    }

    public String toString() {
        return this.name;
    }
}

