/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.swingstudio.JavaAnalysisStudio;
import jas2.util.UserProperties;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public abstract class RecentItemsMenu
extends JMenu
implements ActionListener {
    private final UserProperties m_prop = JavaAnalysisStudio.getApp().getUserProperties();
    private final String m_lengthKey;
    private String[] m_lastItems;
    private boolean m_build = true;

    public RecentItemsMenu(String lengthKey) {
        this.m_lengthKey = lengthKey;
    }

    public final void setEnabled(String[] lastItems) {
        this.m_lastItems = lastItems;
        this.m_build = lastItems != null && lastItems.length > 0;
        this.setEnabled(this.m_build);
    }

    @Override
    protected final void fireMenuSelected() {
        if (this.m_build) {
            this.removeAll();
            int i = 0;
            int n = Math.min(this.m_prop.getInteger(this.m_lengthKey, 4), this.m_lastItems.length);
            while (i < n) {
                AbstractMenuItem item = new AbstractMenuItem(this.toDisplayFormat(this.m_lastItems[i]), ++i);
                item.addActionListener(this);
                this.add(item);
            }
            this.m_build = false;
        }
        super.fireMenuSelected();
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o instanceof AbstractMenuItem) {
            AbstractMenuItem item = (AbstractMenuItem)o;
            this.itemSelected(item.name);
        }
    }

    protected abstract String toDisplayFormat(String var1);

    protected abstract void itemSelected(String var1);

    private class AbstractMenuItem
    extends JMenuItem {
        String name;

        AbstractMenuItem(String name, int i) {
            super(String.valueOf(i) + " " + name);
            this.name = name;
            this.setMnemonic(48 + (char)i);
        }
    }
}

