/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.LoadDialog;
import jas2.swingstudio.SwingStudioIcon;
import jas2.util.JASMenuItem;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public final class ProgramPagePopupMenu
extends JPopupMenu {
    private String m_className = null;
    private LoadMenuItem m_load = new LoadMenuItem();

    ProgramPagePopupMenu() {
        this.add("Cut", 'X', "images/Cut.gif");
        this.add("Copy", 'C', "images/Copy.gif");
        this.add("Paste", 'V', "images/Paste.gif");
        this.addSeparator();
        this.add("Save", 'S', "images/Save.gif");
        this.add("Save As", 'A', null);
        this.add("Compile", 'M', "images/Compile.gif");
        this.add(this.m_load);
        this.add("Print...", 'P', "images/Print.gif");
        this.add("Go To Line...", 'G', null);
        this.addSeparator();
        this.add("Options...", 'O', null);
    }

    public void add(String s, char mnemonic, String theImage) {
        JASMenuItem i = new JASMenuItem(s, mnemonic);
        if (theImage != null) {
            SwingStudioIcon theIcon = new SwingStudioIcon();
            theIcon.setImage(theImage);
            i.setIcon(theIcon);
        }
        super.add(i);
    }

    void willBecomeVisible(String className, boolean enableLoad) {
        this.m_className = className;
        super.firePopupMenuWillBecomeVisible();
        this.m_load.setEnabled(enableLoad);
    }

    private class LoadMenuItem
    extends JMenuItem {
        LoadMenuItem() {
            super("Load");
            this.setMnemonic('L');
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            super.fireActionPerformed(e);
            JavaAnalysisStudio.getApp().getJob().loadClass(ProgramPagePopupMenu.this.m_className);
            LoadDialog.updateListWithClass(ProgramPagePopupMenu.this.m_className);
        }
    }
}

