/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.job.OpenJobException;
import jas2.swingstudio.JASJobAdaptor;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.TreeItemTreeNode;
import jas2.util.Finishable;
import jas2.util.HasHelpPage;
import jas2.util.JASWizardPage;
import jas2.util.tree.TreeItem;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

class OpenDataSetPage
extends JASWizardPage
implements TreeSelectionListener,
Finishable,
HasHelpPage {
    private JASJobAdaptor m_job;
    private JavaAnalysisStudio m_app;
    private JTree m_tree;
    private JScrollPane m_scrollPane = new JScrollPane();

    OpenDataSetPage() {
        super(new BorderLayout());
        this.m_scrollPane.setPreferredSize(new Dimension(300, 150));
        this.add("North", new JLabel("Select a data set to open:"));
        this.add("Center", this.m_scrollPane);
    }

    OpenDataSetPage(JASJobAdaptor job, JavaAnalysisStudio app) {
        this();
        this.setJob(job, app);
    }

    void setJob(JASJobAdaptor job, JavaAnalysisStudio app) {
        this.m_job = job;
        this.m_app = app;
    }

    @Override
    public void onFinish() {
        try {
            TreePath path = this.m_tree.getSelectionPath();
            TreeItemTreeNode node = (TreeItemTreeNode)path.getLastPathComponent();
            this.m_job.openDataSource(node.getTreeItem());
            this.dispose();
        }
        catch (OpenJobException e) {
            this.m_app.closeCurrentJob();
            this.m_app.setToEmptyJob();
            this.dispose();
            this.m_app.error("Could not open job", e);
        }
    }

    @Override
    public void beforeShowing() {
        this.m_tree = new JTree(new TreeItemTreeNode(this.m_job.listDataSources()), true);
        this.m_tree.setRootVisible(false);
        this.m_tree.addTreeSelectionListener(this);
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JButton b;
                    TreePath path = OpenDataSetPage.this.m_tree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    TreeItemTreeNode node = (TreeItemTreeNode)path.getLastPathComponent();
                    if (node.isLeaf() && (b = OpenDataSetPage.this.getRootPane().getDefaultButton()) != null) {
                        b.doClick();
                    }
                }
            }
        });
        this.m_tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                final TreeItemTreeNode node = (TreeItemTreeNode)path.getLastPathComponent();
                if (!node.isLeaf() && node.getChildCount() == 0) {
                    OpenDataSetPage.this.doBusy(new Runnable(){

                        @Override
                        public void run() {
                            TreeItem item = node.getTreeItem();
                            TreeItem[] subItems = OpenDataSetPage.this.m_job.getSubItems(item);
                            node.addNodes(subItems);
                            ((DefaultTreeModel)OpenDataSetPage.this.m_tree.getModel()).nodeStructureChanged(node);
                        }
                    });
                }
            }
        });
        this.m_scrollPane.setViewportView(this.m_tree);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.doEnable();
    }

    @Override
    protected boolean getFinishEnabled() {
        if (this.m_tree == null) {
            return false;
        }
        TreePath path = this.m_tree.getSelectionPath();
        if (path == null) {
            return false;
        }
        TreeItemTreeNode node = (TreeItemTreeNode)path.getLastPathComponent();
        return node.isLeaf();
    }

    @Override
    public String getHelpTopic() {
        return "userInterface.newJobWizard.selectingARemoteDataSet";
    }
}

