/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.jds.module.ModuleException;
import jas2.swingstudio.JASJob;
import jas2.swingstudio.JASJobAdaptor;
import jas2.swingstudio.JASLocalJobBuilder;
import jas2.swingstudio.JASRegistry;
import jas2.swingstudio.JDSWizard;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.LocalJobPage;
import jas2.swingstudio.NewProgramPage;
import jas2.swingstudio.OpenDataSetPage;
import jas2.util.Finishable;
import jas2.util.HasHelpPage;
import jas2.util.HasNextPages;
import jas2.util.JASTextField;
import jas2.util.JASWizard;
import jas2.util.JASWizardPage;
import jas2.util.UserProperties;
import jas2.util.WrappingTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class NewJobPage
extends JASWizardPage
implements HasNextPages,
HasHelpPage {
    private static final long serialVersionUID = 1L;
    private JASTextField m_name = new JASTextField("Untitled");
    private RemoteJobPage m_remoteJobPage;
    private LocalJobPage m_localJobPage;
    private JASWizardPage m_eventGeneratorPage;
    private static final int m_localJob = 1;
    private static final int m_analyzer = 2;
    private static final int m_other = 4;
    private int m_flags;
    private Map jobTypes;
    private final JComboBox other_chooser;
    private JavaAnalysisStudio m_JASapp = JavaAnalysisStudio.getApp();
    private final UserProperties m_prop = this.m_JASapp.getUserProperties();
    private final String m_lastJobType_Key = "LastJobType";
    private final String m_otherJobType_Key = "OtherJobType";

    NewJobPage() {
        super(new BorderLayout());
        JPanel namePanel = new JPanel(new BorderLayout());
        namePanel.setBorder(BorderFactory.createTitledBorder("Job name"));
        namePanel.add("North", new JLabel("Enter a name for your job:"));
        namePanel.add("South", this.m_name);
        this.m_name.addKeyListener(this);
        JPanel jobType = new JPanel(new BorderLayout());
        jobType.setBorder(BorderFactory.createTitledBorder("Job type"));
        jobType.add("North", new JLabel("What kind of job would you like?"));
        this.m_flags = this.m_prop.getInteger("LastJobType", 3);
        final JRadioButton local_analysis = new JRadioButton("A local job for data analysis.", this.m_flags == 3);
        final JRadioButton remote_analysis = new JRadioButton("A remote job for data analysis.", this.m_flags == 2);
        final JRadioButton local_generator = new JRadioButton("A local job for generating events.", this.m_flags == 1);
        final JRadioButton remote_generator = new JRadioButton("A remote job for generating events.", this.m_flags == 0);
        ButtonGroup bg = new ButtonGroup();
        bg.add(local_analysis);
        bg.add(remote_analysis);
        bg.add(local_generator);
        bg.add(remote_generator);
        this.jobTypes = JASRegistry.getJobTypes();
        boolean hasOther = !this.jobTypes.isEmpty();
        final JRadioButton other_job = new JRadioButton("Special Job", this.m_flags == 4);
        this.other_chooser = new JComboBox<Object>(this.jobTypes.keySet().toArray());
        this.other_chooser.setEnabled(this.m_flags == 4);
        JPanel buttonPanel = new JPanel(new GridLayout(hasOther ? 3 : 2, 2));
        buttonPanel.add(local_analysis);
        buttonPanel.add(remote_analysis);
        buttonPanel.add(local_generator);
        buttonPanel.add(remote_generator);
        if (hasOther) {
            String defType = this.m_prop.getString("OtherJobType", null);
            if (defType != null) {
                this.other_chooser.setSelectedItem(defType);
            }
            bg.add(other_job);
            buttonPanel.add(other_job);
            buttonPanel.add(this.other_chooser);
        }
        jobType.add("Center", buttonPanel);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source == local_analysis) {
                    NewJobPage.this.m_flags = 3;
                } else if (source == remote_analysis) {
                    NewJobPage.this.m_flags = 2;
                } else if (source == local_generator) {
                    NewJobPage.this.m_flags = 1;
                } else if (source == remote_generator) {
                    NewJobPage.this.m_flags = 0;
                } else if (source == other_job) {
                    NewJobPage.this.m_flags = 4;
                }
                NewJobPage.this.other_chooser.setEnabled(NewJobPage.this.m_flags == 4);
                NewJobPage.this.forceEnable();
            }
        };
        local_analysis.addActionListener(al);
        remote_analysis.addActionListener(al);
        local_generator.addActionListener(al);
        remote_generator.addActionListener(al);
        if (hasOther) {
            other_job.addActionListener(al);
        }
        this.add("North", namePanel);
        this.add("Center", jobType);
    }

    @Override
    public void beforeShowing() {
        this.m_name.requestFocus();
    }

    private void forceEnable() {
        this.doEnable();
    }

    @Override
    public JASWizardPage getNext() {
        this.m_prop.setInteger("LastJobType", this.m_flags);
        if (this.m_flags == 4) {
            Object type = this.other_chooser.getSelectedItem();
            this.m_prop.setString("OtherJobType", type.toString());
            JASWizardPage page = (JASWizardPage)this.jobTypes.get(type);
            return page;
        }
        if ((this.m_flags & 1) == 0) {
            return this.m_remoteJobPage;
        }
        if ((this.m_flags & 2) == 0) {
            return this.m_eventGeneratorPage;
        }
        JASLocalJobBuilder ljb = this.m_JASapp.getLocalJobBuilder();
        ljb.setJobName(this.m_name.getText());
        this.m_localJobPage.setJobBuilder(ljb);
        return this.m_localJobPage;
    }

    @Override
    public JASWizardPage[] getNextWizardPages() {
        this.m_remoteJobPage = new RemoteJobPage();
        this.m_localJobPage = new LocalJobPage();
        this.m_eventGeneratorPage = new EventGeneratorPage();
        JASWizardPage[] result = new JASWizardPage[3 + this.jobTypes.size()];
        result[0] = this.m_remoteJobPage;
        result[1] = this.m_localJobPage;
        result[2] = this.m_eventGeneratorPage;
        System.arraycopy(this.jobTypes.values().toArray(), 0, result, 3, this.jobTypes.size());
        return result;
    }

    @Override
    protected boolean getNextEnabled() {
        return this.m_name.getText().length() > 0;
    }

    @Override
    public String getHelpTopic() {
        return "jobs.jobs";
    }

    private class EventGeneratorPage
    extends JASWizardPage
    implements Finishable {
        private final String m_openProgWiz_Key = "openProgWiz";
        private final JCheckBox m_openProgWiz;

        EventGeneratorPage() {
            super(new GridBagLayout());
            this.m_openProgWiz_Key = "openProgWiz";
            this.m_openProgWiz = new JCheckBox("Open the program page wizard now", NewJobPage.this.m_prop.getBoolean("openProgWiz", true));
            WrappingTextArea text = new WrappingTextArea("You have now set up a job for generating events.  To create event generator code, you may wish to use the program page wizard.", false, this.getBackground(), new Dimension(400, 50));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 10;
            this.add((Component)text, c);
            c.gridy = 1;
            this.add((Component)this.m_openProgWiz, c);
            this.m_openProgWiz.setMnemonic('O');
        }

        @Override
        public void onFinish() {
            if ((NewJobPage.this.m_flags & 1) != 0) {
                JASLocalJobBuilder ljb = NewJobPage.this.m_JASapp.getLocalJobBuilder();
                ljb.setJobName(NewJobPage.this.m_name.getText());
                ljb.setDIM(null);
                ljb.createJob(null);
            }
            boolean openWiz = this.m_openProgWiz.isSelected();
            NewJobPage.this.m_prop.setBoolean("openProgWiz", openWiz);
            this.dispose();
            if (openWiz) {
                new JASWizard(NewJobPage.this.m_JASapp.getFrame(), "New Program Page Wizard", new NewProgramPage(1));
            }
        }
    }

    private class RemoteJobPage
    extends JDSWizard {
        private JASJob m_jasJob;
        private JASJobAdaptor m_job;
        private OpenDataSetPage m_openDataSetPage = new OpenDataSetPage();

        private RemoteJobPage() {
        }

        private JASJobAdaptor openServerConnection() throws ModuleException {
            String server = this.m_server.getText();
            String name = NewJobPage.this.m_name.getText();
            this.m_jasJob = new JASJob(name);
            JASJobAdaptor job = new JASJobAdaptor(this.m_jasJob, name, server, this.m_service, this.m_port, this);
            if (!job.open()) {
                return null;
            }
            this.saveLastServer();
            return job;
        }

        @Override
        public JASWizardPage getNext() {
            try {
                this.m_job = this.openServerConnection();
                if (this.m_job == null) {
                    return null;
                }
                this.m_app.closeCurrentJob();
                this.m_jasJob.setJob(this.m_job);
                this.m_app.setJob(this.m_jasJob, true);
                this.m_openDataSetPage.setJob(this.m_job, this.m_app);
                this.saveLastServer();
                JASWizardPage custom = this.m_job.getCustomWizardPage();
                if (custom != null) {
                    return custom;
                }
                return (NewJobPage.this.m_flags & 2) != 0 ? this.m_openDataSetPage : NewJobPage.this.m_eventGeneratorPage;
            }
            catch (Throwable e) {
                this.m_jasJob.close();
                this.m_app.error("Could not connect", e);
                return null;
            }
        }

        @Override
        public void onCancel() {
            if (this.m_jasJob != null) {
                this.m_jasJob.close();
                this.m_app.closeCurrentJob();
                this.m_app.setToEmptyJob();
            }
        }

        @Override
        public JASWizardPage[] getNextWizardPages() {
            JASWizardPage[] result = new JASWizardPage[]{this.m_openDataSetPage};
            return result;
        }
    }
}

