/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.swingstudio.Cut;
import jas2.swingstudio.CutPropertiesDialog;
import jas2.swingstudio.CutPropertiesPanel;
import jas2.swingstudio.CutsManager;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.util.Application;
import jas2.util.JASDialog;
import jas2.util.JASState;
import jas2.util.JASTextField;
import jas2.util.ObjectFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

final class NewCutItemDialog
extends JASDialog
implements KeyListener {
    private final String[] m_cutClassNames = new String[]{"DoubleCut"};
    private CutsManager cuts;
    private Cut cut;
    private final JTextField m_nameField = new JASTextField();
    private final JComboBox m_classesBox = new JComboBox();

    NewCutItemDialog(CutsManager cuts) {
        super((Frame)Application.getApplication().getFrame(), "New Cut item", true, 13);
        this.cuts = cuts;
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        for (int i = 0; i < this.m_cutClassNames.length; ++i) {
            this.m_classesBox.addItem(this.m_cutClassNames[i]);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.ipadx = 10;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridx = 0;
        gbc.gridy = 0;
        c.add((Component)new JLabel("Select a Cut subclass:"), gbc);
        gbc.gridy = 1;
        c.add((Component)new JLabel("Supply a name for this cut:"), gbc);
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 0;
        c.add((Component)this.m_classesBox, gbc);
        gbc.gridy = 1;
        c.add((Component)this.m_nameField, gbc);
        this.pack();
        this.m_nameField.addKeyListener(this);
        this.setHelpTopic("userInterface.newCutDialog");
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.callEnable();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    void clearTextField() {
        this.m_nameField.setText("");
    }

    private boolean nameIsUsed(String name) {
        Enumeration e = this.cuts.elements();
        while (e.hasMoreElements()) {
            if (!((Cut)e.nextElement()).m_name.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void onOK() {
        String name = this.m_nameField.getText().replace(' ', '_');
        if (this.nameIsUsed(name)) {
            JOptionPane.showMessageDialog(Application.getApplication().getFrame(), "You cannot use a the same name for two cuts: " + name, "Error", 0);
        } else {
            String cutName = (String)this.m_classesBox.getSelectedItem();
            this.cut = new Cut();
            try {
                CutPropertiesPanel p = (CutPropertiesPanel)new ObjectFactory(Class.forName("jas2.cuts." + cutName + "Panel")).create();
                if (new CutSetupDialog(p).doModal()) {
                    this.cut.m_type = cutName;
                    this.cut.m_description = p.getDescription(name);
                    if (this.cut.m_description == null) {
                        return;
                    }
                    this.cut.m_constructor = p.getConstructor(name);
                    if (this.cut.m_constructor == null) {
                        return;
                    }
                    this.cut.m_name = name;
                    super.onOK();
                }
            }
            catch (Exception e) {
                JavaAnalysisStudio.getApp().error("Could not load class.", e);
            }
        }
    }

    Cut getCut() {
        return this.cut;
    }

    @Override
    protected void enableOK(JASState state) {
        state.setEnabled(this.m_nameField.getText().length() > 0);
    }

    private final class CutSetupDialog
    extends JASDialog
    implements CutPropertiesDialog {
        private boolean m_changed;
        private CutPropertiesPanel m_panel;

        CutSetupDialog(CutPropertiesPanel p) {
            super((Frame)Application.getApplication().getFrame(), "Cut setup");
            this.m_changed = false;
            this.setContentPane(p);
            this.m_panel = p;
            p.m_dialog = this;
            this.pack();
        }

        @Override
        public void changeNotify(boolean irrelevant) {
            if (!this.m_changed) {
                this.m_changed = true;
                this.callEnable();
            }
        }

        @Override
        protected void enableOK(JASState s) {
            s.setEnabled(this.m_changed);
        }
    }
}

