/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.swingstudio.JASAddRemovePanel;
import jas2.swingstudio.JASList;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.util.Application;
import jas2.util.UserProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class MultiFilePanel
extends JPanel {
    private final UserProperties m_prop = Application.getApplication().getUserProperties();
    private FileAddRemovePanel ar;
    private JButton save;
    private JButton restore;
    private JButton clear;
    private String description;
    private String borderText;
    private FileFilter filter;
    private String key;
    private FileList fileList;

    public MultiFilePanel(FileFilter f, String description, String borderText, String key) {
        this.filter = f;
        this.description = description;
        this.borderText = borderText;
        this.key = key;
        this.fileList = new FileList();
        this.setLayout(new BorderLayout());
        this.ar = new FileAddRemovePanel(this.fileList, description, borderText);
        this.add((Component)this.ar, "Center");
        this.clear = new JButton("Clear File Set");
        this.save = new JButton("Save File Set...");
        this.restore = new JButton("Restore File Set...");
        this.clear.addActionListener(this.ar);
        this.save.addActionListener(this.ar);
        this.restore.addActionListener(this.ar);
        JPanel p = new JPanel(new GridLayout(3, 1));
        p.add(this.clear);
        p.add(this.save);
        p.add(this.restore);
        this.add((Component)p, "East");
    }

    public int getNFiles() {
        this.ar.update();
        return this.fileList.getSize();
    }

    public String getFilePath() {
        this.ar.update();
        StringBuffer path = new StringBuffer();
        Enumeration e = this.fileList.elements();
        while (e.hasMoreElements()) {
            path.append(e.nextElement().toString());
            if (!e.hasMoreElements()) break;
            path.append(File.pathSeparatorChar);
        }
        return path.toString();
    }

    public void saveState() {
        this.ar.update();
        String[] files = new String[this.fileList.getSize()];
        Enumeration e = this.fileList.elements();
        for (int i = 0; i < files.length; ++i) {
            files[i] = e.nextElement().toString();
        }
        this.m_prop.setStringArray(this.key, files);
    }

    final class FileListFileFilter
    extends FileFilter {
        FileListFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".filelist");
        }

        @Override
        public String getDescription() {
            return "File List (*.filelist)";
        }
    }

    private class FileAddRemovePanel
    extends JASAddRemovePanel {
        FileAddRemovePanel(FileList fl, String desc, String bt) {
            super(fl, desc, bt, "Select New Files");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                String dir = MultiFilePanel.this.m_prop.getString(MultiFilePanel.this.key + ".dir", ".");
                Object source = ae.getSource();
                if (source == MultiFilePanel.this.save) {
                    JFileChooser chooser = new JFileChooser(dir);
                    chooser.setDialogTitle("Save File Set ...");
                    chooser.setMultiSelectionEnabled(false);
                    chooser.setFileFilter(new FileListFileFilter());
                    if (chooser.showSaveDialog(MultiFilePanel.this) == 0) {
                        File file = chooser.getSelectedFile();
                        if (file.getName().indexOf(".") < 0) {
                            file = new File(file.getAbsolutePath() + ".filelist");
                        }
                        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                        this.update();
                        Enumeration e = MultiFilePanel.this.fileList.elements();
                        while (e.hasMoreElements()) {
                            pw.println(e.nextElement().toString());
                        }
                        pw.close();
                        MultiFilePanel.this.m_prop.setString(MultiFilePanel.this.key + ".dir", file.toString());
                    }
                } else if (source == MultiFilePanel.this.restore) {
                    JFileChooser chooser = new JFileChooser(dir);
                    chooser.setDialogTitle("Restore File Set ...");
                    chooser.setMultiSelectionEnabled(false);
                    chooser.setFileFilter(new FileListFileFilter());
                    if (chooser.showOpenDialog(MultiFilePanel.this) == 0) {
                        File file = chooser.getSelectedFile();
                        LineNumberReader read = new LineNumberReader(new FileReader(file));
                        Vector<File> files = new Vector<File>();
                        String line = read.readLine();
                        while (line != null) {
                            files.addElement(new File(line));
                            line = read.readLine();
                        }
                        read.close();
                        MultiFilePanel.this.fileList.setContents(files);
                        this.setModel(MultiFilePanel.this.fileList);
                        MultiFilePanel.this.m_prop.setString(MultiFilePanel.this.key + ".dir", file.toString());
                    }
                } else if (source == MultiFilePanel.this.clear) {
                    MultiFilePanel.this.fileList.setContents(new Vector());
                    this.setModel(MultiFilePanel.this.fileList);
                } else {
                    super.actionPerformed(ae);
                }
            }
            catch (IOException x) {
                JavaAnalysisStudio.getApp().error("Error saving or restoring file set", x);
            }
        }

        @Override
        protected Object add(String addText) {
            String dir = MultiFilePanel.this.m_prop.getString(MultiFilePanel.this.key + ".dir", ".");
            JFileChooser choose = new JFileChooser(dir);
            choose.setDialogTitle("Files to add to dataset");
            choose.setFileFilter(MultiFilePanel.this.filter);
            choose.setMultiSelectionEnabled(true);
            int rc = choose.showDialog(this, "Add");
            if (rc != 0) {
                return null;
            }
            File[] f = choose.getSelectedFiles();
            if (f == null || f.length == 0) {
                return null;
            }
            MultiFilePanel.this.m_prop.setString(MultiFilePanel.this.key + ".dir", f[0].toString());
            return f;
        }
    }

    private class FileList
    implements JASList {
        private Vector v = new Vector();

        FileList() {
            String[] files = MultiFilePanel.this.m_prop.getStringArray(MultiFilePanel.this.key, null);
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    this.v.addElement(new File(files[i]));
                }
            }
        }

        @Override
        public Enumeration elements() {
            return this.v.elements();
        }

        @Override
        public void setContents(Vector v) {
            this.v = v;
        }

        int getSize() {
            return this.v.size();
        }
    }
}

