/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import hepjas.analysis.NamedObject;
import jas2.export.Register;
import jas2.hist.FitListener;
import jas2.hist.FitUpdate;
import jas2.hist.Fitter;
import jas2.hist.JASHist;
import jas2.hist.XMLHistBuilder;
import jas2.jds.interfaces.JavaDataServer;
import jas2.jds.module.LocalDIM2;
import jas2.job.JobFolder;
import jas2.loader.ClassPath;
import jas2.loader.ClassPathLoader;
import jas2.plugin.ExtensionPluginContext;
import jas2.plugin.IExtensionPlugin;
import jas2.plugin.IPluginInfo;
import jas2.swingstudio.AboutBox;
import jas2.swingstudio.AllSupportedFileFilter;
import jas2.swingstudio.ChangableContainer;
import jas2.swingstudio.ConnectFailed;
import jas2.swingstudio.ConnectPage;
import jas2.swingstudio.FileError;
import jas2.swingstudio.HTMLPage;
import jas2.swingstudio.JASCommandProcessor;
import jas2.swingstudio.JASConsoleTabbedPane;
import jas2.swingstudio.JASException;
import jas2.swingstudio.JASFileFilter;
import jas2.swingstudio.JASJob;
import jas2.swingstudio.JASJobAdaptor;
import jas2.swingstudio.JASLeftRightSplitPane;
import jas2.swingstudio.JASLocalJobBuilder;
import jas2.swingstudio.JASOptionsDialog;
import jas2.swingstudio.JASPage;
import jas2.swingstudio.JASPluginContext;
import jas2.swingstudio.JASRegistry;
import jas2.swingstudio.JASRegistryDialog;
import jas2.swingstudio.JASToolbarHolder;
import jas2.swingstudio.JASTopBottomSplitPane;
import jas2.swingstudio.JASTree;
import jas2.swingstudio.JASWindowManager;
import jas2.swingstudio.LocalJob;
import jas2.swingstudio.NewJobPage;
import jas2.swingstudio.NewProgramPage;
import jas2.swingstudio.NotImplemented;
import jas2.swingstudio.ProgramPage;
import jas2.swingstudio.StatusBar;
import jas2.swingstudio.StoppableExecution;
import jas2.swingstudio.StoppableExecutionMonitor;
import jas2.swingstudio.SwingStudioIcon;
import jas2.swingstudio.WebPageDialog;
import jas2.swingstudio.WindowItem;
import jas2.swingstudio.WindowManager;
import jas2.util.Application;
import jas2.util.CommandProcessor;
import jas2.util.CommandSource;
import jas2.util.CommandTarget;
import jas2.util.FileTypeFileFilter;
import jas2.util.GetOptions;
import jas2.util.JASCheckboxMenuItem;
import jas2.util.JASCheckboxState;
import jas2.util.JASIcon;
import jas2.util.JASMenuItem;
import jas2.util.JASRadioMenuItem;
import jas2.util.JASState;
import jas2.util.JASToolBarButton;
import jas2.util.JASWizard;
import jas2.util.OnScreenPopupMenu;
import jas2.util.SimpleCommandTarget;
import jas2.util.UserProperties;
import jas2.util.moverlayeredpane.MLPArrowFactory;
import jas2.util.moverlayeredpane.MLPLabelFactory;
import jas2.util.moverlayeredpane.MoverLayeredPane;
import jas2.util.multifunctionpanel.MultiFunctionPanel;
import jas2.util.pluginmanager.JASVersion;
import jas2.util.pluginmanager.PluginManager;
import jas2.util.xml.XMLWriter;
import jas2.util.xmlmenus.XMLMenuBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BoundedRangeModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;

public final class JavaAnalysisStudio
extends Application {
    private static final long serialVersionUID = 1L;
    private static int makeCount = 0;
    private ClassPathLoader m_extensionLoader;
    private CommandProcessor m_currentSelection;
    private ExtensionPluginContext pluginContext;
    private JASConsoleTabbedPane m_JASConsoleTabbedPane;
    private WindowManager m_windowManager;
    private JMenuBar m_disconnectedMenuBar;
    private JASJob m_job = null;
    private JTree m_tree;
    private JASTopBottomSplitPane m_topBottomSplitPane;
    private JASLeftRightSplitPane m_leftRightSplitPane;
    private static JavaAnalysisStudio theApp;
    private JASToolbarHolder m_toolbarHolder;
    private JFrame frame;
    private JTabbedPane m_controlPane;
    private StatusBar m_status;
    private boolean m_statusBarVisible;
    private UserProperties userProp = this.getUserProperties();
    private int nPages = 0;
    private String[] m_lastJobs;
    private String[] m_lastFiles;
    private JASCommand m_jasCommand;
    private JASStoppableManager m_stopMan = new JASStoppableManager();
    private URL m_homePage;
    private boolean m_noTopBottomSplitPane = true;
    private String menuFile = "menus.xml";
    private PluginManager pluginmanager;
    final String m_lastJobPath_Key = "LastJobPath";
    private static final String m_WindowsLAF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final String m_MotifLAF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private static final String m_JavaLAF = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String m_TabbedWM = "jas2.swingstudio.JASWindowManager";
    private static final String m_InternalWM = "jas2.swingstudio.InternalFramesWindowManager";
    private static final String versionURL = "http://jas.freehep.org/version.asp";
    static final boolean jobSavingDisabled = true;
    static final long checkWord = 3457768635619245585L;
    static final String[][] knownDebugFlags;
    private XMLMenuBuilder xmb;

    @Override
    protected void doHelp() {
        System.out.println();
        System.out.println(this.getVersionName());
        System.out.println();
        super.doHelp();
        System.out.println();
        System.out.println("Parameters:");
        System.out.println("\tp1 - A job file to read at startup");
        System.out.println();
        System.out.println("Known debug flags:");
        for (int i = 0; i < knownDebugFlags.length; ++i) {
            System.out.println("\t" + this.pad(knownDebugFlags[i][0], 19) + " " + knownDebugFlags[i][1]);
        }
    }

    private String pad(String value, int length) {
        String padding = "                                                       ";
        int l = value.length();
        if (l == length) {
            return value;
        }
        if (l < length) {
            return value + padding.substring(0, length - l);
        }
        return value.substring(length);
    }

    @Override
    protected void setDebugFlag(String flag) {
        if (flag.equals("all")) {
            for (int i = 0; i < knownDebugFlags.length; ++i) {
                super.setDebugFlag(knownDebugFlags[i][0]);
            }
        }
        super.setDebugFlag(flag);
    }

    public JavaAnalysisStudio() throws Exception {
        theApp = this;
        GetOptions gopt = this.getGetOptions();
        gopt.addOption("nosplash", 'n', true, "Suppress the splash screen");
        gopt.addOption("startPage", 's', false, "URL for the welcome page");
        gopt.addOption("connect", 'c', false, "Reconnect to server/job at startup");
        gopt.addOption("extdir", 'e', false, "Directory to search for extensions");
        gopt.addOption("menus", 'm', false, "Path of an alternate XML file to read the menus from");
        gopt.addOption("noversion", 'v', true, "Do not perform application version check on start up");
        this.init(null);
    }

    public void hideJASConsole() {
        this.m_topBottomSplitPane.saveState();
        this.remove(this.m_topBottomSplitPane);
        this.m_noTopBottomSplitPane = true;
        this.add("Center", this.m_leftRightSplitPane);
        this.validate();
        this.repaint();
    }

    public void showJASConsole() {
        this.remove(this.m_leftRightSplitPane);
        if (this.m_noTopBottomSplitPane) {
            this.makeNewTopBottomSplitPane();
            this.m_noTopBottomSplitPane = false;
        }
        this.validate();
        this.m_topBottomSplitPane.restoreState();
        this.repaint();
    }

    private void makeNewTopBottomSplitPane() {
        this.m_topBottomSplitPane = new JASTopBottomSplitPane(false, (Component)this.m_leftRightSplitPane, (Component)this.m_JASConsoleTabbedPane);
        this.m_topBottomSplitPane.setOneTouchExpandable(true);
        this.add("Center", this.m_topBottomSplitPane);
    }

    private void init(String jobToLoad) throws Exception {
        String laf = this.userProp.getString("LookAndFeel", null);
        if (laf == null) {
            laf = UIManager.getSystemLookAndFeelClassName();
        }
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.xmb = new XMLMenuBuilder(new InputStreamReader(this.getClass().getResourceAsStream(this.menuFile)), this.menuFile);
        this.xmb.setDefaultMenuItemClass(JASMenuItem.class);
        this.xmb.setDefaultRadioMenuItemClass(JASRadioMenuItem.class);
        this.xmb.setDefaultCheckboxMenuItemClass(JASCheckboxMenuItem.class);
        this.xmb.setDefaultPopupMenuItemClass(JASMenuItem.class);
        this.xmb.setDefaultPopupRadioMenuItemClass(JASRadioMenuItem.class);
        this.xmb.setDefaultPopupCheckboxMenuItemClass(JASCheckboxMenuItem.class);
        this.xmb.setDefaultToolBarItemClass(JASToolBarButton.class);
        this.xmb.setDefaultImageIconClass(SwingStudioIcon.class);
        this.xmb.setDefaultPopupMenuClass(OnScreenPopupMenu.class);
        this.m_JASConsoleTabbedPane = new JASConsoleTabbedPane(3);
        this.m_disconnectedMenuBar = this.xmb.getMenuBar("mainMenu");
        this.loadExtensions();
        try {
            new Register().init();
        }
        catch (NoClassDefFoundError x) {
            System.err.println("Warning: Exporters not registered");
        }
        JASHist.addFitListener(new JASFitListener());
        String className = this.userProp.getString("WindowManager", m_TabbedWM);
        try {
            Class<?> c = Class.forName(className);
            this.m_windowManager = (WindowManager)c.newInstance();
        }
        catch (Exception e) {
            this.m_windowManager = new JASWindowManager();
            this.userProp.setString("WindowManager", this.m_windowManager.getClass().getName());
        }
        this.addHelpLocation(ClassLoader.getSystemResource("JasHelp.hs"));
        String version = this.getVersionNumber();
        this.addHelpLocation("http://jas.freehep.org/help/" + version + "/JasHelp.hs");
        version = version.substring(0, version.lastIndexOf("."));
        this.addHelpLocation("http://jas.freehep.org/help/" + version + "/JasHelp.hs");
        this.m_jasCommand = new JASCommand();
        this.getCommandManager().add(this.m_jasCommand);
        this.m_tree = new JASTree();
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.setEditable(true);
        this.m_tree.setShowsRootHandles(true);
        JScrollPane treePane = new JScrollPane();
        treePane.setMinimumSize(new Dimension(20, 20));
        treePane.setPreferredSize(new Dimension(150, 4000));
        treePane.setViewportView(this.m_tree);
        this.m_controlPane = new JTabbedPane();
        this.m_controlPane.setTabPlacement(3);
        this.m_controlPane.addTab("JAS", treePane);
        this.m_leftRightSplitPane = new JASLeftRightSplitPane(false, (Component)this.m_controlPane, (Component)((Object)this.m_windowManager));
        this.m_leftRightSplitPane.restoreState();
        this.m_JASConsoleTabbedPane.setMinimumSize(new Dimension(0, 0));
        this.m_JASConsoleTabbedPane.setPreferredSize(new Dimension(0, 0));
        this.add("Center", this.m_leftRightSplitPane);
        DoubleClickAdaptor dc = new DoubleClickAdaptor();
        this.m_tree.addMouseListener(dc);
        this.getCommandManager().add(dc);
        SelectAdaptor sa = new SelectAdaptor();
        this.m_tree.addTreeSelectionListener(sa);
        this.getCommandManager().add(sa);
        this.m_toolbarHolder = new JASToolbarHolder(this.xmb);
        this.add("North", this.m_toolbarHolder);
        this.m_status = new StatusBar();
        this.setStatusBarVisible(this.userProp.getBoolean("StatusBarVisible", true));
        this.m_lastJobs = this.userProp.getStringArray("LastJobs", null);
        this.m_lastFiles = this.userProp.getStringArray("LastFiles", null);
        ToolTipManager.sharedInstance().setEnabled(this.userProp.getBoolean("EnableToolTips", true));
        this.frame = new JFrame();
        this.frame.setTitle("Java Analysis Studio");
        this.frame.setIconImage(JASIcon.create(this, "images/histogram.gif").getImage());
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this, "Center");
        this.frame.getContentPane().add((Component)this.getMenuBar(), "North");
        this.frame.setDefaultCloseOperation(0);
        this.frame.setDefaultCloseOperation(2);
        this.frame.addWindowListener(new AppCloser());
        this.getCommandManager().start();
        if (!this.m_noTopBottomSplitPane) {
            this.m_topBottomSplitPane.restoreState();
        }
        this.setToEmptyJob();
        if (jobToLoad == null && this.userProp.getBoolean("OpenLastJobAtStartup", false) && this.m_lastJobs != null && this.m_lastJobs.length > 0) {
            jobToLoad = this.m_lastJobs[0];
        }
        String jobToOpen = jobToLoad;
        GetOptions gopt = this.getGetOptions();
    }

    String getUserExtensionsDir() {
        return JavaAnalysisStudio.resolveSymbols(System.getProperty("jas.user.extensions", "{user.home}/JASExtensions"));
    }

    String getGroupExtensionsDir() {
        return JavaAnalysisStudio.resolveSymbols(System.getProperty("jas.group.extensions"));
    }

    String getSystemExtensionsDir() {
        return JavaAnalysisStudio.resolveSymbols(System.getProperty("jas.system.extensions", "lib" + File.separator + "extensions"));
    }

    public void showIt(boolean show) {
        this.frame.setVisible(show);
    }

    public void close() {
        this.m_lastJobs = null;
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    public JASToolbarHolder getToolbar() {
        return this.m_toolbarHolder;
    }

    private void loadExtensions() {
        boolean debugExtensions = System.getProperty("debugExtensions") != null;
        ClassPath extensionClasspath = new ClassPath();
        Vector plugins = new Vector();
        Vector plugininfo = new Vector();
        String[] extDirs = new String[]{this.getUserExtensionsDir(), this.getGroupExtensionsDir(), this.getSystemExtensionsDir()};
        this.scanExtensionDirectories(extDirs, extensionClasspath, plugins, plugininfo, debugExtensions);
        this.m_extensionLoader = new ClassPathLoader(extensionClasspath, "ExtensionLoader");
        this.pluginContext = new JASPluginContext(this);
        Enumeration e = plugins.elements();
        Enumeration info = plugininfo.elements();
        this.pluginmanager = new PluginManager(this.getSystemExtensionsDir(), this.getUserExtensionsDir());
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            File file = (File)info.nextElement();
            String infopath = file.getParent();
            String infofile = file.getName();
            try {
                System.out.println("Loading extension: " + name);
                Class c = this.m_extensionLoader.loadClass(name, true);
                IExtensionPlugin p = (IExtensionPlugin)c.newInstance();
                p.setPluginContext(this.pluginContext);
                if (p instanceof IPluginInfo) {
                    this.pluginmanager.setPluginLoadedAtStart(((IPluginInfo)((Object)p)).getName(), ((IPluginInfo)((Object)p)).getVersion(), infopath, infofile);
                    continue;
                }
                this.pluginmanager.setPluginLoadedAtStart(infofile, "unknown", infopath, infofile);
            }
            catch (Throwable t) {
                System.err.println("Unable to load plugin " + name);
                t.printStackTrace();
            }
        }
    }

    public ExtensionPluginContext getPluginContext() {
        return this.pluginContext;
    }

    private void scanExtensionDirectories(String[] dirs, ClassPath extensionClasspath, Vector plugins, Vector plugininfo, boolean debugExtensions) {
        for (int i = 0; i < dirs.length; ++i) {
            if (dirs[i] == null) continue;
            File extdir = new File(dirs[i]);
            if (debugExtensions) {
                System.out.println("Seaching for extensions in: " + extdir);
            }
            if (!extdir.isDirectory()) continue;
            this.scanExtensionDirectory(extdir, extensionClasspath, plugins, plugininfo, debugExtensions);
        }
    }

    public static String resolveSymbols(String in) {
        if (in == null) {
            return null;
        }
        while (true) {
            String prop;
            int start = in.indexOf(123);
            int end = in.indexOf(125);
            if (start < 0 || end < 0 || end - start < 2) break;
            StringBuffer out = new StringBuffer();
            if (start > 0) {
                out.append(in.substring(0, start));
            }
            if ((prop = System.getProperty(in.substring(start + 1, end - start))) != null) {
                out.append(prop);
            }
            if (end + 1 < in.length()) {
                out.append(in.substring(end + 1));
            }
            in = out.toString();
        }
        return in;
    }

    private void scanExtensionDirectory(File extdir, ClassPath extensionClasspath, Vector plugins, Vector plugininfo, boolean debugExtensions) {
        String[] files = extdir.list();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].endsWith(".jar")) continue;
            File f = new File(extdir, files[i]);
            if (f.length() > 0L) {
                try {
                    ZipFile zipFile = new ZipFile(f);
                    ZipEntry manifest = zipFile.getEntry("JAS-inf/plugins.txt");
                    if (manifest != null) {
                        String line;
                        LineNumberReader reader = new LineNumberReader(new InputStreamReader(zipFile.getInputStream(manifest)));
                        while ((line = reader.readLine()) != null) {
                            if (plugins.indexOf(line) >= 0) continue;
                            plugins.addElement(line);
                            plugininfo.addElement(f);
                        }
                        reader.close();
                    }
                    if (debugExtensions) {
                        System.out.println("\tFound: " + files[i]);
                    }
                    extensionClasspath.add(zipFile);
                }
                catch (IOException x) {
                    System.err.println("Extension jar file " + files[i] + " could not be loaded" + x);
                }
                continue;
            }
            boolean bl = f.delete();
        }
    }

    private void reconnect(String connect) throws Exception {
        StringTokenizer t = new StringTokenizer(connect, "/");
        if (t.countTokens() != 2) {
            throw new ConnectException("Invalid connect option " + connect);
        }
        String node = t.nextToken();
        String jobName = t.nextToken();
        JavaDataServer jds = JASJobAdaptor.connectToServer(node, null, 0, this);
        if (jds == null) {
            return;
        }
        JASJob jasJob = new JASJob(jobName);
        JASJobAdaptor job = new JASJobAdaptor(jasJob, jobName, jds, this);
        jasJob.setJob(job);
        this.setJob(jasJob, true);
        job.listItems();
    }

    public JASPage getCurrentPage() {
        try {
            Component c = this.m_windowManager.getWindow(this.m_windowManager.getSelectedWindow());
            return (JASPage)c;
        }
        catch (Exception e) {
            return null;
        }
    }

    public JTabbedPane getControlPane() {
        return this.m_controlPane;
    }

    public JTabbedPane getConsolePane() {
        return this.m_JASConsoleTabbedPane;
    }

    public JASPage newPage(int nx, int ny) {
        ++this.nPages;
        JASPage page = new JASPage(nx, ny);
        this.m_windowManager.newWindow("Page " + this.nPages, page);
        return page;
    }

    public void setNPages(int nPages) {
        this.nPages = nPages;
    }

    public void setStatusBarVisible(boolean visible) {
        this.m_statusBarVisible = visible;
        if (visible) {
            this.add("South", this.m_status);
        } else {
            this.remove(this.m_status);
        }
        this.revalidate();
    }

    public JMenuBar getMenuBar() {
        return this.m_disconnectedMenuBar;
    }

    public JASJob getJob() {
        return this.m_job;
    }

    public ClassPathLoader getExtensionLoader() {
        return this.m_extensionLoader;
    }

    public static String getVersionNumber() {
        return "2.2.8";
    }

    String getVersionName() {
        return "Java Analysis Studio - " + JavaAnalysisStudio.getVersionNumber() + " (10 April 2002)";
    }

    public static void main(String[] argv) {
        try {
            theApp = new JavaAnalysisStudio();
        }
        catch (Throwable e) {
            System.err.println("Java Analysis Studio Failed to Initialize");
            e.printStackTrace();
            System.exit(1);
        }
    }

    void openLastJob() {
        if (this.m_lastJobs == null || this.m_lastJobs.length == 0) {
            this.error("There is no last job to open.");
            return;
        }
        try {
            this.readJob(new File(this.m_lastJobs[0]));
        }
        catch (Throwable e) {
            this.error("Could not open last job", e);
        }
    }

    public static JavaAnalysisStudio getApp() {
        return theApp;
    }

    public TreeModel getTreeModel() {
        return this.m_tree.getModel();
    }

    void setCurrentSelection(CommandProcessor o) {
        if (this.m_currentSelection != null) {
            this.getCommandManager().remove(this.m_currentSelection);
        }
        this.m_currentSelection = o;
        if (this.m_currentSelection != null) {
            this.getCommandManager().add(this.m_currentSelection);
        }
    }

    public void setMessage(String message) {
        this.m_status.setMessage(message);
    }

    void setRebinModel(BoundedRangeModel xModel, BoundedRangeModel yModel) {
        this.m_toolbarHolder.setRebinModel(xModel, yModel);
    }

    OutputStream getOutputStream(String name) {
        return this.m_JASConsoleTabbedPane.getOutputStream(name);
    }

    void setModel(BoundedRangeModel model) {
        this.m_status.setModel(model);
    }

    WindowManager getWindowManager() {
        return this.m_windowManager;
    }

    public JASPage createNewPage() {
        return this.newPage(1, 1);
    }

    public JASPage createCurrentPage() {
        Component c;
        int i = this.m_windowManager.getSelectedWindow();
        Component component = c = i < 0 ? null : this.m_windowManager.getWindow(i);
        if (i >= 0 && c instanceof JASPage) {
            return (JASPage)c;
        }
        Vector pages = this.m_windowManager.openPages(JASPage.class);
        int nPages = pages.size();
        if (nPages == 0) {
            return this.newPage(1, 1);
        }
        if (nPages == 1) {
            JASPage page = (JASPage)pages.elementAt(0);
            this.selectPage(page);
            return page;
        }
        int[] indexes = new int[nPages + 1];
        int k = 1;
        indexes[0] = -1;
        int n = this.m_windowManager.getWindowCount();
        JComboBox<String> choices = new JComboBox<String>();
        choices.addItem("Create a new window");
        for (int j = 0; j < n; ++j) {
            if (!(this.m_windowManager.getWindow(j) instanceof JASPage)) continue;
            indexes[k++] = j;
            choices.addItem(this.m_windowManager.getWindowName(j));
        }
        JPanel p = new JPanel(new BorderLayout());
        p.add("North", new JLabel("Select the page to show the data on, or click on \"Cancel\"."));
        p.add("South", choices);
        if (JOptionPane.showConfirmDialog(this, p, "Select a page", 2) == 0) {
            int h = indexes[choices.getSelectedIndex()];
            if (h == -1) {
                return this.newPage(1, 1);
            }
            this.m_windowManager.selectWindow(h);
            return this.getCurrentPage();
        }
        return null;
    }

    private void selectPage(JASPage page) {
        int i = this.m_windowManager.find(page);
        if (i >= 0) {
            this.m_windowManager.selectWindow(i);
        }
    }

    private void exit() throws JASException, IOException {
        if (this.querySaveJob()) {
            if (!this.m_noTopBottomSplitPane) {
                this.m_topBottomSplitPane.saveState();
            }
            this.m_leftRightSplitPane.saveState();
            if (this.m_job != null) {
                this.m_job.close();
            }
            if (this.getFrame().getBounds().x > 0) {
                this.userProp.setRectangle("Window", this.getFrame().getBounds());
            }
            this.userProp.setBoolean("StatusBarVisible", this.m_statusBarVisible);
            this.userProp.setStringArray("LastJobs", this.m_lastJobs);
            this.userProp.setStringArray("LastFiles", this.m_lastFiles);
            try {
                this.userProp.save();
            }
            catch (FileNotFoundException e) {
                this.error("Could not save properties", e);
            }
            this.close();
        }
    }

    public XMLMenuBuilder getXMLMenuBuilder() {
        return this.xmb;
    }

    private void readJob(File file) throws Throwable {
        this.closeCurrentJob();
    }

    private void writeJob(String file) throws IOException {
        XMLWriter xml = new XMLWriter(new FileWriter(file));
        this.m_job.setFilePath(file);
        this.m_windowManager.saveState(xml);
        xml.close();
    }

    void updateRecentFiles(File newFile) {
        try {
            this.m_lastFiles = this.userProp.updateStringArray(this.m_lastFiles, newFile.getCanonicalPath(), "MaxFileListLength");
        }
        catch (IOException e) {
            this.m_lastFiles = this.userProp.updateStringArray(this.m_lastFiles, newFile.getAbsolutePath(), "MaxFileListLength");
        }
    }

    private void updateRecentJobs(String newJob) {
        this.m_lastJobs = this.userProp.updateStringArray(this.m_lastJobs, newJob, "MaxJobsListLength");
    }

    String[] getLastJobs() {
        return this.m_lastJobs;
    }

    String[] getLastFiles() {
        return this.m_lastFiles;
    }

    void openJob(File file) {
        try {
            if (file != null && this.querySaveJob()) {
                this.readJob(file);
            }
        }
        catch (Throwable e) {
            this.error("Cannot read job file", e);
        }
    }

    public void openFile(File f) throws FileError, JASException, MalformedURLException {
        if (f.getName().endsWith(".java")) {
            this.openJavaFile(f);
        } else if (f.getName().endsWith(".javahist")) {
            this.openJavaHistFile(f);
        } else if (f.getName().endsWith(".plotml")) {
            this.openPlotMLFile(f);
        } else if (f.getName().endsWith(".html") || f.getName().endsWith(".htm")) {
            this.showHTMLPage("HTML Page", new URL("file:" + f.getAbsolutePath()), true);
        } else {
            Enumeration e = JASRegistry.elements();
            while (e.hasMoreElements()) {
                LocalDIM2 dim;
                FileFilter ff;
                Object o = e.nextElement();
                if (!(o instanceof LocalDIM2) || !(ff = (dim = (LocalDIM2)o).getFileFilter()).accept(f)) continue;
                this.openDataSet(f, dim);
                return;
            }
            int rc = JOptionPane.showConfirmDialog(this, "Unrecognised file type, open in text editor?");
            if (rc == 0) {
                this.openJavaFile(f);
            }
        }
    }

    private void openDataSet(File f, LocalDIM2 dim) throws FileError, JASException {
        try {
            if (this.m_job.getJob() instanceof LocalJob) {
                JASLocalJobBuilder ljb = new JASLocalJobBuilder((LocalJob)this.m_job.getJob());
                dim.setLocalJobBuilder(ljb);
                ljb.setDIM(dim);
                ljb.createJob(f.getCanonicalPath());
            } else if (this.querySaveJob()) {
                JASLocalJobBuilder ljb = this.getLocalJobBuilder();
                ljb.setJobName("Untitled");
                dim.setLocalJobBuilder(ljb);
                ljb.setDIM(dim);
                ljb.createJob(f.getCanonicalPath());
            }
        }
        catch (IOException x) {
            throw new FileError("Error opening file", x);
        }
    }

    private void openJavaHistFile(File f) throws FileError, JASException {
        if (!(this.m_job.getJob() instanceof LocalJob)) {
            throw new JASException("You can not read a .javahist file into a remote job");
        }
        ObjectInputStream in = null;
        try {
            NamedObject no;
            in = new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(f))));
            Object o = in.readObject();
            if (o instanceof NamedObject && (no = (NamedObject)o).getFolder() == null) {
                LocalJob local = (LocalJob)this.m_job.getJob();
                JobFolder peer = (JobFolder)local.getTreeRoot();
                peer.addNotify(no);
            }
            this.updateRecentFiles(f);
        }
        catch (Exception x) {
            throw new FileError("Error reading .javahist file", x);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void openJavaFile(File f) throws FileError {
        int n = this.m_windowManager.getWindowCount();
        for (int i = 0; i < n; ++i) {
            Component c = this.m_windowManager.getWindow(i);
            if (!(c instanceof ProgramPage)) continue;
            String path = ((ProgramPage)c).getCanonicalPath();
            try {
                if (path == null || !f.getCanonicalPath().equals(path)) continue;
                this.m_windowManager.selectWindow(i);
                this.updateRecentFiles(f);
                return;
            }
            catch (IOException e) {
                throw new FileError("Error opening java file", e);
            }
        }
        this.m_windowManager.newWindow(f.getName(), new ProgramPage(f));
        this.updateRecentFiles(f);
    }

    private void openPlotMLFile(File f) throws JASException {
        try {
            XMLHistBuilder xhb = new XMLHistBuilder(new BufferedReader(new FileReader(f)), f.getName());
            JASPage page = new JASPage(1, 1);
            xhb.modifyPlot(page.getCurrentPlot());
            this.m_windowManager.newWindow("PlotML", page);
            this.updateRecentFiles(f);
        }
        catch (Throwable t) {
            this.error("Error reading PlotML file", t);
        }
    }

    private void showHTMLPage(String title, URL url, boolean forceNewPage) {
        Vector pages = this.m_windowManager.openPages(HTMLPage.class);
        if (forceNewPage || pages.isEmpty()) {
            this.m_windowManager.newWindow(title, new HTMLPage(url));
        } else {
            HTMLPage page = (HTMLPage)pages.elementAt(0);
            page.showURL(url);
            this.m_windowManager.selectWindow(this.m_windowManager.find(page));
        }
    }

    JASLocalJobBuilder getLocalJobBuilder() {
        return new JASLocalJobBuilder();
    }

    private boolean querySaveJob() throws IOException, JASException {
        boolean windowHasChanged = this.windowHasChanged();
        boolean jobHasChanged = this.m_job.isChanged();
        if (jobHasChanged || windowHasChanged) {
            int rc = JOptionPane.showConfirmDialog(this, "Save changes to job " + this.m_job.getName() + "?", "Save Changes?", 1, 2);
            if (rc == 2) {
                return false;
            }
            if (rc == -1) {
                return false;
            }
            if (rc == 0) {
                throw new NotImplemented("Job Saving and Restoring");
            }
        }
        return true;
    }

    private boolean windowHasChanged() {
        int n = this.m_windowManager.getWindowCount();
        for (int i = 0; i < n; ++i) {
            Component c = this.m_windowManager.getWindow(i);
            if (!(c instanceof ChangableContainer) || !((ChangableContainer)((Object)c)).hasChanged()) continue;
            return true;
        }
        return false;
    }

    boolean saveJob() throws IOException {
        String file = this.m_job.getFilePath();
        if (file == null) {
            return this.saveJobAs();
        }
        this.writeJob(file);
        this.updateRecentJobs(file);
        return true;
    }

    boolean saveJobAs() throws IOException {
        JFileChooser dlg = new JFileChooser(this.userProp.getString("LastJobPath", System.getProperty("user.home")));
        dlg.setDialogTitle("Save Job As...");
        dlg.setFileFilter(new JASFileFilter());
        dlg.setSelectedFile(new File(this.m_job.getName().concat(".jas")));
        if (dlg.showSaveDialog(this.getFrame()) != 0) {
            return false;
        }
        File file = dlg.getSelectedFile();
        if (!file.getName().endsWith(".jas")) {
            file = new File(file.getAbsolutePath().concat(".jas"));
        }
        this.writeJob(file.getAbsolutePath());
        this.updateRecentJobs(file.getAbsolutePath());
        this.userProp.setString("LastJobPath", file.getParent());
        return true;
    }

    void closeCurrentJob() {
        this.m_job.close();
    }

    void setToEmptyJob() {
        String jobName = "Default Job";
        JASJob m_job = new JASJob(jobName);
        LocalJob localJob = new LocalJob(m_job, jobName);
        m_job.setJob(localJob);
        this.setJob(m_job, true);
    }

    public void setJob(JASJob job, boolean newJob) {
        if (newJob) {
            this.m_windowManager.closeAllWindows();
            this.newPage(1, 1);
        }
        this.m_job = job;
        this.m_job.setTreeModel(this.m_tree);
        this.m_job.setEventSourceModel(this.m_toolbarHolder.getEventSourceComboBox());
    }

    StoppableExecutionMonitor registerStoppable(StoppableExecution stoppable) {
        return this.m_stopMan.registerStoppable(stoppable);
    }

    public MLPArrowFactory getTheArrowFactory() {
        return null;
    }

    public MLPLabelFactory getTheLabelFactory() {
        return null;
    }

    public MoverLayeredPane getMLP() {
        return null;
    }

    public MultiFunctionPanel getMFP() {
        return null;
    }

    static /* synthetic */ void access$800(JavaAnalysisStudio x0, File x1) throws Throwable {
        x0.readJob(x1);
    }

    static {
        try {
            Class.forName("javax.media.j3d.Canvas3D");
            Class.forName("gov.fnal.plot3d.jas.SpecialLego");
            Class.forName("gov.fnal.plot3d.jas.SpecialSurface");
            if (JPopupMenu.getDefaultLightWeightPopupEnabled()) {
                JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        knownDebugFlags = new String[][]{{"loader", "Debug Class Loaders"}, {"eventDelivery", "Remote Event Delivery"}, {"caching", "Caching of Remote Data"}, {"extensions", "Extension loading"}, {"printing", "Printing"}, {"help", "Help"}, {"all", "Turn on all known debug flags"}};
    }

    private class SelectAdaptor
    implements TreeSelectionListener,
    CommandSource {
        private SimpleCommandTarget m_target;

        private SelectAdaptor() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (this.m_target != null && e.isAddedPath()) {
                this.m_target.invoke();
            }
        }

        @Override
        public String getCommand() {
            return "Select";
        }

        @Override
        public CommandTarget getTarget() {
            return this.m_target;
        }

        @Override
        public boolean setTarget(CommandTarget target) {
            if (target instanceof SimpleCommandTarget) {
                this.m_target = (SimpleCommandTarget)target;
                return true;
            }
            return false;
        }

        @Override
        public void clearTarget() {
            this.m_target = null;
        }
    }

    private class DoubleClickAdaptor
    implements MouseListener,
    CommandSource {
        private SimpleCommandTarget m_target;

        private DoubleClickAdaptor() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && this.m_target != null) {
                this.m_target.invoke();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public String getCommand() {
            return "DoubleClick";
        }

        @Override
        public CommandTarget getTarget() {
            return this.m_target;
        }

        @Override
        public boolean setTarget(CommandTarget target) {
            if (target instanceof SimpleCommandTarget) {
                this.m_target = (SimpleCommandTarget)target;
                return true;
            }
            return false;
        }

        @Override
        public void clearTarget() {
            this.m_target = null;
        }
    }

    private class FitWatcher
    implements Observer,
    StoppableExecution {
        private StoppableExecutionMonitor m_stopMonitor;
        private BoundedRangeModel model;
        private Fitter m_fitter;
        private final NumberFormat format = NumberFormat.getInstance();
        private String m_funcTitle;

        FitWatcher(Fitter fit) {
            this.format.setMaximumFractionDigits(6);
            this.model = JavaAnalysisStudio.this.m_status.getModel();
            this.model.setMinimum(0);
            this.model.setMaximum(100);
            this.m_fitter = fit;
            this.m_fitter.addObserver(this);
            this.m_stopMonitor = JavaAnalysisStudio.this.registerStoppable(this);
            this.m_funcTitle = this.m_fitter.getFunction().getTitle();
        }

        Fitter clearFit() {
            Fitter fit = this.m_fitter;
            if (fit != null) {
                fit.deleteObserver(this);
                fit.getFunction().clearFit();
                this.m_fitter = null;
                this.m_stopMonitor.end();
            }
            return fit;
        }

        @Override
        public void update(Observable obs, Object arg) {
            if (arg instanceof FitUpdate) {
                FitUpdate fu = (FitUpdate)arg;
                int state = fu.getState();
                if (state == 5) {
                    this.clearFit();
                } else {
                    this.model.setValue(fu.getPercent());
                    if (state == 2) {
                        JavaAnalysisStudio.this.setMessage("Fit failed.  Exception was: " + fu.getReason());
                        this.clearFit();
                    } else if (state == 1) {
                        JavaAnalysisStudio.this.setMessage(this.m_funcTitle + " fit complete.  \u03c7\u00b2 = " + this.format.format(this.m_fitter.getChiSquared()));
                    } else if (state == 0) {
                        JavaAnalysisStudio.this.setMessage("Now fitting function " + this.m_funcTitle);
                    }
                    this.m_stopMonitor.doStopEnabling();
                }
                if (this.m_fitter != null) {
                    this.m_fitter.getFunction().setChanged();
                }
            }
        }

        @Override
        public boolean isRunning() {
            return this.m_fitter != null && this.m_fitter.getState() == 0;
        }

        @Override
        public void stop() {
            if (this.m_fitter != null) {
                this.m_fitter.stop();
                this.m_fitter.deleteObserver(this);
                this.m_fitter.getFunction().clearFit();
                this.m_fitter = null;
                JavaAnalysisStudio.this.m_status.setMessage("Fitter stopped before completion");
                JavaAnalysisStudio.this.m_status.getModel().setValue(0);
            }
        }
    }

    private final class JASFitListener
    implements FitListener {
        private JASFitListener() {
        }

        @Override
        public void fitStarted(Fitter fitter) {
            new FitWatcher(fitter);
        }
    }

    private class JASStoppableExecutionMonitor
    implements StoppableExecutionMonitor {
        private StoppableExecution m_stoppable;

        JASStoppableExecutionMonitor(StoppableExecution stoppable) {
            this.m_stoppable = stoppable;
            this.doStopEnabling();
        }

        boolean isRunning() {
            return this.m_stoppable.isRunning();
        }

        @Override
        public void setProgressModel(BoundedRangeModel model) {
            JavaAnalysisStudio.this.m_status.setModel(model);
        }

        @Override
        public void doStopEnabling() {
            JavaAnalysisStudio.this.m_jasCommand.forceSetChanged();
        }

        @Override
        public void end() {
            JavaAnalysisStudio.this.m_stopMan.removeStoppable(this);
        }

        void stop() {
            this.m_stoppable.stop();
        }
    }

    private class JASStoppableManager {
        private Vector m_stoppables = new Vector();

        private JASStoppableManager() {
        }

        StoppableExecutionMonitor registerStoppable(StoppableExecution stoppable) {
            JASStoppableExecutionMonitor monitor = new JASStoppableExecutionMonitor(stoppable);
            this.m_stoppables.addElement(monitor);
            return monitor;
        }

        void removeStoppable(StoppableExecutionMonitor monitor) {
            this.m_stoppables.removeElement(monitor);
        }

        void stop() {
            Enumeration e = this.m_stoppables.elements();
            while (e.hasMoreElements()) {
                JASStoppableExecutionMonitor monitor = (JASStoppableExecutionMonitor)e.nextElement();
                if (!monitor.isRunning()) continue;
                monitor.stop();
            }
            JavaAnalysisStudio.this.m_jasCommand.forceSetChanged();
        }

        boolean getStopEnabled() {
            Enumeration e = this.m_stoppables.elements();
            while (e.hasMoreElements()) {
                if (!((JASStoppableExecutionMonitor)e.nextElement()).isRunning()) continue;
                return true;
            }
            return false;
        }
    }

    private class JASCommand
    extends JASCommandProcessor {
        private JASCommand() {
        }

        void forceSetChanged() {
            this.setChanged();
        }

        public void onNewJob() throws IOException, JASException {
            if (JavaAnalysisStudio.this.querySaveJob()) {
                new JASWizard(JavaAnalysisStudio.this.getFrame(), "New Job Wizard", new NewJobPage());
            }
        }

        public void onReconnect() throws ConnectFailed, IOException, JASException {
            if (JavaAnalysisStudio.this.querySaveJob()) {
                new JASWizard(JavaAnalysisStudio.this.getFrame(), "Connect to Server", new ConnectPage());
            }
        }

        public void onOpenJob() throws IOException, JASException {
            throw new NotImplemented("Saving and restoring jobs");
        }

        public void onOpen() throws FileError, JASException, MalformedURLException {
            JFileChooser dlg = new JFileChooser(JavaAnalysisStudio.this.userProp.getString("LastProgramPath", System.getProperty("user.home")));
            dlg.setDialogTitle("Open File...");
            AllSupportedFileFilter all = new AllSupportedFileFilter();
            Enumeration e = JASRegistry.elements();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (!(o instanceof LocalDIM2)) continue;
                FileFilter ff = ((LocalDIM2)o).getFileFilter();
                all.add(ff);
                dlg.addChoosableFileFilter(ff);
            }
            FileTypeFileFilter ff = new FileTypeFileFilter("html", "HTML File (*.html)");
            all.add(ff);
            dlg.addChoosableFileFilter(ff);
            ff = new FileTypeFileFilter("javahist", "Java Histogram File (*.javahist)");
            all.add(ff);
            dlg.addChoosableFileFilter(ff);
            ff = new FileTypeFileFilter("plotml", "XML Plot File (*.plotml)");
            all.add(ff);
            dlg.addChoosableFileFilter(ff);
            ff = new FileTypeFileFilter("java", "Java File (*.java)");
            all.add(ff);
            dlg.addChoosableFileFilter(ff);
            dlg.setFileFilter(all);
            if (dlg.showOpenDialog(JavaAnalysisStudio.this.getFrame()) == 0) {
                File f = dlg.getSelectedFile();
                JavaAnalysisStudio.this.userProp.setString("LastProgramPath", f.getParent());
                JavaAnalysisStudio.this.openFile(f);
            }
        }

        public void onNewProgramWizard() {
            this.onProgramUsingWizard();
        }

        public void onProgramUsingWizard() {
            new JASWizard(JavaAnalysisStudio.this.getFrame(), "New Program Page Wizard", new NewProgramPage());
        }

        public void onBlankProgramPage() {
            ProgramPage p = new ProgramPage();
            p.setClassName("Untitled");
            JavaAnalysisStudio.this.m_windowManager.newWindow("Untitled      ", p);
        }

        public void onExit() throws JASException, IOException {
            JavaAnalysisStudio.this.exit();
        }

        public void onHome() throws IOException {
            JavaAnalysisStudio.this.showHTMLPage("Welcome", JavaAnalysisStudio.this.m_homePage, false);
        }

        public void onWebPage() throws IOException {
            Vector pages = JavaAnalysisStudio.this.m_windowManager.openPages(HTMLPage.class);
            WebPageDialog dlg = new WebPageDialog((Frame)JavaAnalysisStudio.this.getFrame(), !pages.isEmpty());
            if (dlg.doModal()) {
                JavaAnalysisStudio.this.showHTMLPage("Web Page", dlg.getURL(), dlg.getNewPage());
            }
        }

        public void onStatusBar(boolean b) {
            JavaAnalysisStudio.this.setStatusBarVisible(b);
        }

        public void onOptions() {
            new JASOptionsDialog(JavaAnalysisStudio.this.getFrame());
        }

        public void onRegistries() {
            new JASRegistryDialog(JavaAnalysisStudio.this.getFrame());
        }

        public void enableStatusBar(JASCheckboxState state) {
            state.setCheckbox(JavaAnalysisStudio.this.m_statusBarVisible);
            state.setEnabled(true);
        }

        public void onAbout() {
            AboutBox dlg = new AboutBox(JavaAnalysisStudio.this.getFrame());
            ((Dialog)dlg).show();
        }

        public void onSubmitBugReport() throws MalformedURLException, IOException {
            URL bugURL = new URL("http://www-sldnt.slac.stanford.edu/jas/bugs/bugreport_form.asp");
            JavaAnalysisStudio.this.showHTMLPage("Bug Report", bugURL, true);
        }

        public void onReleaseNotes() throws MalformedURLException, IOException {
            JavaAnalysisStudio.this.showHelpTopic("relnotes");
        }

        public void onCheckVersion() {
            JASVersion checkversion = new JASVersion(JavaAnalysisStudio.this.getFrame(), "JAS", JavaAnalysisStudio.versionURL, JavaAnalysisStudio.getVersionNumber(), JavaAnalysisStudio.this.userProp);
            checkversion.showOptionsDialog();
        }

        public void onPluginManager() {
            if (JavaAnalysisStudio.this.pluginmanager.getReadPluginXMLOK()) {
                JavaAnalysisStudio.this.pluginmanager.showPluginManager(JavaAnalysisStudio.this.getFrame());
            } else {
                JavaAnalysisStudio.this.pluginmanager.initializePluginList();
                if (JavaAnalysisStudio.this.pluginmanager.getReadPluginXMLOK()) {
                    JavaAnalysisStudio.this.pluginmanager.showPluginManager(JavaAnalysisStudio.this.getFrame());
                }
            }
        }

        public void onTutorial() throws MalformedURLException, IOException {
            JavaAnalysisStudio.this.showHelpTopic("tutorial.part1");
        }

        public void onWelcome() throws MalformedURLException, IOException {
            JavaAnalysisStudio.this.showHelpTopic("tutorial.jasintro");
        }

        public void onHelpContents() throws MalformedURLException, IOException {
            JavaAnalysisStudio.this.showHelpContents();
        }

        public void onSearch() throws MalformedURLException, IOException {
            JavaAnalysisStudio.this.showHelpSearch();
        }

        public void onHelpIndex() throws MalformedURLException, IOException {
            JavaAnalysisStudio.this.showHelpIndex();
        }

        public void onheppackages() throws MalformedURLException, IOException {
            JavaAnalysisStudio.this.showHelpTopic("API.hepPackages.packageList");
        }

        public void onjaspackages() throws MalformedURLException, IOException {
            JavaAnalysisStudio.this.showHelpTopic("API.jasPackages.packageList");
        }

        public void enableTabbedPanels(JASCheckboxState state) {
            this.enableWM(state, JavaAnalysisStudio.m_TabbedWM);
        }

        public void onTabbedPanels() {
            this.setWM(JavaAnalysisStudio.m_TabbedWM);
        }

        public void enableInternalFrames(JASCheckboxState state) {
            this.enableWM(state, JavaAnalysisStudio.m_InternalWM);
        }

        public void onInternalFrames() {
            this.setWM(JavaAnalysisStudio.m_InternalWM);
        }

        private void enableWM(JASCheckboxState state, String name) {
            state.setCheckbox(JavaAnalysisStudio.this.m_windowManager.getClass().getName().equals(name));
            try {
                state.setEnabled(Class.forName(name) != null);
            }
            catch (Exception e) {
                state.setEnabled(false);
            }
        }

        private void setWM(String name) {
            if (JavaAnalysisStudio.this.m_windowManager.getClass().getName().equals(name)) {
                return;
            }
            WindowManager oldManager = JavaAnalysisStudio.this.m_windowManager;
            WindowItem[] wa = oldManager.getItems();
            Vector l = oldManager.getPageListeners();
            try {
                JavaAnalysisStudio.this.m_windowManager = (WindowManager)Class.forName(name).newInstance();
                JComponent c = (JComponent)((Object)JavaAnalysisStudio.this.m_windowManager);
                c.setMinimumSize(new Dimension(40, 40));
                JavaAnalysisStudio.this.m_leftRightSplitPane.setRightComponent(c);
                JavaAnalysisStudio.this.m_leftRightSplitPane.validate();
                c.repaint();
                JavaAnalysisStudio.this.userProp.setString("WindowManager", name);
                JavaAnalysisStudio.this.m_windowManager.initialize(wa, l);
            }
            catch (Exception e) {
                JavaAnalysisStudio.this.error("Could not open window manager " + name, e);
                JavaAnalysisStudio.this.m_windowManager = oldManager;
            }
            this.setChanged();
        }

        public void enableWindows(JASCheckboxState state) {
            this.enableLAF(state, JavaAnalysisStudio.m_WindowsLAF);
        }

        public void onWindows() throws Exception {
            this.onLAF(JavaAnalysisStudio.m_WindowsLAF);
        }

        public void enableMotif(JASCheckboxState state) {
            this.enableLAF(state, JavaAnalysisStudio.m_MotifLAF);
        }

        public void onMotif() throws Exception {
            this.onLAF(JavaAnalysisStudio.m_MotifLAF);
        }

        public void enableJava(JASCheckboxState state) {
            this.enableLAF(state, JavaAnalysisStudio.m_JavaLAF);
        }

        public void onJava() throws Exception {
            this.onLAF(JavaAnalysisStudio.m_JavaLAF);
        }

        private void enableLAF(JASCheckboxState state, String lafName) {
            try {
                Class<?> c = Class.forName(lafName);
                LookAndFeel laf = (LookAndFeel)c.newInstance();
                state.setCheckbox(UIManager.getLookAndFeel().getName().equals(laf.getName()));
                state.setEnabled(laf.isSupportedLookAndFeel());
            }
            catch (Exception e) {
                state.setEnabled(false);
            }
        }

        private void onLAF(String lafName) throws Exception {
            UIManager.setLookAndFeel(lafName);
            SwingUtilities.updateComponentTreeUI(JavaAnalysisStudio.this.getFrame());
            JavaAnalysisStudio.this.userProp.put("LookAndFeel", lafName);
            this.setChanged();
        }

        public void onEnableToolTips(boolean value) {
            ToolTipManager.sharedInstance().setEnabled(value);
            JavaAnalysisStudio.this.userProp.setBoolean("EnableToolTips", value);
        }

        public void enableEnableToolTips(JASCheckboxState state) {
            state.setCheckbox(ToolTipManager.sharedInstance().isEnabled());
            state.setEnabled(true);
        }

        public void enableFullScreen(JASState state) {
            state.setEnabled(JavaAnalysisStudio.this.getWindowManager().getSelectedWindow() >= 0);
        }

        public void onFullScreen() {
            JavaAnalysisStudio.this.getWindowManager().doFullScreen();
        }

        public void on1x1() {
            JavaAnalysisStudio.this.newPage(1, 1);
        }

        public void on1x2() {
            JavaAnalysisStudio.this.newPage(1, 2);
        }

        public void on2x1() {
            JavaAnalysisStudio.this.newPage(2, 1);
        }

        public void on2x2() {
            JavaAnalysisStudio.this.newPage(2, 2);
        }

        public void on3x3() {
            JavaAnalysisStudio.this.newPage(3, 3);
        }

        public void on4x4() {
            JavaAnalysisStudio.this.newPage(4, 4);
        }

        public void onStop() {
            JavaAnalysisStudio.this.m_stopMan.stop();
        }

        public void enableStop(JASState state) {
            state.setEnabled(JavaAnalysisStudio.this.m_stopMan.getStopEnabled());
        }
    }

    protected static final class AppCloser
    extends WindowAdapter {
        AppCloser() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            JavaAnalysisStudio app = JavaAnalysisStudio.getApp();
            try {
                app.exit();
            }
            catch (IOException x) {
                app.error("Error during window close", x);
            }
            catch (JASException x) {
                app.error("Error during window close", x);
            }
        }
    }
}

