/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.plot.HasPopupItems;
import jas2.plugin.PageContext;
import jas2.plugin.PageEvent;
import jas2.plugin.PageListener;
import jas2.swingstudio.Closable;
import jas2.swingstudio.FullScreenWindow;
import jas2.swingstudio.HasCommandProcessor;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.PageListenerInfo;
import jas2.swingstudio.WindowItem;
import jas2.swingstudio.WindowManager;
import jas2.util.xml.HasXMLRepresentation;
import jas2.util.xml.XMLWriter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

final class JASWindowManager
extends JTabbedPane
implements WindowManager,
HasPopupItems {
    private Component fullScreen = null;
    private Vector m_listeners;
    private boolean m_changed = false;
    private Component prevSelected;
    private final JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();

    JASWindowManager() {
    }

    @Override
    public void closeAllWindows() {
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            if (this.closeWindow(i)) continue;
            return;
        }
        int n = this.getTabCount();
        if (n == 0) {
            this.m_app.setNPages(0);
        }
    }

    @Override
    public boolean closeWindow(int i) {
        Component c = this.getWindow(i);
        try {
            if (c instanceof Closable && !((Closable)((Object)c)).pleaseClose()) {
                return false;
            }
        }
        catch (Exception e) {
            this.m_app.error("Error closing window", e);
            return false;
        }
        this.firePageClosed(this.getWindow(i));
        this.firePageSelected(this.getWindow(this.getSelectedWindow()));
        this.detachWindow(i);
        if (this.getTabCount() == 0) {
            this.m_app.setNPages(0);
        }
        return true;
    }

    private Component detachWindow(int i) {
        Component c = this.getWindow(i);
        this.removeTabAt(i);
        this.getLayout().layoutContainer(this);
        c.setVisible(true);
        this.repaint();
        this.m_changed = true;
        return c;
    }

    @Override
    public void doFullScreen() {
        Component c;
        int index = this.getSelectedWindow();
        final String name = this.getWindowName(index);
        this.fullScreen = c = this.detachWindow(index);
        final FullScreenWindow w = new FullScreenWindow(this.m_app.getFrame(), (JComponent)c);
        w.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                w.dispose();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                JASWindowManager.this.fullScreen = null;
                JASWindowManager.this.newWindow(name, c);
            }
        });
    }

    @Override
    public Component getWindow(int i) {
        return this.getComponentAt(i);
    }

    @Override
    public String getWindowName(int i) {
        return this.getTitleAt(i);
    }

    @Override
    public void newWindow(String name, final Component c) {
        int i = this.getTabCount();
        this.addTab(name, c);
        this.setSelectedIndex(i);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public final void run() {
                JASWindowManager.this.firePageSelected(c);
            }
        });
        this.m_changed = true;
    }

    @Override
    public Vector openPages(Class pageClass) {
        Vector<Component> result = new Vector<Component>();
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            Component c = this.getComponentAt(i);
            if (pageClass != null && !pageClass.isInstance(c)) continue;
            result.addElement(c);
        }
        return result;
    }

    @Override
    public void initialize(WindowItem[] wa, Vector listeners) {
        this.m_listeners = listeners;
        this.closeAllWindows();
        int nPages = 0;
        for (int i = 0; i < wa.length; ++i) {
            String name = wa[i].name;
            this.newWindow(name, wa[i].Component);
            if (!name.startsWith("Page ")) continue;
            ++nPages;
        }
        this.m_app.setNPages(nPages);
        this.m_changed = false;
    }

    @Override
    public WindowItem[] getItems() {
        WindowItem[] wa = new WindowItem[this.getTabCount()];
        for (int i = 0; i < wa.length; ++i) {
            wa[i] = new WindowItem(this.getTitleAt(i), this.getComponentAt(i));
        }
        return wa;
    }

    @Override
    public void selectWindow(int i) {
        this.setSelectedIndex(i);
        this.m_changed = true;
    }

    @Override
    public int getSelectedWindow() {
        return this.getSelectedIndex();
    }

    @Override
    public int getWindowCount() {
        return this.getTabCount();
    }

    @Override
    public void setCurrentTitle(String s) {
        this.setTitleAt(this.getSelectedIndex(), s);
        this.repaint();
        this.m_changed = true;
    }

    @Override
    public void fireStateChanged() {
        int i;
        if (this.prevSelected instanceof HasCommandProcessor) {
            this.m_app.getCommandManager().remove(((HasCommandProcessor)((Object)this.prevSelected)).getCommandProcessor());
        }
        if ((i = this.getSelectedIndex()) >= 0) {
            this.prevSelected = this.getSelectedComponent();
            if (this.prevSelected instanceof HasCommandProcessor) {
                this.m_app.getCommandManager().add(((HasCommandProcessor)((Object)this.prevSelected)).getCommandProcessor());
            }
        }
        super.fireStateChanged();
    }

    @Override
    public void saveState(XMLWriter xml) {
        Component c;
        int i;
        int selected = -1;
        int count = 0;
        int n = this.getTabCount();
        for (i = 0; i < n; ++i) {
            c = this.getWindow(i);
            if (!(c instanceof HasXMLRepresentation)) continue;
            ++count;
            if (i != this.getSelectedIndex()) continue;
            selected = i;
        }
        xml.setAttribute("count", count);
        if (selected >= 0) {
            xml.setAttribute("selected", selected);
        }
        xml.openTag("windows");
        for (i = 0; i < n; ++i) {
            c = this.getWindow(i);
            if (!(c instanceof HasXMLRepresentation)) continue;
            xml.setAttribute("name", this.getWindowName(i));
            xml.openTag("window");
            ((HasXMLRepresentation)((Object)c)).writeAsXML(xml);
            xml.closeTag();
        }
        xml.closeTag();
        this.m_changed = false;
    }

    @Override
    public boolean windowListChanged() {
        return this.m_changed;
    }

    @Override
    public void modifyPopupMenu(JPopupMenu menu, Component source) {
        menu.add(new JSeparator());
        menu.add(new JMenuItem("Close window"){

            @Override
            protected final void fireActionPerformed(ActionEvent e) {
                JASWindowManager.this.closeWindow(JASWindowManager.this.getSelectedIndex());
            }
        });
    }

    @Override
    public int find(Component c) {
        int n = this.getWindowCount();
        for (int i = 0; i < n; ++i) {
            if (this.getWindow(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addPageListener(Component Component2, PageListener listener, PageContext context) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector(4, 2);
        }
        this.m_listeners.addElement(new PageListenerInfo(Component2, listener, context));
    }

    @Override
    public void removePageListener(PageListener listener) {
        if (this.m_listeners != null) {
            int n = this.m_listeners.size();
            int i = 0;
            while (i < n) {
                PageListenerInfo info = (PageListenerInfo)this.m_listeners.elementAt(i);
                if (info.listener == listener) {
                    this.m_listeners.removeElementAt(i);
                    --n;
                    continue;
                }
                ++i;
            }
        }
    }

    private void removeListenersForComponent(Component c) {
        if (this.m_listeners != null) {
            int n = this.m_listeners.size();
            int i = 0;
            while (i < n) {
                PageListenerInfo info = (PageListenerInfo)this.m_listeners.elementAt(i);
                if (info.Component == c) {
                    this.m_listeners.removeElementAt(i);
                    --n;
                    continue;
                }
                ++i;
            }
        }
    }

    private void firePageClosed(Component c) {
        this.notifyListenersForComponent(c, 4001);
        this.removeListenersForComponent(c);
    }

    private void firePageSelected(Component c) {
        if (c instanceof Closable) {
            ((Closable)((Object)c)).pageSelected(true);
        }
        this.notifyListenersForComponent(c, 3999);
    }

    private void firePageDeselected(Component c) {
        if (c instanceof Closable) {
            ((Closable)((Object)c)).pageSelected(false);
        }
        this.notifyListenersForComponent(c, 4000);
    }

    private void notifyListenersForComponent(Component c, int id) {
        if (this.m_listeners != null) {
            Enumeration e = this.m_listeners.elements();
            while (e.hasMoreElements()) {
                PageListenerInfo info = (PageListenerInfo)e.nextElement();
                if (info.Component != c) continue;
                info.listener.pageChanged(new PageEvent(info.context, id));
            }
        }
    }

    @Override
    public void setSelectedIndex(int i) {
        int old = this.getSelectedWindow();
        if (old >= 0) {
            this.firePageDeselected(this.getWindow(old));
        }
        super.setSelectedIndex(i);
        if (i >= 0) {
            this.firePageSelected(this.getWindow(i));
        }
    }

    @Override
    public Vector getPageListeners() {
        return this.m_listeners;
    }
}

