/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.hist.HasScatterPlotData;
import jas2.hist.ScatterEnumeration;
import jas2.jds.interfaces.Remote2DHistogramInfo;
import jas2.jds.interfaces.RemoteScatterEnumeration;
import jas2.jds.interfaces.RemoteScatterInfo;
import jas2.jds.interfaces.RemoteScatterSource;
import jas2.swingstudio.JAS2DRebinAdaptor;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.util.rmi.RMIDestination;
import jas2.util.rmi.RMIEventDelivery;
import java.rmi.RemoteException;

final class JASScatterAdaptor
extends JAS2DRebinAdaptor
implements HasScatterPlotData {
    private final RemoteScatterSource m_remote;

    JASScatterAdaptor(RemoteScatterSource remote, RMIDestination obs, RMIEventDelivery ed) {
        super(remote, obs, ed);
        this.m_remote = remote;
    }

    @Override
    public boolean hasScatterPlotData() {
        Remote2DHistogramInfo myinfo = this.info;
        if (myinfo == null) {
            myinfo = this.setInfo();
        }
        return ((RemoteScatterInfo)myinfo).m_hasScatterPlotData;
    }

    @Override
    public synchronized ScatterEnumeration startEnumeration(double xMin, double xMax, double yMin, double yMax) {
        try {
            RemoteScatterEnumeration remote = this.m_remote.startEnumeration(xMin, xMax, yMin, yMax);
            JASScatterEnumerationAdaptor enum1 = new JASScatterEnumerationAdaptor(remote, xMin, xMax, yMin, yMax);
            return enum1;
        }
        catch (RemoteException e) {
            JavaAnalysisStudio.getApp().error("Remote exception, could not get points.", e);
            return null;
        }
    }

    @Override
    public synchronized ScatterEnumeration startEnumeration() {
        double xMin = this.getXMin();
        double xMax = this.getXMax();
        double yMin = this.getYMin();
        double yMax = this.getYMax();
        return this.startEnumeration(xMin, xMax, yMin, yMax);
    }

    private final class JASScatterEnumerationAdaptor
    implements ScatterEnumeration {
        private final RemoteScatterEnumeration m_remote;
        private short[] m_points;
        private int m_index;
        private final double xMin;
        private final double yMin;
        private final double xDiff;
        private final double yDiff;
        boolean m_isValid = true;
        private final short[] m_cache = new short[1000];
        private int m_nInCache = 0;

        JASScatterEnumerationAdaptor(RemoteScatterEnumeration remote, double xMin, double xMax, double yMin, double yMax) {
            this.m_remote = remote;
            this.xMin = xMin;
            this.yMin = yMin;
            this.xDiff = xMax - xMin;
            this.yDiff = yMax - yMin;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getNextPoint(double[] a) {
            if (!this.m_isValid) {
                return false;
            }
            if (this.m_points == null || this.m_points == this.m_cache && this.m_index >= this.m_nInCache || this.m_index >= this.m_points.length) {
                this.m_index = 0;
                try {
                    JASScatterAdaptor jASScatterAdaptor = JASScatterAdaptor.this;
                    synchronized (jASScatterAdaptor) {
                        if (!this.m_isValid) {
                            return false;
                        }
                        this.m_points = this.m_remote.getNextPoints();
                        if (this.m_points == null) {
                            return false;
                        }
                        int numberToCopy = Math.min(this.m_cache.length - this.m_nInCache, this.m_points.length);
                        if (numberToCopy > 0) {
                            System.arraycopy(this.m_points, 0, this.m_cache, this.m_nInCache, numberToCopy);
                            this.m_nInCache += numberToCopy;
                        }
                    }
                }
                catch (RemoteException e) {
                    JavaAnalysisStudio.getApp().error("Remote exception, points may be lost.", e);
                    return false;
                }
            }
            a[0] = this.xMin + this.xDiff * (double)this.m_points[this.m_index++] / 32767.0;
            a[1] = this.yMin + this.yDiff * (double)this.m_points[this.m_index++] / 32767.0;
            return true;
        }

        @Override
        public void resetEndPoint() {
            try {
                this.m_remote.resetEndPoint();
            }
            catch (RemoteException e) {
                JavaAnalysisStudio.getApp().error("Remote exception, points may be lost.", e);
            }
        }

        @Override
        public void restart() {
            try {
                this.m_remote.restart(this.m_nInCache);
            }
            catch (RemoteException e) {
                JavaAnalysisStudio.getApp().error("Remote exception, points may be lost.", e);
            }
            finally {
                this.m_points = this.m_cache;
                this.m_index = 0;
            }
        }
    }
}

