/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.hist.FunctionFactory;
import jas2.swingstudio.FitterListModel;
import jas2.swingstudio.FunctionListModel;
import jas2.swingstudio.LocalDIMListModel;
import jas2.swingstudio.OptionsAddRemovePanel;
import jas2.swingstudio.OptionsDialog;
import jas2.swingstudio.OptionsPage;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

final class JASRegistryDialog
extends OptionsDialog {
    JASRegistryDialog(Frame f) {
        super(f, "Registries...");
        this.addPage("Function registry", new Functions());
        this.addPage("Fitter registry", new Fitters());
        this.addPage("Local DIM registry", new DIMs());
        this.pack();
        this.m_init = true;
        this.show();
    }

    private final class DIMs
    extends OptionsPage {
        private OptionsAddRemovePanel panel;

        DIMs() {
            super(new GridLayout(1, 1));
            this.panel = new OptionsAddRemovePanel(new LocalDIMListModel(), "Local DIMs in registry", "Local DIM registry");
            this.panel.addListDataListener(JASRegistryDialog.this);
            this.add(this.panel);
        }

        @Override
        void apply() {
            this.panel.update();
        }

        @Override
        String getHelpTopic() {
            return "functionsAndFilters.registries";
        }
    }

    private final class Fitters
    extends OptionsPage {
        private OptionsAddRemovePanel panel;

        Fitters() {
            super(new GridLayout(1, 1));
            this.panel = new OptionsAddRemovePanel(new FitterListModel(), "Fitters in fitter registry", "Fitter registry");
            this.panel.addListDataListener(JASRegistryDialog.this);
            this.add(this.panel);
        }

        @Override
        void apply() {
            this.panel.update();
        }

        @Override
        String getHelpTopic() {
            return "functionsAndFilters.registries";
        }
    }

    private final class Functions
    extends OptionsPage {
        private OptionsAddRemovePanel panel;

        Functions() {
            super(new GridLayout(1, 1));
            this.panel = new OptionsAddRemovePanel(new FunctionListModel(), "Function in function registry", "Function registry", new DataRenderer());
            this.panel.addListDataListener(JASRegistryDialog.this);
            this.add(this.panel);
        }

        @Override
        void apply() {
            this.panel.update();
        }

        @Override
        String getHelpTopic() {
            return "functionsAndFilters.registries";
        }

        private final class DataRenderer
        extends DefaultListCellRenderer {
            private DataRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String s = value instanceof FunctionFactory ? ((FunctionFactory)value).getFunctionName() : value.toString();
                return super.getListCellRendererComponent((JList<?>)list, s, index, isSelected, cellHasFocus);
            }
        }
    }
}

