/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import hepjas.analysis.EventSource;
import jas2.jds.module.LocalDIM;
import jas2.jds.module.LocalJobBuilder;
import jas2.jds.module.ModuleException;
import jas2.swingstudio.JASJob;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.LocalJob;
import javax.swing.BoundedRangeModel;

class JASLocalJobBuilder
implements LocalJobBuilder {
    private LocalJob m_job;
    private LocalDIM m_dim;
    private final JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();
    private String m_jobName;

    JASLocalJobBuilder() {
    }

    JASLocalJobBuilder(LocalJob job) {
        this.m_job = job;
    }

    void setJobName(String jobName) {
        this.m_jobName = jobName;
    }

    void setDIM(LocalDIM dim) {
        this.m_dim = dim;
    }

    @Override
    public void createJob(String dataSource) {
        if (this.m_job == null) {
            this.m_app.closeCurrentJob();
            JASJob jasJob = new JASJob(this.m_jobName);
            this.m_job = new LocalJob(jasJob, this.m_jobName, this.m_dim, dataSource);
            try {
                this.m_job.open();
                jasJob.setJob(this.m_job);
                this.m_app.setJob(jasJob, true);
            }
            catch (ModuleException e) {
                this.m_app.closeCurrentJob();
                this.m_app.setToEmptyJob();
                this.m_app.error("Could not open job.", e);
            }
        } else {
            try {
                EventSource es = this.m_dim.openDataSet(dataSource);
                if (es != null) {
                    this.m_job.setEventSource(es);
                }
            }
            catch (ModuleException e) {
                this.m_app.error("Could not open dataset.", e);
            }
        }
    }

    @Override
    public void setEventSource(EventSource source) {
        this.m_job.setEventSource(source);
    }

    @Override
    public void setMessage(String message) {
        this.m_app.setMessage(message);
    }

    @Override
    public void setProgressModel(BoundedRangeModel model) {
        this.m_app.setModel(model);
    }

    @Override
    public void clearProgressModel() {
        this.m_app.setModel(null);
    }
}

