/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import hepjas.analysis.EventData;
import jas2.job.LoaderException;
import jas2.job.OpenJobException;
import jas2.plugin.IPlugin;
import jas2.plugin.NoEventAvailable;
import jas2.plugin.PluginContext;
import jas2.plugin.RunListener;
import jas2.swingstudio.JASCommandProcessor;
import jas2.swingstudio.JASException;
import jas2.swingstudio.JASJobAdaptor;
import jas2.swingstudio.JASLocalJobBuilder;
import jas2.swingstudio.JASPluginContext;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.Job;
import jas2.swingstudio.LoadDialog;
import jas2.swingstudio.LoadPluginDialog;
import jas2.swingstudio.LocalJob;
import jas2.swingstudio.LocalJobPage;
import jas2.swingstudio.NotImplemented;
import jas2.swingstudio.OpenDataSetPage;
import jas2.swingstudio.StoppableExecution;
import jas2.swingstudio.StoppableExecutionMonitor;
import jas2.swingstudio.TreeAdaptor;
import jas2.swingstudio.TreeAdaptorSite;
import jas2.util.ImageException;
import jas2.util.JASCheckboxState;
import jas2.util.JASIcon;
import jas2.util.JASState;
import jas2.util.JASWizard;
import jas2.util.tree.OrderedNode;
import jas2.util.tree.SimpleNode;
import jas2.util.tree.SimpleTreeModel;
import jas2.util.tree.TreeItem;
import jas2.util.tree.TreeObjectSource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class JASJob
implements Serializable,
TreeSelectionListener,
StoppableExecution,
TreeObjectSource,
ActionListener {
    static final long serialVersionUID = 8830773281026894908L;
    private String m_name;
    private Job m_job;
    private transient TreeModel m_treeModel = null;
    private transient DefaultTreeCellRenderer m_treeRenderer;
    private transient ListCellRenderer m_listRenderer;
    private transient String m_filePath = null;
    private transient int m_changes = 0;
    private transient boolean m_connected = false;
    private transient TreeNode m_root;
    private transient JASJobCommandProcessor m_command;
    private transient StoppableExecutionMonitor m_stopMonitor;
    private transient JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();
    private transient ComboModel m_eventSourceModel = new ComboModel();
    private transient Vector m_plugins = new Vector();
    private transient Vector m_pluginMenus = new Vector();
    private transient PluginContext m_pluginContext = new JobPluginContext(this.m_app);
    private transient JTree m_tree;
    private transient JComboBox m_combo;

    public JASJob(String name) {
        this.m_name = name;
        this.m_root = new TreeNode(name, "Job");
        this.m_command = new JASJobCommandProcessor();
        this.m_treeModel = new SimpleTreeModel(this.m_root);
        this.m_treeRenderer = new JASTreeCellRenderer();
        this.m_listRenderer = new JASListCellRenderer();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.m_job.eventsAnalyzed());
        stream.writeBoolean(this.m_job.isAtEndOfData());
        this.m_changes = 0;
        this.m_command.forceSetChanged();
    }

    private void readObject(ObjectInputStream stream) throws OpenJobException {
        try {
            this.m_treeRenderer = new JASTreeCellRenderer();
            this.m_eventSourceModel = new ComboModel();
            this.m_listRenderer = new JASListCellRenderer();
            this.m_plugins = new Vector();
            this.m_pluginMenus = new Vector();
            this.m_pluginContext = new JobPluginContext(this.m_app);
            stream.defaultReadObject();
            this.m_root = new TreeNode(this.m_name, "Job");
            this.m_treeModel = new SimpleTreeModel(this.m_root);
            this.m_job.reopen(stream, this);
            this.m_app = JavaAnalysisStudio.getApp();
            this.m_changes = 0;
            this.m_command = new JASJobCommandProcessor();
            this.m_command.setChanged();
            this.m_app.getCommandManager().add(this.m_command);
            this.m_stopMonitor = this.m_app.registerStoppable(this);
        }
        catch (Exception e) {
            throw new OpenJobException(e);
        }
        this.m_changes = 0;
    }

    private void addPlugin(IPlugin p) {
        this.m_plugins.addElement(p);
        p.setPluginContext(this.m_pluginContext);
    }

    void loadPlugin(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class pc = this.loadClientClass(className);
        IPlugin plugin = (IPlugin)pc.newInstance();
        this.addPlugin(plugin);
    }

    Class loadClientClass(String className) throws ClassNotFoundException {
        return this.m_job.loadClientClass(className);
    }

    void close() {
        if (this.m_job != null) {
            this.m_job.close();
        }
        if (this.m_command != null) {
            this.m_app.getCommandManager().remove(this.m_command);
        }
        this.m_job = null;
        this.m_command = null;
        if (this.m_stopMonitor != null) {
            this.m_stopMonitor.end();
        }
        this.clearTreeModel();
        this.clearEventSourceModel();
        this.m_app.setCurrentSelection(null);
        Enumeration e = this.m_plugins.elements();
        while (e.hasMoreElements()) {
            IPlugin p = (IPlugin)e.nextElement();
            p.destroy();
        }
        JMenuBar menuBar = this.m_app.getMenuBar();
        e = this.m_pluginMenus.elements();
        while (e.hasMoreElements()) {
            JMenu menu = (JMenu)e.nextElement();
            menuBar.remove(menu);
        }
        menuBar.revalidate();
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        rt.runFinalization();
    }

    void reload() throws RemoteException, LoaderException {
        if (this.m_job != null) {
            this.m_job.reload();
        }
        ++this.m_changes;
        this.m_command.forceSetChanged();
    }

    String getName() {
        return this.m_name;
    }

    void setFilePath(String path) {
        this.m_filePath = path;
    }

    String getFilePath() {
        return this.m_filePath;
    }

    public void setJob(Job job) {
        this.m_job = job;
        this.m_app.getCommandManager().add(this.m_command);
        this.m_stopMonitor = this.m_app.registerStoppable(this);
    }

    public boolean isChanged() {
        return this.m_changes > 0 || this.m_job != null && this.m_job.isChanged();
    }

    void setTreeModel(JTree tree) {
        if (this.m_tree != null) {
            this.m_tree.getSelectionModel().removeTreeSelectionListener(this);
            this.m_tree.removeTreeSelectionListener((TreeSelectionListener)((Object)this.m_tree.getCellEditor()));
        }
        this.m_tree = tree;
        if (tree != null) {
            tree.setModel(this.m_treeModel);
            tree.setCellRenderer(this.m_treeRenderer);
            tree.setCellEditor(new JASTreeCellEditor(tree, this.m_treeRenderer));
            tree.getSelectionModel().addTreeSelectionListener(this);
        }
    }

    private void clearTreeModel() {
        this.setTreeModel(null);
    }

    void setEventSourceModel(JComboBox combo) {
        if (this.m_combo != null) {
            this.m_combo.removeActionListener(this);
        }
        this.m_combo = combo;
        if (combo != null) {
            combo.setModel(this.m_eventSourceModel);
            combo.setRenderer(this.m_listRenderer);
            combo.addActionListener(this);
        }
    }

    private void clearEventSourceModel() {
        this.setEventSourceModel(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreeNode node = (TreeNode)this.m_combo.getSelectedItem();
        if (node != null) {
            this.m_job.setEventSource(node.getTreeItem());
        }
    }

    void updateTree() {
        ++this.m_changes;
        if (this.m_command != null) {
            this.m_command.forceSetChanged();
        }
    }

    void setCommandChanged() {
        if (this.m_command != null) {
            this.m_command.setChanged();
        }
    }

    Job getJob() {
        return this.m_job;
    }

    ComboBoxModel getComboModel() {
        return this.m_eventSourceModel;
    }

    ListCellRenderer getListRenderer() {
        return this.m_listRenderer;
    }

    @Override
    public void stop() {
        this.m_job.stop();
        this.m_stopMonitor.doStopEnabling();
    }

    @Override
    public boolean isRunning() {
        return this.m_job.isRunning();
    }

    void addNode(TreeItem item) {
        TreeNode node = (TreeNode)this.m_root.add(item);
        if ((item.flags & 0x20000) != 0) {
            this.m_eventSourceModel.addElement(node);
        }
        node.update();
    }

    void deleteNode(TreeItem item) {
        TreeNode node = (TreeNode)this.m_root.find(item);
        this.deleteEventSource(node);
        node.destroy();
    }

    private void deleteEventSource(TreeNode node) {
        this.m_eventSourceModel.removeElement(node);
        Enumeration e = node.children();
        if (e != null) {
            while (e.hasMoreElements()) {
                this.deleteEventSource((TreeNode)e.nextElement());
            }
        }
    }

    private Object getAssociatedObject(TreeNode node) {
        return this.m_job.getItem(this.getTreeItem(node));
    }

    private TreeItem getTreeItem(TreeNode node) {
        return node.getTreeItem(this.m_root);
    }

    @Override
    public Object getItem(TreeItem item) {
        return this.m_job.getItem(item);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreeNode sel = (TreeNode)e.getPath().getLastPathComponent();
        TreeAdaptor a = sel.getTreeAdaptor();
        this.m_app.setCurrentSelection(a);
    }

    public void loadClass(String name) {
        try {
            this.m_job.loadObject(name);
            ++this.m_changes;
            this.setCommandChanged();
        }
        catch (LoaderException e) {
            this.m_app.error("Could not load class", e);
        }
    }

    boolean isLoaded(String className) {
        return this.m_job.isLoaded(className);
    }

    class JASJobCommandProcessor
    extends JASCommandProcessor {
        JASJobCommandProcessor() {
        }

        public void onOpenDataset() {
            if (JASJob.this.m_job instanceof JASJobAdaptor) {
                new JASWizard(JASJob.this.m_app.getFrame(), "New Dataset", new OpenDataSetPage((JASJobAdaptor)JASJob.this.m_job, JASJob.this.m_app));
            } else {
                new JASWizard(JASJob.this.m_app.getFrame(), "New Dataset", new LocalJobPage(new JASLocalJobBuilder((LocalJob)JASJob.this.m_job)));
            }
        }

        public void onLoadProgram() {
            LoadDialog dlg = new LoadDialog(JASJob.this.m_app.getFrame());
            if (dlg.doModal()) {
                JASJob.this.loadClass(dlg.getClassName());
            }
        }

        public void onLoadPlugin() {
            LoadPluginDialog dlg = new LoadPluginDialog(JASJob.this.m_app.getFrame());
            if (dlg.doModal()) {
                try {
                    JASJob.this.loadPlugin(dlg.getClassName());
                }
                catch (Exception e) {
                    JASJob.this.m_app.error("Could not load plugin", e);
                }
            }
        }

        public void onUnloadAllPrograms() throws RemoteException {
            JASJob.this.m_job.unloadAll();
            JASJob.this.m_changes++;
            this.setChanged();
        }

        public void onSaveJob() throws IOException, JASException {
            JASJob.this.m_app;
            throw new NotImplemented("Saving and restoring jobs");
        }

        public void onSaveJobAs() throws IOException, JASException {
            JASJob.this.m_app;
            throw new NotImplemented("Saving and restoring jobs");
        }

        public void onCloseCurrentJob() {
            JASJob.this.m_app.closeCurrentJob();
            JASJob.this.m_app.setToEmptyJob();
        }

        public void enableDisconnect(JASState state) {
            state.setEnabled(JASJob.this.m_job instanceof JASJobAdaptor);
        }

        public void onDisconnect() throws RemoteException {
            ((JASJobAdaptor)JASJob.this.m_job).disconnect();
            JASJob.this.m_job = null;
            JASJob.this.m_app.closeCurrentJob();
            JASJob.this.m_app.setToEmptyJob();
        }

        public void onKill() throws RemoteException {
            JASJob.this.m_job.kill();
        }

        public void onRewind() throws RemoteException {
            JASJob.this.m_job.rewind();
        }

        public void onStep() throws RemoteException {
            JASJob.this.m_job.go(1);
        }

        public void onGo() throws RemoteException {
            JASJob.this.m_job.go(0);
        }

        public void enableGo(JASState state) {
            state.setEnabled(JASJob.this.m_job.isRunnable() && !JASJob.this.m_job.isAtEndOfData());
        }

        public void enableStep(JASState state) {
            state.setEnabled(JASJob.this.m_job.isRunnable() && !JASJob.this.m_job.isAtEndOfData());
        }

        public void enableRewind(JASState state) {
            state.setEnabled(!JASJob.this.m_job.isAtStartOfData());
        }

        public void enableKill(JASState state) {
            state.setEnabled(JASJob.this.m_job.isRunning());
        }

        public void enablePersistent(JASCheckboxState state) {
            state.setCheckbox(JASJob.this.m_job.isPersistent());
            state.setEnabled(true);
        }

        public void onPersistent(boolean persist) throws RemoteException {
            JASJob.this.m_job.setPersistent(persist);
            JASJob.this.m_changes++;
            this.setChanged();
        }

        @Override
        protected void setChanged() {
            super.setChanged();
            if (JASJob.this.m_stopMonitor != null) {
                JASJob.this.m_stopMonitor.doStopEnabling();
            }
        }

        void forceSetChanged() {
            super.setChanged();
        }
    }

    private static class JASListCellRenderer
    extends DefaultListCellRenderer {
        private JASListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                this.setIcon(((TreeNode)value).getIcon());
            }
            return this;
        }
    }

    private class JASTreeCellEditor
    extends DefaultTreeCellEditor {
        JASTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
            super(tree, renderer);
        }

        @Override
        protected void determineOffset(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.editingIcon = ((TreeNode)value).getIcon();
            if (this.editingIcon == null) {
                super.determineOffset(tree, value, isSelected, expanded, leaf, row);
            } else {
                this.offset = this.renderer.getIconTextGap() + this.editingIcon.getIconWidth();
            }
        }

        @Override
        protected TreeCellEditor createTreeCellEditor() {
            Border aBorder = UIManager.getBorder("Tree.editorBorder");
            DefaultCellEditor editor = new DefaultCellEditor(new DefaultTreeCellEditor.DefaultTextField(this, aBorder)){

                @Override
                public boolean shouldSelectCell(EventObject event) {
                    boolean retValue = super.shouldSelectCell(event);
                    this.getComponent().requestFocus();
                    return retValue;
                }

                @Override
                public boolean stopCellEditing() {
                    TreeNode node = (TreeNode)JASJob.this.m_tree.getEditingPath().getLastPathComponent();
                    if (node.getTreeAdaptor().stopEditing(this.getCellEditorValue().toString())) {
                        return super.stopCellEditing();
                    }
                    return false;
                }
            };
            editor.setClickCountToStart(1);
            return editor;
        }
    }

    private static class JASTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private JASTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            Icon icon = ((TreeNode)value).getIcon();
            if (icon != null) {
                this.setIcon(icon);
            }
            return this;
        }
    }

    class TreeNode
    extends OrderedNode
    implements TreeAdaptorSite,
    Serializable {
        private TreeAdaptor adaptor;

        TreeNode(String name, String type) {
            super(name, type, 0, JASJob.this);
        }

        TreeNode(TreeNode parent, String name, String type, int flags) {
            this(parent, name, type, flags, null);
        }

        private TreeNode(TreeNode parent, String name, String type, int flags, Object object) {
            super(parent, name, type, flags, object);
        }

        @Override
        protected SimpleNode createNode(SimpleNode parent, String name, String type, int flags, Object object) {
            return new TreeNode((TreeNode)parent, name, type, flags, object);
        }

        @Override
        public TreeAdaptor getTreeAdaptor() {
            if (this.adaptor == null && this.getType() != null) {
                try {
                    String s = this.getType();
                    s = s.indexOf(".") < 0 ? "jas2.swingstudio.adaptor." + s.substring(0, 1).toUpperCase() + s.substring(1) + "TreeAdaptor" : s + "TreeAdaptor";
                    Class<?> c = Class.forName(s);
                    this.adaptor = (TreeAdaptor)c.newInstance();
                    this.adaptor.setAdaptorSite(this);
                }
                catch (ClassNotFoundException x) {
                    this.adaptor = null;
                }
                catch (InstantiationException x) {
                    this.adaptor = null;
                }
                catch (IllegalAccessException x) {
                    this.adaptor = null;
                }
            }
            return this.adaptor;
        }

        void update() {
            int flags = this.getFlags();
            if ((flags & 0x80000) != 0 && this.adaptor == null) {
                this.getTreeAdaptor();
            }
            if (this.adaptor != null) {
                this.adaptor.updateNode(flags);
            }
        }

        @Override
        public Object getAssociatedObject() {
            return this.getObject();
        }

        @Override
        public PluginContext getPluginContext() {
            return JASJob.this.m_pluginContext;
        }

        @Override
        public TreeItem getTreeItem() {
            return JASJob.this.getTreeItem(this);
        }

        @Override
        public Job getJob() {
            return JASJob.this.m_job;
        }

        Icon getIcon() {
            try {
                return new JASIcon(this, "images/" + this.getType() + ".gif");
            }
            catch (ImageException x) {
                return null;
            }
        }

        @Override
        public TreeAdaptorSite getParentAdaptor() {
            return (TreeNode)this.getParent();
        }

        boolean isEditable() {
            TreeAdaptor ta = this.getTreeAdaptor();
            return ta == null ? false : ta.isEditable();
        }

        JPopupMenu getPopupMenu() {
            TreeAdaptor ta = this.getTreeAdaptor();
            return ta == null ? null : ta.getPopupMenu();
        }

        @Override
        public void startEditing() {
            SimpleNode node = this;
            int n = 0;
            while (node != null) {
                node = node.getParent();
                ++n;
            }
            Object[] nodes = new SimpleNode[n];
            node = this;
            int i = 1;
            while (node != null) {
                nodes[n - i] = node;
                node = node.getParent();
                ++i;
            }
            JASJob.this.m_tree.startEditingAtPath(new TreePath(nodes));
        }
    }

    private class ComboModel
    extends DefaultComboBoxModel {
        private ComboModel() {
        }

        @Override
        public void addElement(TreeNode node) {
            int index = this.getIndexOf(node);
            if (index < 0) {
                super.addElement(node);
            }
            if ((node.getFlags() & 0x40000) != 0 && this.getSelectedItem() != node) {
                this.setSelectedItem(node);
            }
        }
    }

    private class JobPluginContext
    extends JASPluginContext
    implements PluginContext {
        private Vector m_runListeners;

        JobPluginContext(JavaAnalysisStudio app) {
            super(app);
            this.m_runListeners = new Vector();
        }

        @Override
        public void addMenu(JMenu menu) {
            super.addMenu(menu);
            JASJob.this.m_pluginMenus.addElement(menu);
        }

        @Override
        public void removeMenu(JMenu menu) {
            super.removeMenu(menu);
            JASJob.this.m_pluginMenus.removeElement(menu);
        }

        @Override
        public void addRunListener(RunListener listener) {
            JASJob.this.m_job.addRunListener(listener);
        }

        @Override
        public void removeRunListener(RunListener listener) {
            JASJob.this.m_job.removeRunListener(listener);
        }

        @Override
        public EventData getCurrentEvent() throws NoEventAvailable {
            return JASJob.this.m_job.getEvent();
        }

        @Override
        public void sendJob(Object message) {
            JASJob.this.m_job.receiveMessage(message);
        }
    }
}

