/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.swingstudio.HasCommandProcessor;
import jas2.swingstudio.JASCommandProcessor;
import jas2.swingstudio.JASConsoleDocumentUtilities;
import jas2.swingstudio.JASConsoleScrollPane;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.util.CommandProcessor;
import jas2.util.JASCheckboxState;
import jas2.util.JASState;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;

public class JASConsoleTextArea
extends JTextArea
implements HasCommandProcessor {
    protected String lineSeparator = System.getProperty("line.separator");
    private boolean logFileOpened;
    private boolean loggingOn;
    private JPopupMenu theJASConsoleTabbedPanePopupMenu;
    private FileWriter logOutput;
    private JASConsoleTextAreaCommandProcessor commandProcessor;
    private JASConsoleScrollPane theScrollPane;

    public JASConsoleTextArea(JASConsoleScrollPane sp) {
        this.theScrollPane = sp;
        this.loggingOn = false;
        this.logFileOpened = false;
        this.commandProcessor = new JASConsoleTextAreaCommandProcessor();
        this.theJASConsoleTabbedPanePopupMenu = JavaAnalysisStudio.getApp().getXMLMenuBuilder().getPopupMenu("consolePopupMenu");
        this.enableEvents(16L);
    }

    @Override
    public CommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    protected JASConsoleTextArea getJASConsoleTextArea() {
        return this;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.isPopupTrigger()) {
            this.commandProcessor.forceSetChanged();
            this.theJASConsoleTabbedPanePopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public boolean isLogFileOpened() {
        return this.logFileOpened;
    }

    public void setLogFileOpened(boolean newState) {
        this.logFileOpened = newState;
    }

    public boolean isLoggingOn() {
        return this.loggingOn;
    }

    public void setLoggingOn(boolean newState) {
        this.loggingOn = newState;
    }

    public void forceCommandProcessorSetChanged() {
        this.commandProcessor.forceSetChanged();
    }

    public FileWriter getLogWriter() {
        return this.logOutput;
    }

    private class JASConsoleTextAreaCommandProcessor
    extends JASCommandProcessor {
        public void forceSetChanged() {
            this.setChanged();
        }

        public void onCopyConsoleSelection() {
            JASConsoleTextArea.this.copy();
        }

        public void enableCopyConsoleSelection(JASState state) {
            state.setEnabled(JASConsoleTextArea.this.getJASConsoleTextArea().getSelectedText() != null);
        }

        public void onClear() {
            JASConsoleDocumentUtilities.clearDoc(JASConsoleTextArea.this.getDocument());
        }

        public void enableClear(JASState state) {
            state.setEnabled(JASConsoleTextArea.this.getDocument().getLength() > 0);
        }

        public void onSelectAll() {
            JASConsoleTextArea.this.selectAll();
        }

        public void enableSelectAll(JASState state) {
            state.setEnabled(JASConsoleTextArea.this.getDocument().getLength() > 0);
        }

        public void onSetBufferSize() {
        }

        public void enableSetBufferSize(JASState state) {
            state.setEnabled(false);
        }

        public void onCloseTab() {
            if (JASConsoleTextArea.this.isLoggingOn()) {
                JASConsoleTextArea.this.setLogFileOpened(false);
                JASConsoleTextArea.this.setLoggingOn(false);
            }
            JASConsoleTextArea.this.theScrollPane.removeTab();
        }

        public void enableCloseTab(JASState state) {
            state.setEnabled(true);
        }

        public void onOpenLogFile() {
            JFileChooser chooser = new JFileChooser(JavaAnalysisStudio.getApp().getUserProperties().getString("LastProgramPath", System.getProperty("user.home")));
            chooser.setDialogTitle("Open or Create Log File...");
            int returnVal = chooser.showOpenDialog(JASConsoleTextArea.this);
            if (returnVal == 0) {
                File f = chooser.getSelectedFile();
                boolean failed = false;
                if (f.exists()) {
                    if (!f.canWrite()) {
                        JavaAnalysisStudio.getApp().error("Cannot write to the file " + f);
                        failed = true;
                    } else if (!f.delete()) {
                        JavaAnalysisStudio.getApp().error("Could not overwrite the file " + f);
                        failed = true;
                    }
                }
                if (!failed) {
                    try {
                        JASConsoleTextArea.this.logOutput = new FileWriter(f);
                        JASConsoleTextArea.this.logOutput.write("Log file created on " + new Date() + JASConsoleTextArea.this.lineSeparator);
                        JASConsoleTextArea.this.logOutput.flush();
                        JASConsoleTextArea.this.setLogFileOpened(true);
                    }
                    catch (IOException eh) {
                        JavaAnalysisStudio.getApp().error("Couldn't write to " + f.getName());
                    }
                }
            }
            if (!JASConsoleTextArea.this.isLoggingOn()) {
                this.onEnableLogging(true);
            }
        }

        public void enableOpenLogFile(JASState state) {
            state.setEnabled(!JASConsoleTextArea.this.isLogFileOpened());
        }

        public void onEnableLogging(boolean b) {
            JASConsoleTextArea.this.setLoggingOn(b);
            this.setChanged();
        }

        public void enableEnableLogging(JASCheckboxState state) {
            state.setCheckbox(JASConsoleTextArea.this.isLoggingOn());
            state.setEnabled(JASConsoleTextArea.this.isLogFileOpened());
        }

        public void onCloseLogFile() {
            try {
                JASConsoleTextArea.this.logOutput.write("Log file closed on " + new Date() + JASConsoleTextArea.this.lineSeparator);
                JASConsoleTextArea.this.logOutput.flush();
                JASConsoleTextArea.this.logOutput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JASConsoleTextArea.this.setLogFileOpened(false);
            JASConsoleTextArea.this.setLoggingOn(false);
        }

        public void enableCloseLogFile(JASState state) {
            state.setEnabled(JASConsoleTextArea.this.isLogFileOpened());
        }
    }
}

