/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.swingstudio.HasCommandProcessor;
import jas2.swingstudio.JASConsoleDocumentOutputStream;
import jas2.swingstudio.JASConsoleScrollPane;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.util.Application;
import jas2.util.CommandTargetManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.swing.JTabbedPane;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

class JASConsoleTabbedPane
extends JTabbedPane {
    private HasCommandProcessor prevSelected;
    private Hashtable outputStreams = new Hashtable();

    public JASConsoleTabbedPane() {
        this.init();
    }

    public JASConsoleTabbedPane(int tabPlacement) {
        super(tabPlacement);
        this.init();
    }

    public JASConsoleScrollPane getSelectedConsoleScrollPane() {
        return (JASConsoleScrollPane)this.getSelectedComponent();
    }

    @Override
    public void addTab(String title, Component component) {
        super.addTab(title, component);
        JavaAnalysisStudio.getApp().showJASConsole();
    }

    @Override
    public void remove(Component component) {
        super.remove(component);
        if (this.getTabCount() == 0) {
            JavaAnalysisStudio.getApp().hideJASConsole();
        } else {
            this.setCorrectCommandProcessor();
        }
    }

    public OutputStream getOutputStream(String s) {
        OutputStream result = (OutputStream)this.outputStreams.get(s);
        if (result != null) {
            return result;
        }
        SimpleAttributeSet a = new SimpleAttributeSet();
        StyleConstants.setForeground(a, new Color(58, 106, 122));
        PlainDocument doc = new PlainDocument();
        result = new JASConsoleDocumentOutputStream(doc, a, s, this);
        this.outputStreams.put(s, result);
        return result;
    }

    private void setCorrectCommandProcessor() {
        CommandTargetManager manager = Application.getApplication().getCommandManager();
        Component selected = this.getSelectedComponent();
        if (selected == this.prevSelected) {
            return;
        }
        if (this.prevSelected != null) {
            manager.remove(this.prevSelected.getCommandProcessor());
        }
        if (selected instanceof HasCommandProcessor) {
            this.prevSelected = (HasCommandProcessor)((Object)selected);
            manager.add(this.prevSelected.getCommandProcessor());
        } else {
            this.prevSelected = null;
        }
    }

    @Override
    protected void fireStateChanged() {
        super.fireStateChanged();
        this.setCorrectCommandProcessor();
    }

    private void init() {
        this.setMinimumSize(new Dimension(0, 0));
    }
}

