/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.swingstudio.HasCommandProcessor;
import jas2.swingstudio.JASConsoleDocumentOutputStream;
import jas2.swingstudio.JASConsoleDocumentWriter;
import jas2.swingstudio.JASConsoleTabbedPane;
import jas2.swingstudio.JASConsoleTextArea;
import jas2.util.CommandProcessor;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;

class JASConsoleScrollPane
extends JScrollPane
implements HasCommandProcessor {
    private boolean movedRecently = false;
    private JASConsoleTabbedPane theTabbedPane;
    private JASConsoleTextArea theTextArea;
    private AttributeSet outputAttr;
    private String myName;

    public JASConsoleScrollPane(String name, JASConsoleTabbedPane tp) {
        this.myName = name;
        this.theTabbedPane = tp;
        this.theTextArea = new JASConsoleTextArea(this);
        this.theTextArea.setEditable(false);
        JViewport vp = this.getViewport();
        vp.add(this.theTextArea);
        vp.setBackingStoreEnabled(true);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public JASConsoleTextArea getTheTextArea() {
        return this.theTextArea;
    }

    public JASConsoleTabbedPane getTheTabbedPane() {
        return this.theTabbedPane;
    }

    @Override
    public CommandProcessor getCommandProcessor() {
        return this.theTextArea.getCommandProcessor();
    }

    public PrintStream createPrintStream() {
        return this.createPrintStream(this.outputAttr);
    }

    public PrintStream createPrintStream(AttributeSet a) {
        Document doc = this.theTextArea.getDocument();
        JASConsoleDocumentOutputStream out = new JASConsoleDocumentOutputStream(doc, a, this.myName, this.theTabbedPane);
        PrintStream pOut = new PrintStream(out);
        return pOut;
    }

    public PrintWriter createPrintWriter() {
        return this.createPrintWriter(this.outputAttr);
    }

    public PrintWriter createPrintWriter(AttributeSet a) {
        Document doc = this.theTextArea.getDocument();
        JASConsoleDocumentWriter out = new JASConsoleDocumentWriter(doc, a, this.myName, this.theTabbedPane);
        PrintWriter pOut = new PrintWriter((Writer)out, true);
        return pOut;
    }

    public void setOutputAttributes(AttributeSet a) {
        this.outputAttr = a.copyAttributes();
    }

    public AttributeSet getOutputAttributes() {
        return this.outputAttr;
    }

    void removeTab() {
        this.theTabbedPane.remove(this);
    }

    void scrollToEnd() {
    }
}

