/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.swingstudio.JASConsoleDocumentUtilities;
import jas2.swingstudio.JASConsoleScrollPane;
import jas2.swingstudio.JASConsoleTabbedPane;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class JASConsoleDocumentOutputStream
extends OutputStream {
    private String theScrollPaneName;
    private byte[] one = new byte[1];
    private Document theDocument;
    private AttributeSet theAttributeSet;
    private JASConsoleTabbedPane theTabbedPane;

    public JASConsoleDocumentOutputStream(Document doc, AttributeSet a, String s, JASConsoleTabbedPane j) {
        this.theDocument = doc;
        this.theAttributeSet = a;
        this.theScrollPaneName = s;
        this.theTabbedPane = j;
    }

    @Override
    public void write(int b) throws IOException {
        this.one[0] = (byte)b;
        this.write(this.one, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            int theTabIndex = this.theTabbedPane.indexOfTab(this.theScrollPaneName);
            if (theTabIndex != -1) {
                this.theTabbedPane.setSelectedIndex(theTabIndex);
            } else {
                JASConsoleScrollPane theScrollPane = this.theTabbedPane.getSelectedConsoleScrollPane();
                JASConsoleScrollPane theNewScrollPane = new JASConsoleScrollPane(this.theScrollPaneName, this.theTabbedPane);
                this.theTabbedPane.addTab(this.theScrollPaneName, theNewScrollPane);
                theTabIndex = this.theTabbedPane.indexOfTab(this.theScrollPaneName);
                this.theTabbedPane.setSelectedIndex(theTabIndex);
                theNewScrollPane.getTheTextArea().setDocument(this.theDocument);
                theNewScrollPane.setOutputAttributes(this.theAttributeSet);
            }
            String s = new String(b, off, len);
            this.theDocument.insertString(this.theDocument.getLength(), s, this.theAttributeSet);
            this.appendToLog(s);
            JASConsoleDocumentUtilities.trimDoc(this.theDocument);
            this.theTabbedPane.getSelectedConsoleScrollPane().scrollToEnd();
        }
        catch (BadLocationException ble) {
            throw new IOException(ble.getMessage());
        }
    }

    private void appendToLog(String s) {
        JASConsoleScrollPane theScrollPane = this.theTabbedPane.getSelectedConsoleScrollPane();
        if (theScrollPane != null && theScrollPane.getTheTextArea().isLoggingOn()) {
            try {
                theScrollPane.getTheTextArea().getLogWriter().write(s);
                theScrollPane.getTheTextArea().getLogWriter().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

