/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.plot.HasPopupItems;
import jas2.plot.PopupMenuBuilder;
import jas2.plot.PrintHelper;
import jas2.swingstudio.Closable;
import jas2.swingstudio.HasCommandProcessor;
import jas2.swingstudio.JASCommandProcessor;
import jas2.swingstudio.JASHTMLEditorKit;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.util.CommandProcessor;
import jas2.util.JASMenuItem;
import jas2.util.JASState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class HTMLPage
extends JPanel
implements HasCommandProcessor,
HasPopupItems,
Closable {
    private JASHTMLEditorKit editorKit;
    private JEditorPane jep = new JEditorPane();
    private HTMLCommand htmlCommand = new HTMLCommand();
    private URLHistory urlHistory;
    private JavaAnalysisStudio app = JavaAnalysisStudio.getApp();

    HTMLPage(URL homePage) {
        super(new BorderLayout());
        this.jep.setEditable(false);
        this.jep.setMargin(new Insets(0, 0, 0, 0));
        this.editorKit = new JASHTMLEditorKit(this);
        this.jep.setEditorKitForContentType("text/html", this.editorKit);
        this.urlHistory = new URLHistory(homePage);
        try {
            this.jep.setPage(homePage);
        }
        catch (Exception x) {
            this.app.error("Could not open home page", x);
        }
        JScrollPane jsp = new JScrollPane(this.jep);
        jsp.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
        this.add((Component)jsp, "Center");
        this.jep.addHyperlinkListener(new SimpleLinkListener());
        this.jep.addMouseListener(new PopupMenuBuilder());
        this.jep.addCaretListener(this.htmlCommand);
    }

    @Override
    public boolean pleaseClose() {
        this.editorKit.destroy();
        return true;
    }

    @Override
    public void pageSelected(boolean state) {
    }

    @Override
    public CommandProcessor getCommandProcessor() {
        return this.htmlCommand;
    }

    void showURL(URL url) {
        SwingUtilities.invokeLater(new PageLoader(url));
    }

    @Override
    public void modifyPopupMenu(JPopupMenu menu, Component source) {
        if (menu.getComponentCount() > 0) {
            menu.addSeparator();
        }
        menu.add(new JASMenuItem("Copy", 'C'));
        menu.addSeparator();
        menu.add(new JASMenuItem("Home", 'H'));
        menu.add(new JASMenuItem("Back", 'B'));
        menu.add(new JASMenuItem("Forward", 'F'));
        menu.add(new JASMenuItem("Refresh", 'R'));
        menu.add(new JASMenuItem("Web Page...", 'W'));
    }

    class PageLoader
    implements Runnable {
        private URL url;
        private Cursor cursor;

        PageLoader(URL u) {
            this.url = u;
            this.cursor = HTMLPage.this.jep.getCursor();
            HTMLPage.this.jep.setCursor(Cursor.getPredefinedCursor(3));
        }

        @Override
        public void run() {
            try {
                HTMLPage.this.jep.setPage(this.url);
                HTMLPage.this.urlHistory.recordVisit(this.url);
                HTMLPage.this.htmlCommand.setChanged();
            }
            catch (IOException x) {
                HTMLPage.this.app.error("Could not load page " + this.url, x);
            }
            finally {
                HTMLPage.this.jep.setCursor(this.cursor);
            }
        }
    }

    private class HistoryItem
    extends JMenuItem {
        private URL url;

        HistoryItem(URL url) {
            super(url.toString());
            this.url = url;
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            HTMLPage.this.showURL(this.url);
            super.fireActionPerformed(e);
        }
    }

    private class URLHistory
    extends Vector {
        private ListItem m_current;

        URLHistory(URL root) {
            this.m_current = new ListItem(root);
            this.recordInHistory(root);
        }

        private void clear(ListItem i) {
            if (i == null) {
                return;
            }
            this.clear(i.next);
            i.prev = null;
            i.next = null;
            i.url = null;
        }

        void recordVisit(URL url) {
            if (this.m_current.next == null || !this.m_current.next.url.equals(url)) {
                this.clear(this.m_current.next);
                this.m_current.next = new ListItem(url);
                new ListItem(url).prev = this.m_current;
            }
            this.m_current = this.m_current.next;
            this.recordInHistory(url);
        }

        private void recordInHistory(URL url) {
            if (this.contains(url)) {
                this.removeElement(url);
            }
            this.insertElementAt(url, 0);
        }

        boolean enableForward() {
            return this.m_current.next != null;
        }

        void goForward() throws IOException {
            this.m_current = this.m_current.next;
            HTMLPage.this.jep.setPage(this.m_current.url);
        }

        boolean enableBack() {
            return this.m_current.prev != null;
        }

        void goBack() throws IOException {
            this.m_current = this.m_current.prev;
            HTMLPage.this.jep.setPage(this.m_current.url);
        }

        void reload() throws IOException {
            HTMLPage.this.jep.getDocument().putProperty("stream", null);
            HTMLPage.this.jep.setPage(this.m_current.url);
        }

        boolean enableHistory() {
            return this.size() > 0;
        }

        private class ListItem {
            URL url;
            ListItem next;
            ListItem prev;

            ListItem(URL url) {
                this.url = url;
            }
        }
    }

    private class SimpleLinkListener
    implements HyperlinkListener {
        private SimpleLinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent he) {
            HyperlinkEvent.EventType type = he.getEventType();
            if (type == HyperlinkEvent.EventType.ENTERED) {
                URL url = he.getURL();
                if (url != null) {
                    HTMLPage.this.jep.setCursor(Cursor.getPredefinedCursor(12));
                    HTMLPage.this.app.setMessage(url.toString());
                }
            } else if (type == HyperlinkEvent.EventType.EXITED) {
                HTMLPage.this.jep.setCursor(Cursor.getDefaultCursor());
                HTMLPage.this.app.setMessage(" ");
            } else if (he instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)he;
                HTMLDocument doc = (HTMLDocument)HTMLPage.this.jep.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                HTMLPage.this.showURL(he.getURL());
            }
        }
    }

    private class HTMLCommand
    extends JASCommandProcessor
    implements CaretListener {
        private HTMLCommand() {
        }

        public void onPrint() throws Exception {
            PrintHelper ph = PrintHelper.instance();
            ph.printTarget(HTMLPage.this.jep);
        }

        public void onRefresh() throws IOException {
            HTMLPage.this.urlHistory.reload();
        }

        public void onBack() throws IOException {
            HTMLPage.this.urlHistory.goBack();
            this.setChanged();
        }

        public void onForward() throws IOException {
            HTMLPage.this.urlHistory.goForward();
            this.setChanged();
        }

        public void enableBack(JASState state) {
            state.setEnabled(HTMLPage.this.urlHistory.enableBack());
        }

        public void enableForward(JASState state) {
            state.setEnabled(HTMLPage.this.urlHistory.enableForward());
        }

        public void onCopy() {
            HTMLPage.this.jep.copy();
        }

        public void enableCopy(JASState state) {
            state.setEnabled(HTMLPage.this.jep.getSelectedText() != null);
        }

        @Override
        public void setChanged() {
            super.setChanged();
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            this.setChanged();
        }
    }
}

