/*
 * Decompiled with CFR 0.152.
 */
package jas2.plot;

import jas2.plot.Axis;
import jas2.plot.ColorMap;
import jas2.plot.DoubleAxis;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;

public class ColorMapAxis
extends Axis {
    private ColorMap colorMap;

    public ColorMapAxis(ColorMap colorMap) {
        super(1, false);
        this.colorMap = colorMap;
    }

    public void setZminZmax(double zmin, double zmax) {
        ((DoubleAxis)this.getType()).setMin(zmin);
        ((DoubleAxis)this.getType()).setMax(zmax);
    }

    public void setLogarithmic(boolean isLog) {
        ((DoubleAxis)this.getType()).setLogarithmic(isLog);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        double ww = 30 - insets.left - insets.right - 3;
        double hh = size.getHeight() - (double)insets.top - (double)insets.bottom - 7.0;
        double x1 = insets.left + 2;
        double x2 = x1 + ww;
        double yy = insets.top + 3;
        Line2D.Double line = new Line2D.Double();
        int i = 0;
        while ((double)i < hh) {
            ((Line2D)line).setLine(x1, yy, x2, yy);
            g2.setPaint(this.colorMap.getColor(1.0 - (double)i / hh));
            g2.draw(line);
            yy += 1.0;
            ++i;
        }
    }
}

