/*
 * Decompiled with CFR 0.152.
 */
package jas2.jds.module;

import jas2.jds.module.BasicLocalDIM;
import jas2.swingstudio.MultiFilePanel;
import jas2.util.Application;
import jas2.util.JASWizardPage;
import jas2.util.UserProperties;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public abstract class MultiFileLocalDIM
extends BasicLocalDIM {
    private UserProperties prop = Application.getApplication().getUserProperties();
    private final String key = this.getClass().getName();
    private static final String MULTI = "MULTI";
    private static final String SINGLE = "SINGLE";

    public MultiFileLocalDIM(FileFilter f) {
        super(f);
    }

    public MultiFileLocalDIM(String description, String filetype) {
        super(description, filetype);
    }

    @Override
    public JASWizardPage getSetupPage() {
        return new MultiFileWizardPage();
    }

    class MultiFileWizardPage
    extends BasicLocalDIM.BasicWizardPage
    implements ActionListener {
        private JPanel card;
        private CardLayout layout = new CardLayout();
        private JCheckBox multi;
        private MultiFilePanel multiFilePanel;

        MultiFileWizardPage() {
            this.remove(this.m_filePanel);
            this.card = new JPanel(this.layout);
            this.card.add((Component)this.m_filePanel, MultiFileLocalDIM.SINGLE);
            this.multiFilePanel = new MultiFilePanel(MultiFileLocalDIM.this.getFileFilter(), null, "Files to Open", MultiFileLocalDIM.this.key);
            this.card.add((Component)this.multiFilePanel, MultiFileLocalDIM.MULTI);
            this.add((Component)this.card, "Center");
            this.multi = new JCheckBox("Append multiple files together to form one logical dataset");
            this.add((Component)this.multi, "South");
            boolean isMulti = MultiFileLocalDIM.this.prop.getBoolean(MultiFileLocalDIM.this.key + ".multi", false);
            this.layout.show(this.card, isMulti ? MultiFileLocalDIM.MULTI : MultiFileLocalDIM.SINGLE);
            this.multi.setSelected(isMulti);
            this.multi.addActionListener(this);
        }

        @Override
        public void onFinish() {
            if (!this.multi.isSelected()) {
                super.onFinish();
            } else {
                int count = this.multiFilePanel.getNFiles();
                if (count == 0) {
                    JOptionPane.showMessageDialog(this, "You must add at least one file.", "Error...", 0);
                    return;
                }
                MultiFileLocalDIM.this.m_ljb.createJob(this.multiFilePanel.getFilePath());
                this.multiFilePanel.saveState();
                this.dispose();
            }
            MultiFileLocalDIM.this.prop.setBoolean(MultiFileLocalDIM.this.key + ".multi", this.multi.isSelected());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.layout.show(this.card, this.multi.isSelected() ? MultiFileLocalDIM.MULTI : MultiFileLocalDIM.SINGLE);
        }
    }
}

